/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionVTwoPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ConstantFieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaClassGroupOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.RoleToActivityPredicatePreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vivoweb.webapp.util.ModelUtils;

public abstract class AddRoleToPersonTwoStageGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddRoleToPersonTwoStageGenerator.class);
    private final String VIVO_NS = "http://vivoweb.org/ontology/core#";
    private final String RoleToIntervalURI = "http://vivoweb.org/ontology/core#dateTimeInterval";
    private final String IntervalTypeURI = "http://vivoweb.org/ontology/core#DateTimeInterval";
    private final String IntervalToStartURI = "http://vivoweb.org/ontology/core#start";
    private final String IntervalToEndURI = "http://vivoweb.org/ontology/core#end";
    private final String StartYearPredURI = "http://vivoweb.org/ontology/core#startYear";
    private final String EndYearPredURI = "http://vivoweb.org/ontology/core#endYear";
    private final String DateTimeValueTypeURI = "http://vivoweb.org/ontology/core#DateTimeValue";
    private final String DateTimePrecisionURI = "http://vivoweb.org/ontology/core#dateTimePrecision";
    private final String DateTimeValueURI = "http://vivoweb.org/ontology/core#dateTime";
    private final String N3_PREFIX = "@prefix core: <http://vivoweb.org/ontology/core#> .";

    abstract String getTemplate();

    abstract String getRoleType();

    abstract FieldOptions getRoleActivityFieldOptions(VitroRequest var1) throws Exception;

    abstract boolean isShowRoleLabelField();

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initProcessParameters(vreq, session, editConfiguration);
        editConfiguration.setVarNameForSubject("person");
        editConfiguration.setVarNameForPredicate("rolePredicate");
        editConfiguration.setVarNameForObject("role");
        editConfiguration.setN3Required(AddRoleToPersonTwoStageGenerator.list((Object[])new Object[]{"@prefix core: <http://vivoweb.org/ontology/core#> .\n?person ?rolePredicate ?role .\n?role a ?roleType .\n?role ?inverseRolePredicate ?person ."}));
        editConfiguration.setN3Optional(AddRoleToPersonTwoStageGenerator.list((Object[])new Object[]{this.getN3ForNewRoleActivity(), this.getN3ForExistingRoleActivity(), this.getN3RoleLabelAssertion(), this.getN3ForStart(), this.getN3ForEnd()}));
        editConfiguration.setNewResources(this.newResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        editConfiguration.setTemplate(this.getTemplate());
        editConfiguration.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        editConfiguration.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingRoleActivity", "activityLabel"));
        this.addPreprocessors(editConfiguration, vreq.getWebappDaoFactory());
        this.addFormSpecificData(editConfiguration, vreq);
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    private void initProcessParameters(VitroRequest vreq, HttpSession session, EditConfigurationVTwo editConfiguration) {
        editConfiguration.setFormUrl(EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq));
        editConfiguration.setEntityToReturnTo(EditConfigurationUtils.getSubjectUri((VitroRequest)vreq));
    }

    private List<String> getN3ForNewRoleActivity() {
        ArrayList<String> n3ForNewRoleActivity = new ArrayList<String>();
        n3ForNewRoleActivity.add("?role " + this.getRoleToActivityPlaceholder() + " ?roleActivity .\n" + "?roleActivity " + this.getActivityToRolePlaceholder() + " ?role . \n" + "?roleActivity <" + RDFS.label.getURI() + "> ?activityLabel . \n" + "?roleActivity a ?roleActivityType .");
        return n3ForNewRoleActivity;
    }

    private List<String> getN3ForExistingRoleActivity() {
        ArrayList<String> n3ForExistingRoleActivity = new ArrayList<String>();
        n3ForExistingRoleActivity.add("?role " + this.getRoleToActivityPlaceholder() + " ?existingRoleActivity .\n" + "?existingRoleActivity " + this.getActivityToRolePlaceholder() + " ?role . \n" + "?existingRoleActivity a ?roleActivityType .");
        return n3ForExistingRoleActivity;
    }

    private String getN3RoleLabelAssertion() {
        return "?role <" + RDFS.label.getURI() + "> ?roleLabel .";
    }

    private List<String> getN3ForStart() {
        ArrayList<String> n3ForStart = new ArrayList<String>();
        n3ForStart.add("?role  <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .?intervalNode  <" + RDF.type.getURI() + "> <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> ." + "?intervalNode <" + "http://vivoweb.org/ontology/core#start" + "> ?startNode ." + "?startNode  <" + RDF.type.getURI() + "> <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> ." + "?startNode  <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?startField-value ." + "?startNode  <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?startField-precision .");
        return n3ForStart;
    }

    private List<String> getN3ForEnd() {
        ArrayList<String> n3ForEnd = new ArrayList<String>();
        n3ForEnd.add("?role      <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .  ?intervalNode  <" + RDF.type.getURI() + "> <" + "http://vivoweb.org/ontology/core#DateTimeInterval" + "> ." + "?intervalNode <" + "http://vivoweb.org/ontology/core#end" + "> ?endNode ." + "?endNode  <" + RDF.type.getURI() + "> <" + "http://vivoweb.org/ontology/core#DateTimeValue" + "> ." + "?endNode  <" + "http://vivoweb.org/ontology/core#dateTime" + "> ?endField-value ." + "?endNode  <" + "http://vivoweb.org/ontology/core#dateTimePrecision" + "> ?endField-precision .");
        return n3ForEnd;
    }

    private Map<String, String> newResources(VitroRequest vreq) {
        Object DEFAULT_NS_TOKEN = null;
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("role", (String)DEFAULT_NS_TOKEN);
        newResources.put("roleActivity", (String)DEFAULT_NS_TOKEN);
        newResources.put("intervalNode", (String)DEFAULT_NS_TOKEN);
        newResources.put("startNode", (String)DEFAULT_NS_TOKEN);
        newResources.put("endNode", (String)DEFAULT_NS_TOKEN);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List> urisInScope = new HashMap<String, List>();
        urisInScope.put("inverseRolePredicate", this.getInversePredicate(vreq));
        urisInScope.put("roleType", AddRoleToPersonTwoStageGenerator.list((Object[])new Object[]{this.getRoleType()}));
        editConfiguration.setUrisInScope(urisInScope);
    }

    private List<String> getInversePredicate(VitroRequest vreq) {
        ArrayList<String> inversePredicateArray = new ArrayList<String>();
        ObjectProperty op = EditConfigurationUtils.getObjectProperty((VitroRequest)vreq);
        if (op != null && op.getURIInverse() != null) {
            inversePredicateArray.add(op.getURIInverse());
        }
        return inversePredicateArray;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        urisOnForm.add("existingRoleActivity");
        urisOnForm.add("roleActivityType");
        urisOnForm.add("roleToActivityPredicate");
        urisOnForm.add("activityToRolePredicate");
        editConfiguration.setUrisOnform(urisOnForm);
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add("activityLabel");
        literalsOnForm.add("activityLabelDisplay");
        literalsOnForm.add("roleLabel");
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("activityLabel", this.getActivityLabelQuery(vreq));
        map.put("roleLabel", this.getRoleLabelQuery(vreq));
        map.put("startField-value", this.getExistingStartDateQuery(vreq));
        map.put("endField-value", this.getExistingEndDateQuery(vreq));
        editConfiguration.setSparqlForExistingLiterals(map);
        map = new HashMap();
        map.put("existingRoleActivity", this.getExistingRoleActivityQuery(vreq));
        map.put("roleActivityType", this.getActivityTypeQuery(vreq));
        map.put("intervalNode", this.getIntervalNodeQuery(vreq));
        map.put("startNode", this.getStartNodeQuery(vreq));
        map.put("endNode", this.getEndNodeQuery(vreq));
        map.put("startField-precision", this.getStartPrecisionQuery(vreq));
        map.put("endField-precision", this.getEndPrecisionQuery(vreq));
        map.put("roleToActivityPredicate", this.getRoleToActivityPredicateQuery(vreq));
        map.put("activityToRolePredicate", this.getActivityToRolePredicateQuery(vreq));
        editConfiguration.setSparqlForExistingUris(map);
    }

    private String getActivityToRolePredicateQuery(VitroRequest vreq) {
        String query = "SELECT ?existingActivityToRolePredicate \n WHERE { \n?roleActivity ?existingActivityToRolePredicate ?role .\n";
        ArrayList<String> addToQuery = new ArrayList<String>();
        List<String> predicates = this.getPossibleActivityToRolePredicates();
        for (String p : predicates) {
            addToQuery.add("(?existingActivityToRolePredicate=<" + p + ">)");
        }
        query = query + "FILTER (" + StringUtils.join(addToQuery, (String)" || ") + ")\n";
        query = query + "}";
        return query;
    }

    private String getRoleToActivityPredicateQuery(VitroRequest vreq) {
        String query = "SELECT ?existingRoleToActivityPredicate \n WHERE { \n?role ?existingRoleToActivityPredicate ?roleActivity .\n";
        query = query + this.getFilterRoleToActivityPredicate("existingRoleToActivityPredicate");
        query = query + "\n}";
        return query;
    }

    private String getEndPrecisionQuery(VitroRequest vreq) {
        String query = "SELECT ?existingEndPrecision WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .  \n?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";
        return query;
    }

    private String getStartPrecisionQuery(VitroRequest vreq) {
        String query = "SELECT ?existingStartPrecision WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .  \n?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
        return query;
    }

    private String getEndNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingEndNode WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n?existingEndNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}\n";
        return query;
    }

    private String getStartNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingStartNode WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n?existingStartNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}";
        return query;
    }

    private String getIntervalNodeQuery(VitroRequest vreq) {
        String query = "SELECT ?existingIntervalNode WHERE { \n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode . \n ?existingIntervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> . }\n";
        return query;
    }

    protected String getActivityTypeQueryForConstantOptions(VitroRequest vreq, ConstantFieldOptions fieldOptions) throws Exception {
        Map options = fieldOptions.getOptions(null, null, null);
        if (options != null && options.size() > 0) {
            ArrayList<String> typeUris = new ArrayList<String>();
            for (String typeUri : options.keySet()) {
                if (typeUri == null || typeUri.isEmpty()) continue;
                typeUris.add("(?existingActivityType = <" + typeUri + ">)");
            }
            String defaultActivityTypeQuery = this.getDefaultActivityTypeQuery(vreq);
            String typeFilters = "FILTER (" + StringUtils.join(typeUris, (String)"||") + ")";
            return defaultActivityTypeQuery.replaceAll("}$", "") + typeFilters + "}";
        }
        return this.getDefaultActivityTypeQuery(vreq);
    }

    protected String getActivityTypeQueryForChildVClassOptions(VitroRequest vreq, ChildVClassesOptions opts) {
        this.log.debug((Object)("objectClassUri = " + opts.getClassUri()));
        return QueryUtils.subUriForQueryVar((String)this.getSubclassActivityTypeQuery(vreq), (String)"objectClassUri", (String)opts.getClassUri());
    }

    protected String getActivityTypeQueryForIndividualsViaClassGroupOptions(VitroRequest vreq, IndividualsViaClassGroupOptions opts) {
        this.log.debug((Object)("ClassGroupUri = " + opts.getClassGroupUri()));
        return QueryUtils.subUriForQueryVar((String)this.getClassgroupActivityTypeQuery(vreq), (String)"classgroup", (String)opts.getClassGroupUri());
    }

    private String getActivityTypeQuery(VitroRequest vreq) throws Exception {
        String activityTypeQuery = null;
        FieldOptions fieldOpts = this.getRoleActivityFieldOptions(vreq);
        try {
            if (fieldOpts == null) {
                activityTypeQuery = this.getDefaultActivityTypeQuery(vreq);
            }
            if (fieldOpts instanceof ConstantFieldOptions) {
                activityTypeQuery = this.getActivityTypeQueryForConstantOptions(vreq, (ConstantFieldOptions)fieldOpts);
            } else if (fieldOpts instanceof ChildVClassesOptions) {
                activityTypeQuery = this.getActivityTypeQueryForChildVClassOptions(vreq, (ChildVClassesOptions)fieldOpts);
            } else if (fieldOpts instanceof IndividualsViaClassGroupOptions) {
                activityTypeQuery = this.getActivityTypeQueryForIndividualsViaClassGroupOptions(vreq, (IndividualsViaClassGroupOptions)fieldOpts);
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"error while building activity type query", (Throwable)ex);
        }
        activityTypeQuery = this.getDefaultActivityTypeQuery(vreq);
        activityTypeQuery = QueryUtils.replaceQueryVar((String)activityTypeQuery, (String)"predicate", (String)this.getRoleToActivityPlaceholderName());
        this.log.debug((Object)("Activity type query: " + activityTypeQuery));
        return activityTypeQuery;
    }

    private String getDefaultActivityTypeQuery(VitroRequest vreq) {
        String query = "PREFIX core: <http://vivoweb.org/ontology/core#>\nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingActivityType WHERE { \n    ?role ?predicate ?existingActivity . \n    ?existingActivity vitro:mostSpecificType ?existingActivityType . \n";
        query = query + this.getFilterRoleToActivityPredicate("predicate");
        query = query + "}";
        return query;
    }

    private String getSubclassActivityTypeQuery(VitroRequest vreq) {
        String query = "PREFIX core: <http://vivoweb.org/ontology/core#>\nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingActivityType WHERE {\n    ?role ?predicate ?existingActivity . \n    ?existingActivity vitro:mostSpecificType ?existingActivityType . \n    ?existingActivityType rdfs:subClassOf ?objectClassUri . \n";
        query = query + this.getFilterRoleToActivityPredicate("predicate");
        query = query + "}";
        return query;
    }

    private String getClassgroupActivityTypeQuery(VitroRequest vreq) {
        String query = "PREFIX core: <http://vivoweb.org/ontology/core#>\nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingActivityType WHERE { \n    ?role ?predicate ?existingActivity . \n    ?existingActivity vitro:mostSpecificType ?existingActivityType . \n    ?existingActivityType vitro:inClassGroup ?classgroup . \n";
        query = query + this.getFilterRoleToActivityPredicate("predicate");
        query = query + "}";
        return query;
    }

    private String getExistingRoleActivityQuery(VitroRequest vreq) {
        String query = "PREFIX core: <http://vivoweb.org/ontology/core#>";
        query = query + "SELECT ?existingRoleActivity WHERE { \n ?role ?predicate ?existingRoleActivity . \n ";
        query = query + this.getFilterRoleToActivityPredicate("predicate");
        query = query + "}";
        return query;
    }

    private String getExistingEndDateQuery(VitroRequest vreq) {
        String query = " SELECT ?existingEndDate WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
        return query;
    }

    private String getExistingStartDateQuery(VitroRequest vreq) {
        String query = "SELECT ?existingDateStart WHERE {\n?role <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
        return query;
    }

    private String getRoleLabelQuery(VitroRequest vreq) {
        String query = "SELECT ?existingRoleLabel WHERE { \n?role  <http://www.w3.org/2000/01/rdf-schema#label> ?existingRoleLabel . }";
        return query;
    }

    private String getActivityLabelQuery(VitroRequest vreq) {
        String query = "PREFIX core: <http://vivoweb.org/ontology/core#>PREFIX rdfs: <" + RDFS.getURI() + "> \n";
        query = query + "SELECT ?existingTitle WHERE { \n?role ?predicate ?existingActivity . \n?existingActivity rdfs:label ?existingTitle . \n";
        query = query + this.getFilterRoleToActivityPredicate("predicate");
        query = query + "}";
        return query;
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) throws Exception {
        HashMap<String, FieldVTwo> fields = new HashMap<String, FieldVTwo>();
        this.getActivityLabelField(editConfiguration, vreq, fields);
        this.getActivityLabelDisplayField(editConfiguration, vreq, fields);
        this.getRoleActivityTypeField(editConfiguration, vreq, fields);
        this.getExistingRoleActivityField(editConfiguration, vreq, fields);
        this.getRoleLabelField(editConfiguration, vreq, fields);
        this.getStartField(editConfiguration, vreq, fields);
        this.getEndField(editConfiguration, vreq, fields);
        this.getRoleToActivityPredicateField(editConfiguration, vreq, fields);
        this.getActivityToRolePredicateField(editConfiguration, vreq, fields);
        editConfiguration.setFields(fields);
    }

    private void getActivityToRolePredicateField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "activityToRolePredicate";
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(stringDatatypeUri);
        fields.put(field.getName(), field);
    }

    private void getRoleToActivityPredicateField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "roleToActivityPredicate";
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(stringDatatypeUri);
        fields.put(field.getName(), field);
    }

    private void getActivityLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "activityLabel";
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(stringDatatypeUri);
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("datatype:" + stringDatatypeUri);
        field.setValidators(validators);
        fields.put(field.getName(), field);
    }

    private void getActivityLabelDisplayField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "activityLabelDisplay";
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(stringDatatypeUri);
        fields.put(field.getName(), field);
    }

    private void getRoleActivityTypeField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) throws Exception {
        String fieldName = "roleActivityType";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        ArrayList<String> validators = new ArrayList<String>();
        if (this.isAddMode(vreq) || this.isRepairMode(vreq)) {
            validators.add("nonempty");
        }
        field.setValidators(validators);
        field.setOptions(this.getRoleActivityFieldOptions(vreq));
        fields.put(field.getName(), field);
    }

    private void getExistingRoleActivityField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "existingRoleActivity";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        fields.put(field.getName(), field);
    }

    private void getRoleLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        String fieldName = "roleLabel";
        FieldVTwo field = new FieldVTwo();
        field.setName(fieldName);
        String stringDatatypeUri = XSD.xstring.toString();
        field.setRangeDatatypeUri(stringDatatypeUri);
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("datatype:" + stringDatatypeUri);
        field.setValidators(validators);
        fields.put(field.getName(), field);
    }

    private void getStartField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "startField";
        field.setName(fieldName);
        field.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(field, this.getStartDatePrecision(), VitroVocabulary.Precision.NONE.uri()));
        fields.put(field.getName(), field);
    }

    private void getEndField(EditConfigurationVTwo editConfiguration, VitroRequest vreq, Map<String, FieldVTwo> fields) {
        FieldVTwo field = new FieldVTwo();
        String fieldName = "endField";
        field.setName(fieldName);
        field.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(field, this.getEndDatePrecision(), VitroVocabulary.Precision.NONE.uri()));
        fields.put(field.getName(), field);
    }

    private void addPreprocessors(EditConfigurationVTwo editConfiguration, WebappDaoFactory wadf) {
        editConfiguration.addEditSubmissionPreprocessor((EditSubmissionVTwoPreprocessor)new RoleToActivityPredicatePreprocessor(editConfiguration, wadf));
    }

    public String getRoleToActivityPredicate(VitroRequest vreq) {
        return this.getRoleToActivityPlaceholder();
    }

    public List<String> getPossibleRoleToActivityPredicates() {
        return ModelUtils.getPossiblePropertiesForRole();
    }

    public List<String> getPossibleActivityToRolePredicates() {
        return ModelUtils.getPossibleInversePropertiesForRole();
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        List<String> roleToGrantPredicates = this.getPossibleRoleToActivityPredicates();
        return EditModeUtils.getEditMode((VitroRequest)vreq, roleToGrantPredicates);
    }

    private boolean isAddMode(VitroRequest vreq) {
        return EditModeUtils.isAddMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    private boolean isEditMode(VitroRequest vreq) {
        return EditModeUtils.isEditMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    private boolean isRepairMode(VitroRequest vreq) {
        return EditModeUtils.isRepairMode((FrontEndEditingUtils.EditMode)this.getEditMode(vreq));
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        ArrayList<String> objectSelect = new ArrayList<String>();
        objectSelect.add("roleActivityType");
        formSpecificData.put("objectSelect", objectSelect);
        formSpecificData.put("showRoleLabelField", this.isShowRoleLabelField());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public String getFilterRoleToActivityPredicate(String predicateVar) {
        String addFilter = "FILTER (";
        List<String> predicates = this.getPossibleRoleToActivityPredicates();
        ArrayList<String> filterPortions = new ArrayList<String>();
        for (String p : predicates) {
            filterPortions.add("(?" + predicateVar + "=<" + p + ">)");
        }
        addFilter = addFilter + StringUtils.join(filterPortions, (String)" || ");
        addFilter = addFilter + ")";
        return addFilter;
    }

    private String getRoleToActivityPlaceholder() {
        return "?" + this.getRoleToActivityPlaceholderName();
    }

    private String getRoleToActivityPlaceholderName() {
        return "roleToActivityPredicate";
    }

    private String getActivityToRolePlaceholder() {
        return "?activityToRolePredicate";
    }

    protected String getStartDatePrecision() {
        String precision = VitroVocabulary.Precision.YEAR.uri();
        return precision;
    }

    protected String getEndDatePrecision() {
        String precision = VitroVocabulary.Precision.YEAR.uri();
        return precision;
    }

    public static enum RoleActivityOptionTypes {
        VCLASSGROUP,
        CHILD_VCLASSES,
        HARDCODED_LITERALS;

    }
}

