/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.AddEditWebpageFormGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageWebpagesForIndividualGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(ManageWebpagesForIndividualGenerator.class);
    private static String WEBPAGE_MODEL = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#>\nCONSTRUCT\n{\n    ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard .\n    ?vcard vcard:hasURL ?link .\n    ?link a vcard:URL .\n    ?link vcard:url ?url .\n    ?link rdfs:label ?linkLabel .\n    ?link core:rank ?rank .\n    ?link vitro:mostSpecificType ?type .\n    ?type rdfs:label ?typeLabel .\n}\nWHERE\n{\n    {\n        ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard .\n        ?vcard vcard:hasURL ?link .\n        ?link a vcard:URL .\n    }\n    UNION\n    {\n        ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard .\n        ?vcard vcard:hasURL ?link .\n        ?link a vcard:URL .\n        ?link vcard:url ?url .\n    }\n    UNION\n    {\n        ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard .\n        ?vcard vcard:hasURL ?link .\n        ?link a vcard:URL .\n        ?link rdfs:label ?linkLabel .\n    }\n    UNION\n    {\n        ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard . \n        ?vcard vcard:hasURL ?link .\n        ?link a vcard:URL .\n        ?link core:rank ?rank .\n    }\n    UNION\n    {\n        ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard .\n        ?vcard vcard:hasURL ?link .\n        ?link a vcard:URL .\n        ?link vitro:mostSpecificType ?type .\n        ?type rdfs:label ?typeLabel .\n    }\n}\n";
    private static String WEBPAGE_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT DISTINCT ?vcard ?link ?url ?rank ?typeLabel (group_concat(distinct ?linkLabel;separator=\"/\") as ?label) WHERE { \n    ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard . \n    ?vcard vcard:hasURL ?link . \n    ?link a vcard:URL \n    OPTIONAL { ?link vcard:url ?url } \n    OPTIONAL { ?link rdfs:label ?linkLabel } \n    OPTIONAL { ?link core:rank ?rank } \n    OPTIONAL { ?link vitro:mostSpecificType ?type } \n    OPTIONAL { ?type rdfs:label ?typeLabel } \n} GROUP BY ?rank ?vcard ?link ?url ?typeLabel \n  ORDER BY ?rank";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setTemplate(this.getTemplate());
        this.initBasics(config, vreq);
        this.initPropertyParameters(vreq, session, config);
        this.initObjectPropForm(config, vreq);
        config.setSubjectUri(EditConfigurationUtils.getSubjectUri((VitroRequest)vreq));
        config.setEntityToReturnTo(EditConfigurationUtils.getSubjectUri((VitroRequest)vreq));
        List<Map<String, String>> webpages = this.getWebpages(config.getSubjectUri(), vreq);
        config.addFormSpecificData("webpages", webpages);
        config.addFormSpecificData("rankPredicate", (Object)"http://vivoweb.org/ontology/core#rank");
        config.addFormSpecificData("reorderUrl", (Object)"/edit/reorder");
        config.addFormSpecificData("deleteWebpageUrl", (Object)"/edit/primitiveDelete");
        UrlBuilder.ParamMap paramMap = new UrlBuilder.ParamMap();
        paramMap.put((Object)"subjectUri", (Object)config.getSubjectUri());
        paramMap.put((Object)"editForm", (Object)this.getEditForm());
        paramMap.put((Object)"view", (Object)"form");
        String path = UrlBuilder.getUrl((UrlBuilder.Route)UrlBuilder.Route.EDIT_REQUEST_DISPATCH, (UrlBuilder.ParamMap)paramMap);
        config.addFormSpecificData("baseEditWebpageUrl", (Object)path);
        String domainUri = vreq.getParameter("domainUri");
        String rangeUri = vreq.getParameter("rangeUri");
        paramMap = new UrlBuilder.ParamMap();
        paramMap.put((Object)"subjectUri", (Object)config.getSubjectUri());
        paramMap.put((Object)"predicateUri", (Object)config.getPredicateUri());
        paramMap.put((Object)"editForm", (Object)this.getEditForm());
        paramMap.put((Object)"cancelTo", (Object)"manage");
        if (domainUri != null && !domainUri.isEmpty()) {
            paramMap.put((Object)"domainUri", (Object)domainUri);
        }
        if (rangeUri != null && !rangeUri.isEmpty()) {
            paramMap.put((Object)"rangeUri", (Object)rangeUri);
        }
        path = UrlBuilder.getUrl((UrlBuilder.Route)UrlBuilder.Route.EDIT_REQUEST_DISPATCH, (UrlBuilder.ParamMap)paramMap);
        config.addFormSpecificData("showAddFormUrl", (Object)path);
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(config.getSubjectUri());
        if (subject != null && subject.getName() != null) {
            config.addFormSpecificData("subjectName", (Object)subject.getName());
        } else {
            config.addFormSpecificData("subjectName", null);
        }
        this.prepare(vreq, config);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> getWebpages(String subjectUri, VitroRequest vreq) {
        RDFService rdfService = vreq.getRDFService();
        ArrayList<Map<String, String>> webpages = new ArrayList<Map<String, String>>();
        try {
            String constructStr = QueryUtils.subUriForQueryVar((String)WEBPAGE_MODEL, (String)"subject", (String)subjectUri);
            Model constructedModel = ModelFactory.createDefaultModel();
            rdfService.sparqlConstructQuery(constructStr, constructedModel);
            String queryStr = QueryUtils.subUriForQueryVar((String)this.getQuery(), (String)"subject", (String)subjectUri);
            log.debug((Object)("Query string is: " + queryStr));
            try (QueryExecution qe = QueryExecutionFactory.create((String)queryStr, (Model)constructedModel);){
                ResultSet results = qe.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    RDFNode node = soln.get("link");
                    if (node == null || !node.isURIResource()) continue;
                    webpages.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        log.debug((Object)("webpages = " + webpages));
        return webpages;
    }

    protected String getEditForm() {
        return AddEditWebpageFormGenerator.class.getName();
    }

    protected String getQuery() {
        return WEBPAGE_QUERY;
    }

    protected String getTemplate() {
        return "manageWebpagesForIndividual.ftl";
    }
}

