/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.BaseEditSubmissionPreprocessorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vivoweb.webapp.util.ModelUtils;

public abstract class RoleToPredicatePreprocessor
extends BaseEditSubmissionPreprocessorVTwo {
    protected static final Log log = LogFactory.getLog((String)RoleToPredicatePreprocessor.class.getName());
    protected WebappDaoFactory wadf = null;
    protected static String itemType;
    protected static String roleToItemPredicate;
    protected static String itemToRolePredicate;

    public RoleToPredicatePreprocessor(EditConfigurationVTwo editConfig, WebappDaoFactory wadf) {
        super(editConfig);
        this.wadf = wadf;
        this.setupVariableNames();
    }

    protected abstract void setupVariableNames();

    public void preprocess(MultiValueEditSubmission submission, VitroRequest vreq) {
        try {
            String type = this.getItemType(submission);
            Map urisFromForm = submission.getUrisFromForm();
            if (type != null) {
                ObjectProperty roleToItemProperty = this.getCorrectProperty(type, this.wadf);
                String roleToItemPredicateURI = roleToItemProperty.getURI();
                String itemToRolePredicateURI = roleToItemProperty.getURIInverse();
                ArrayList<String> predicates = new ArrayList<String>();
                predicates.add(roleToItemPredicateURI);
                ArrayList<String> inversePredicates = new ArrayList<String>();
                inversePredicates.add(itemToRolePredicateURI);
                if (urisFromForm.containsKey(roleToItemPredicate)) {
                    urisFromForm.remove(roleToItemPredicate);
                }
                urisFromForm.put(roleToItemPredicate, predicates);
                if (urisFromForm.containsKey(itemToRolePredicate)) {
                    urisFromForm.remove(itemToRolePredicate);
                }
                urisFromForm.put(itemToRolePredicate, inversePredicates);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving name values from edit submission.");
        }
    }

    protected abstract String getItemType(MultiValueEditSubmission var1);

    private ObjectProperty getCorrectProperty(String uri, WebappDaoFactory wadf) {
        ObjectProperty correctProperty = ModelUtils.getPropertyForRoleInClass(uri, wadf);
        return correctProperty;
    }
}

