/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.menuManagement;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.menuManagement.MenuManagementDataUtils;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIVOMenuManagementDataUtils
implements MenuManagementDataUtils.IMenuManagementDataUtils {
    private static final Log log = LogFactory.getLog(VIVOMenuManagementDataUtils.class);

    public void includeRequiredSystemData(ServletContext context, Map<String, Object> templateData) {
        this.checkInstitutionalInternalClass(context, templateData);
    }

    private void checkInstitutionalInternalClass(ServletContext context, Map<String, Object> templateData) {
        String internalClass = this.retrieveInternalClass(context);
        if (internalClass != null) {
            templateData.put("internalClass", internalClass);
            templateData.put("internalClassUri", internalClass);
        } else {
            templateData.put("internalClassUri", "");
        }
    }

    private String retrieveInternalClass(ServletContext context) {
        OntModel mainModel = ModelAccess.on((ServletContext)context).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox");
        StmtIterator internalIt = mainModel.listStatements(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null);
        if (internalIt.hasNext()) {
            String internalClass = internalIt.nextStatement().getSubject().getURI();
            return internalClass;
        }
        return null;
    }
}

