/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coauthorship;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.YearToEntityCountDataElement;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;

public class CoAuthorshipVisCodeGenerator {
    private static final String DEFAULT_VISCONTAINER_DIV_ID = "unique_coauthors_vis_container";
    private Map<String, Set<Collaborator>> yearToUniqueCoauthors;
    private Log log;
    private SparklineData sparklineParameterVO;
    private String individualURI;

    public CoAuthorshipVisCodeGenerator(String individualURI, String visMode, String visContainer, Map<String, Set<Collaborator>> yearToUniqueCoauthors, Log log) {
        this.individualURI = individualURI;
        this.yearToUniqueCoauthors = yearToUniqueCoauthors;
        this.log = log;
        this.sparklineParameterVO = this.setupSparklineParameters(visMode, visContainer);
    }

    private SparklineData setupSparklineParameters(String visMode, String providedVisContainerID) {
        SparklineData sparklineData = new SparklineData();
        int numOfYearsToBeRendered = 0;
        int currentYear = Calendar.getInstance().get(1) - 1;
        int shortSparkMinYear = currentYear - 10 + 1;
        HashSet<String> publishedYears = new HashSet<String>(this.yearToUniqueCoauthors.keySet());
        publishedYears.remove("Unknown");
        int minPublishedYear = shortSparkMinYear;
        String visContainerID = null;
        if (this.yearToUniqueCoauthors.size() > 0) {
            try {
                minPublishedYear = Integer.parseInt(Collections.min(publishedYears));
            }
            catch (NoSuchElementException e1) {
                this.log.debug((Object)("vis: " + e1.getMessage() + " error occurred for " + this.yearToUniqueCoauthors.toString()));
            }
            catch (NumberFormatException e2) {
                this.log.debug((Object)("vis: " + e2.getMessage() + " error occurred for " + this.yearToUniqueCoauthors.toString()));
            }
        }
        int minPubYearConsidered = 0;
        minPubYearConsidered = minPublishedYear > shortSparkMinYear ? shortSparkMinYear : minPublishedYear;
        numOfYearsToBeRendered = currentYear - minPubYearConsidered + 1;
        sparklineData.setNumOfYearsToBeRendered(numOfYearsToBeRendered);
        int uniqueCoAuthorCounter = 0;
        HashSet<Collaborator> allCoAuthorsWithKnownAuthorshipYears = new HashSet<Collaborator>();
        ArrayList<YearToEntityCountDataElement> yearToUniqueCoauthorsCountDataTable = new ArrayList<YearToEntityCountDataElement>();
        for (int publicationYear = minPubYearConsidered; publicationYear <= currentYear; ++publicationYear) {
            String publicationYearAsString = String.valueOf(publicationYear);
            Set<Collaborator> currentCoAuthors = this.yearToUniqueCoauthors.get(publicationYearAsString);
            Integer currentUniqueCoAuthors = null;
            if (currentCoAuthors != null) {
                currentUniqueCoAuthors = currentCoAuthors.size();
                allCoAuthorsWithKnownAuthorshipYears.addAll(currentCoAuthors);
            } else {
                currentUniqueCoAuthors = 0;
            }
            yearToUniqueCoauthorsCountDataTable.add(new YearToEntityCountDataElement(uniqueCoAuthorCounter, publicationYearAsString, currentUniqueCoAuthors));
            ++uniqueCoAuthorCounter;
        }
        sparklineData.setRenderedSparks(allCoAuthorsWithKnownAuthorshipYears.size());
        sparklineData.setYearToEntityCountDataTable(yearToUniqueCoauthorsCountDataTable);
        HashSet totalUniqueCoInvestigators = new HashSet(allCoAuthorsWithKnownAuthorshipYears);
        Integer unknownYearCoauthors = 0;
        if (this.yearToUniqueCoauthors.get("Unknown") != null) {
            unknownYearCoauthors = this.yearToUniqueCoauthors.get("Unknown").size();
            totalUniqueCoInvestigators.addAll(this.yearToUniqueCoauthors.get("Unknown"));
        }
        sparklineData.setUnknownYearPublications(unknownYearCoauthors);
        sparklineData.setTotalCollaborationshipCount(totalUniqueCoInvestigators.size());
        visContainerID = providedVisContainerID != null ? providedVisContainerID : DEFAULT_VISCONTAINER_DIV_ID;
        sparklineData.setVisContainerDivID(visContainerID);
        sparklineData.setEarliestYearConsidered(minPubYearConsidered);
        sparklineData.setEarliestRenderedPublicationYear(minPublishedYear);
        sparklineData.setLatestRenderedPublicationYear(currentYear);
        if ("short".equalsIgnoreCase(visMode)) {
            sparklineData.setEarliestRenderedPublicationYear(shortSparkMinYear);
            sparklineData.setShortVisMode(true);
        } else {
            sparklineData.setShortVisMode(false);
        }
        if (this.yearToUniqueCoauthors.size() > 0) {
            sparklineData.setFullTimelineNetworkLink(UtilityFunctions.getCollaboratorshipNetworkLink(this.individualURI, "person_level", "coauthor"));
            sparklineData.setDownloadDataLink(UtilityFunctions.getCSVDownloadURL(this.individualURI, "coauthorship", "coauthors_count_per_year"));
            HashMap<String, Integer> yearToUniqueCoauthorsCount = new HashMap<String, Integer>();
            for (Map.Entry<String, Set<Collaborator>> currentYearToCoAuthors : this.yearToUniqueCoauthors.entrySet()) {
                yearToUniqueCoauthorsCount.put(currentYearToCoAuthors.getKey(), currentYearToCoAuthors.getValue().size());
            }
            sparklineData.setYearToActivityCount(yearToUniqueCoauthorsCount);
        }
        return sparklineData;
    }

    public SparklineData getValueObjectContainer() {
        return this.sparklineParameterVO;
    }
}

