/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.modelconstructor;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.ModelConstructor;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonToGrantsModelConstructor
implements ModelConstructor {
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private RDFService rdfService;
    public static final String MODEL_TYPE = "PERSON_TO_GRANTS";
    public static final String MODEL_TYPE_HUMAN_READABLE = "Grants for specific person via all roles";
    private String personURI;
    private Log log = LogFactory.getLog((String)PersonToGrantsModelConstructor.class.getName());
    private long before;
    private long after;

    public PersonToGrantsModelConstructor(String personURI, RDFService rdfService) {
        this.personURI = personURI;
        this.rdfService = rdfService;
    }

    private Set<String> constructPersonGrantsQueryTemplate(String constructProperty, String roleType) {
        HashSet<String> differentPerspectiveQueries = new HashSet<String>();
        String justGrantsQuery = " CONSTRUCT {       <" + this.personURI + "> vivosocnet:lastCachedAt ?now . " + "     <" + this.personURI + "> vivosocnet:" + constructProperty + " ?Grant . " + "      " + "     ?Grant rdf:type core:Grant . " + "     ?Grant rdfs:label ?grantLabel . " + "      " + " } " + " WHERE { " + "     <" + this.personURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "     ?Role rdf:type core:" + roleType + " . " + "     ?Role core:relatedBy ?Grant . " + "     ?Grant rdf:type core:Grant . " + "     ?Grant rdfs:label ?grantLabel . " + "      " + "     LET(?now := now()) " + " } ";
        String justDateTimeOnGrantsQuery = " CONSTRUCT {       <" + this.personURI + "> vivosocnet:lastCachedAt ?now . " + "     ?Grant vivosocnet:startDateTimeOnGrant ?startDateTimeValueForGrant . " + "      " + " } " + " WHERE { " + "     <" + this.personURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "     ?Role rdf:type core:" + roleType + " . " + "     ?Role core:relatedBy ?Grant . " + "     ?Grant rdf:type core:Grant . " + "      " + "         ?Grant core:dateTimeInterval ?dateTimeIntervalValueForGrant .          " + "             ?dateTimeIntervalValueForGrant core:start ?startDateForGrant .  " + "             ?startDateForGrant core:dateTime ?startDateTimeValueForGrant . " + "      " + "     LET(?now := now()) " + " } ";
        String justDateTimeOnRolesQuery = " CONSTRUCT {       <" + this.personURI + "> vivosocnet:lastCachedAt ?now . " + "     ?Grant vivosocnet:startDateTimeOnRole ?startDateTimeValue . " + " } " + " WHERE { " + "     <" + this.personURI + "> <http://purl.obolibrary.org/obo/RO_0000053> ?Role . " + "     ?Role rdf:type core:" + roleType + " . " + "     ?Role core:relatedBy ?Grant . " + "     ?Grant rdf:type core:Grant . " + "      " + "         ?Role core:dateTimeInterval ?dateTimeIntervalValue . " + "             ?dateTimeIntervalValue core:start ?startDate .  " + "             ?startDate core:dateTime ?startDateTimeValue . " + "      " + "     LET(?now := now()) " + " } ";
        differentPerspectiveQueries.add(justGrantsQuery);
        differentPerspectiveQueries.add(justDateTimeOnGrantsQuery);
        differentPerspectiveQueries.add(justDateTimeOnRolesQuery);
        return differentPerspectiveQueries;
    }

    private Set<String> constructPersonToGrantsQuery() {
        HashSet<String> differentInvestigatorTypeQueries = new HashSet<String>();
        Set<String> investigatorRoleQuery = this.constructPersonGrantsQueryTemplate("hasGrantAsAnInvestigator", "InvestigatorRole");
        Set<String> piRoleQuery = this.constructPersonGrantsQueryTemplate("hasGrantAsPI", "PrincipalInvestigatorRole");
        Set<String> coPIRoleQuery = this.constructPersonGrantsQueryTemplate("hasGrantAsCoPI", "CoPrincipalInvestigatorRole");
        differentInvestigatorTypeQueries.addAll(investigatorRoleQuery);
        differentInvestigatorTypeQueries.addAll(piRoleQuery);
        differentInvestigatorTypeQueries.addAll(coPIRoleQuery);
        return differentInvestigatorTypeQueries;
    }

    private Model executeQuery(Set<String> constructQueries) {
        Model constructedModel = ModelFactory.createDefaultModel();
        this.before = System.currentTimeMillis();
        this.log.debug((Object)("CONSTRUCT query string : " + constructQueries));
        for (String currentQuery : constructQueries) {
            try {
                this.rdfService.sparqlConstructQuery(QueryConstants.getSparqlPrefixQuery() + currentQuery, constructedModel);
            }
            catch (Throwable th) {
                this.log.error((Object)("Could not create CONSTRUCT SPARQL query for query string. " + th.getMessage()));
                this.log.error((Object)currentQuery);
            }
        }
        this.after = System.currentTimeMillis();
        this.log.debug((Object)("Time taken to execute the CONSTRUCT queries is in milliseconds: " + (this.after - this.before)));
        return constructedModel;
    }

    @Override
    public Model getConstructedModel() throws MalformedQueryParametersException {
        return this.executeQuery(this.constructPersonToGrantsQuery());
    }
}

