/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.personpubcount;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.QueryRunner;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;

public class PersonPublicationCountQueryRunner
implements QueryRunner<Set<Activity>> {
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private String personURI;
    private RDFService rdfService;
    private String authorName;
    private Log log;

    public String getAuthorName() {
        return this.authorName;
    }

    public PersonPublicationCountQueryRunner(String personURI, RDFService rdfService, Log log) {
        this.personURI = personURI;
        this.rdfService = rdfService;
        this.log = log;
    }

    private String getSparqlConstruct(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "CONSTRUCT \n" + "{\n" + "    <" + queryURI + "> rdfs:label ?authorName .\n" + "    <" + queryURI + "> core:authorOf ?document .\n" + "    ?document core:publicationDate ?publicationDate .\n" + "}\n" + "WHERE" + "{\n" + "    {\n" + "    <" + queryURI + "> rdf:type foaf:Person ;\n" + "                       rdfs:label ?authorName ;  \n" + "                       core:relatedBy ?authorshipNode .  \n" + "    ?authorshipNode rdf:type core:Authorship ; \n" + "                    core:relates ?document . \n" + "\t   ?document rdf:type bibo:Document ; \n" + "              rdfs:label ?documentLabel .\n" + "    } UNION {\n" + "    <" + queryURI + "> rdf:type foaf:Person ;\n" + "                       core:relatedBy ?authorshipNode .  \n" + "    ?authorshipNode rdf:type core:Authorship ;" + "                    core:relates ?document . \n" + "\t   ?document rdf:type bibo:Document . \n" + "    ?document core:dateTimeValue ?dateTimeValue . \n" + "    ?dateTimeValue core:dateTime ?publicationDate .\n" + "    }\n" + "}\n";
        this.log.debug((Object)sparqlQuery);
        return sparqlQuery;
    }

    private String getSparqlQuery(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT ?document ?publicationDate\n" + "WHERE { \n" + "    <" + queryURI + "> core:authorOf ?document . \n" + "\t   OPTIONAL { ?document core:publicationDate ?publicationDate . } .\n" + "}\n";
        this.log.debug((Object)sparqlQuery);
        return sparqlQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Activity> getQueryResult() throws MalformedQueryParametersException {
        if (StringUtils.isNotBlank((String)this.personURI)) {
            IRIFactory iRIFactory = IRIFactory.jenaImplementation();
            IRI iri = iRIFactory.create(this.personURI);
            if (iri.hasViolation(false)) {
                String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                this.log.error((Object)("Pub Count vis Query " + errorMsg));
                throw new MalformedQueryParametersException("URI provided for an individual is malformed.");
            }
        } else {
            throw new MalformedQueryParametersException("URL parameter is either null or empty.");
        }
        PersonPublicationConsumer consumer = new PersonPublicationConsumer();
        try {
            Model model = ModelFactory.createDefaultModel();
            this.rdfService.sparqlConstructQuery(this.getSparqlConstruct(this.personURI), model);
            Query q = QueryFactory.create((String)this.getSparqlQuery(this.personURI));
            try (QueryExecution qe = QueryExecutionFactory.create((Query)q, (Model)model);){
                consumer.processResultSet(qe.execSelect());
                Statement authorLabel = model.getProperty(ResourceFactory.createResource((String)this.personURI), RDFS.label);
                this.authorName = authorLabel.getObject().asLiteral().getString();
            }
        }
        catch (RDFServiceException r) {
            throw new RuntimeException(r);
        }
        return consumer.getAuthorDocuments();
    }

    private static class PersonPublicationConsumer
    extends ResultSetConsumer {
        Set<Activity> authorDocuments = new HashSet<Activity>();

        private PersonPublicationConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            Activity biboDocument = new Activity(qs.get("document").asResource().getURI());
            RDFNode publicationDateNode = qs.get("publicationDate");
            if (publicationDateNode != null) {
                biboDocument.setActivityDate(publicationDateNode.asLiteral().getString());
            }
            this.authorDocuments.add(biboDocument);
        }

        public Set<Activity> getAuthorDocuments() {
            return this.authorDocuments;
        }
    }
}

