/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.utils.threads.VitroBackgroundThread;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CachingRDFServiceExecutor<T> {
    private T cachedResults;
    private long lastCacheTime;
    private RDFServiceCallable<T> resultBuilder;
    private FutureTask<T> backgroundTask = null;
    private Thread backgroundCompletion = null;
    private long backgroundTaskStartTime = -1L;
    private static RDFService backgroundRDFService = null;

    public CachingRDFServiceExecutor(RDFServiceCallable<T> resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    public boolean isCached() {
        return this.cachedResults != null;
    }

    public Date cachedWhen() {
        return new Date(this.lastCacheTime);
    }

    public synchronized T get(RDFService rdfService) {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.completeBackgroundTask();
        }
        if (this.cachedResults != null) {
            if (backgroundRDFService != null && this.resultBuilder.invalidateCache(System.currentTimeMillis() - this.lastCacheTime)) {
                long waitFor = this.backgroundTask == null ? 1000 : 500;
                this.startBackgroundTask(rdfService);
                if (this.isExpectedToCompleteIn(waitFor)) {
                    this.completeBackgroundTask(waitFor);
                }
            }
        } else {
            if (rdfService != null) {
                this.startBackgroundTask(rdfService);
            } else if (backgroundRDFService != null) {
                this.startBackgroundTask(backgroundRDFService);
            } else {
                throw new RuntimeException("Can't execute without an RDF Service");
            }
            this.completeBackgroundTask();
        }
        return this.cachedResults;
    }

    public void build(RDFService rdfService) {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.buildComplete();
        } else if (this.backgroundTask == null) {
            this.buildStart(rdfService);
        }
    }

    private synchronized void buildComplete() {
        if (this.backgroundTask != null && this.backgroundTask.isDone()) {
            this.completeBackgroundTask();
        }
    }

    private synchronized void buildStart(RDFService rdfService) {
        if (this.backgroundTask == null) {
            if (backgroundRDFService != null) {
                this.startBackgroundTask(backgroundRDFService);
                this.completeBackgroundTaskAsync();
            } else if (rdfService != null) {
                this.startBackgroundTask(backgroundRDFService);
                this.completeBackgroundTask();
            }
        }
    }

    private boolean isExpectedToCompleteIn(long interval) {
        long expectedFinish;
        if (this.backgroundTask == null) {
            return false;
        }
        if (this.backgroundTask.isDone()) {
            return true;
        }
        long now = System.currentTimeMillis();
        return ((RDFServiceCallable)this.resultBuilder).startedAt > -1L && ((RDFServiceCallable)this.resultBuilder).executionTime > -1L && (expectedFinish = ((RDFServiceCallable)this.resultBuilder).startedAt + ((RDFServiceCallable)this.resultBuilder).executionTime) < now + interval;
    }

    private void startBackgroundTask(RDFService rdfService) {
        if (this.backgroundTask == null && rdfService != null) {
            this.resultBuilder.setRDFService(backgroundRDFService != null ? backgroundRDFService : rdfService);
            this.backgroundTask = new FutureTask<T>(this.resultBuilder);
            this.backgroundTaskStartTime = System.currentTimeMillis();
            VitroBackgroundThread thread = new VitroBackgroundThread(this.backgroundTask, this.resultBuilder.getClass().getName());
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void abortBackgroundTask() {
        if (this.backgroundTask != null) {
            this.backgroundTask.cancel(true);
            this.backgroundTask = null;
            this.backgroundTaskStartTime = -1L;
        }
    }

    private synchronized void completeBackgroundTaskAsync() {
        if (this.backgroundCompletion == null) {
            this.backgroundCompletion = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                        CachingRDFServiceExecutor.this.completeBackgroundTask(-1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.backgroundCompletion.setDaemon(true);
            this.backgroundCompletion.start();
        }
    }

    private void completeBackgroundTask() {
        this.completeBackgroundTask(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeBackgroundTask(long waitFor) {
        try {
            if (this.backgroundTask != null) {
                this.cachedResults = waitFor < 0L ? this.backgroundTask.get() : this.backgroundTask.get(waitFor, TimeUnit.MILLISECONDS);
                this.lastCacheTime = this.backgroundTaskStartTime;
                this.backgroundTask = null;
                this.backgroundTaskStartTime = -1L;
                this.backgroundCompletion = null;
            }
        }
        catch (InterruptedException e) {
            this.abortBackgroundTask();
        }
        catch (ExecutionException e) {
            try {
                this.abortBackgroundTask();
            }
            finally {
                throw new RuntimeException("Background RDF thread through an exception", e.getCause());
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void setBackgroundRDFService(RDFService rdfService) {
        backgroundRDFService = rdfService;
    }

    public static class Affinity {
        private int maxThreads = 1;
        private Map<Thread, Long> threadToExecutionTime = new HashMap<Thread, Long>();
        private Set<Thread> executingThreads = new HashSet<Thread>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestStart(long expectedExecutionTime) {
            if (this.queueThis(Thread.currentThread(), expectedExecutionTime)) {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    try {
                        Thread.currentThread().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private synchronized boolean queueThis(Thread thread, Long time) {
            if (this.executingThreads.size() < this.maxThreads) {
                this.executingThreads.add(thread);
                return false;
            }
            this.threadToExecutionTime.put(thread, time);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void complete() {
            if (this.executingThreads.contains(Thread.currentThread())) {
                this.executingThreads.remove(Thread.currentThread());
                while (this.threadToExecutionTime.size() > 0 && this.executingThreads.size() < this.maxThreads) {
                    Thread nextToRelease = null;
                    long executionTime = -1L;
                    for (Thread thread : this.threadToExecutionTime.keySet()) {
                        long thisTime = this.threadToExecutionTime.get(thread);
                        if (nextToRelease == null) {
                            nextToRelease = thread;
                            executionTime = thisTime;
                            continue;
                        }
                        if (thisTime >= executionTime) continue;
                        nextToRelease = thread;
                        executionTime = thisTime;
                    }
                    Iterator<Thread> iterator = nextToRelease;
                    synchronized (iterator) {
                        this.threadToExecutionTime.remove(nextToRelease);
                        this.executingThreads.add(nextToRelease);
                        nextToRelease.notify();
                    }
                }
            }
        }
    }

    public static abstract class RDFServiceCallable<T>
    implements Callable<T> {
        private RDFService rdfService;
        private long startedAt = -1L;
        private long executionTime = -1L;
        private Affinity affinity = null;

        public RDFServiceCallable() {
        }

        public RDFServiceCallable(Affinity affinity) {
            this.affinity = affinity;
        }

        final void setRDFService(RDFService rdfService) {
            this.rdfService = rdfService;
        }

        @Override
        public final T call() throws Exception {
            try {
                if (this.affinity != null) {
                    this.affinity.requestStart(this.executionTime);
                }
                this.startedAt = System.currentTimeMillis();
                T val = this.callWithService(this.rdfService);
                this.executionTime = System.currentTimeMillis() - this.startedAt;
                T t = val;
                return t;
            }
            finally {
                this.startedAt = -1L;
                if (this.affinity != null) {
                    this.affinity.complete();
                }
            }
        }

        protected abstract T callWithService(RDFService var1) throws Exception;

        boolean invalidateCache(long timeCached) {
            if (this.executionTime > -1L) {
                return timeCached > Math.min(this.executionTime * 120L, 86400000L);
            }
            return false;
        }
    }
}

