/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individuallist.ListedIndividual;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIVOListedIndividual
extends ListedIndividual {
    private static final Log log = LogFactory.getLog(VIVOListedIndividual.class);
    private static String VCARD_DATA_QUERY = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT DISTINCT ?title  \nWHERE {  \n    ?subject obo:ARG_2000028 ?vIndividual .  \n    ?vIndividual vcard:hasTitle ?vTitle . \n    ?vTitle vcard:title ?title . \n} ";
    private final String title = this.findPreferredTitle();

    VIVOListedIndividual(Individual individual, VitroRequest vreq) {
        super(individual, vreq);
    }

    private String findPreferredTitle() {
        String queryStr = QueryUtils.subUriForQueryVar((String)VCARD_DATA_QUERY, (String)"subject", (String)this.individual.getURI());
        log.debug((Object)("queryStr = " + queryStr));
        String value = "";
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)this.vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                String t = QueryUtils.nodeToString((RDFNode)soln.get("title"));
                if (!StringUtils.isNotBlank((String)t)) continue;
                value = t;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return value;
    }

    public String getPreferredTitle() {
        return this.title;
    }
}

