/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProxyEditingRights;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.IsRootUser;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.utils.SparqlQueryRunner;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidIdDataGetter
implements DataGetter {
    private static final Log log = LogFactory.getLog(OrcidIdDataGetter.class);
    private static final Map<String, Object> EMPTY_RESULT = Collections.emptyMap();
    public static final String ORCID_ID = "http://vivoweb.org/ontology/core#orcidId";
    public static final String ORCID_IS_CONFIRMED = "http://vivoweb.org/ontology/core#confirmedOrcidId";
    private static final String QUERY_TEMPLATE = "SELECT ?orcid ?confirmed \nWHERE { \n    <%s> <%s> ?orcid . \n    OPTIONAL { \n       ?orcid <%s> ?confirmed . \n       }  \n}\n";
    private final VitroRequest vreq;

    public OrcidIdDataGetter(VitroRequest vreq) {
        this.vreq = vreq;
    }

    public Map<String, Object> getData(Map<String, Object> valueMap) {
        try {
            String individualUri = this.findIndividualUri(valueMap);
            if (individualUri == null) {
                return EMPTY_RESULT;
            }
            boolean isAuthorizedToConfirm = this.figureIsAuthorizedtoConfirm(individualUri);
            List<OrcidInfo> orcids = this.runSparqlQuery(individualUri);
            return this.buildMap(isAuthorizedToConfirm, orcids, individualUri);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to get orcID information", (Throwable)e);
            return EMPTY_RESULT;
        }
    }

    private String findIndividualUri(Map<String, Object> valueMap) {
        try {
            String uri = (String)valueMap.get("individualURI");
            if (uri == null) {
                log.warn((Object)("valueMap has no individualURI. Keys are: " + valueMap.keySet()));
                return null;
            }
            return uri;
        }
        catch (Exception e) {
            log.debug((Object)"has a problem finding the individualURI", (Throwable)e);
            return null;
        }
    }

    private boolean figureIsAuthorizedtoConfirm(String individualUri) {
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.vreq);
        boolean isSelfEditor = HasProfile.getProfileUris((IdentifierBundle)ids).contains(individualUri);
        boolean isProxyEditor = HasProxyEditingRights.getProxiedPageUris((IdentifierBundle)ids).contains(individualUri);
        boolean isRoot = IsRootUser.isRootUser((IdentifierBundle)ids);
        return isRoot || isProxyEditor || isSelfEditor;
    }

    private List<OrcidInfo> runSparqlQuery(String individualUri) {
        String queryStr = String.format(QUERY_TEMPLATE, individualUri, ORCID_ID, ORCID_IS_CONFIRMED);
        SparqlQueryRunner runner = new SparqlQueryRunner((Model)this.vreq.getJenaOntModel());
        return (List)runner.executeSelect((SparqlQueryRunner.QueryParser)new OrcidResultParser(), queryStr);
    }

    private Map<String, Object> buildMap(boolean isAuthorizedToConfirm, List<OrcidInfo> orcids, String individualUri) {
        HashMap<String, Boolean> confirmationMap = new HashMap<String, Boolean>();
        for (OrcidInfo oInfo : orcids) {
            confirmationMap.put(oInfo.getOrcid(), oInfo.isConfirmed());
        }
        HashMap<String, Object> orcidInfoMap = new HashMap<String, Object>();
        orcidInfoMap.put("authorizedToConfirm", isAuthorizedToConfirm);
        orcidInfoMap.put("orcidUrl", UrlBuilder.getUrl((String)"orcid", (String[])new String[]{"individualUri", individualUri}));
        orcidInfoMap.put("orcids", confirmationMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orcidInfo", orcidInfoMap);
        log.debug((Object)("Returning these values:" + map));
        return map;
    }

    static class OrcidInfo {
        private final String orcid;
        private final boolean confirmed;

        public OrcidInfo(String orcid, boolean confirmed) {
            this.orcid = orcid;
            this.confirmed = confirmed;
        }

        public String getOrcid() {
            return this.orcid;
        }

        public boolean isConfirmed() {
            return this.confirmed;
        }

        public String toString() {
            return "OrcidInfo[orcid=" + this.orcid + ", confirmed=" + this.confirmed + "]";
        }
    }

    private static class OrcidResultParser
    extends SparqlQueryRunner.QueryParser<List<OrcidInfo>> {
        private OrcidResultParser() {
        }

        protected List<OrcidInfo> defaultValue() {
            return Collections.emptyList();
        }

        protected List<OrcidInfo> parseResults(String queryStr, ResultSet results) {
            ArrayList<OrcidInfo> orcids = new ArrayList<OrcidInfo>();
            while (results.hasNext()) {
                try {
                    QuerySolution solution = results.next();
                    Resource orcid = solution.getResource("orcid");
                    RDFNode cNode = solution.get("confirmed");
                    log.debug((Object)("Result is orcid=" + orcid + ", confirmed=" + cNode));
                    if (orcid == null || !orcid.isURIResource()) continue;
                    boolean confirmed = cNode != null;
                    orcids.add(new OrcidInfo(orcid.getURI(), confirmed));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to parse the query result: " + queryStr), (Throwable)e);
                }
            }
            return orcids;
        }
    }
}

