/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.auth.AuthorizationManager;
import edu.cornell.mannlib.orcidclient.context.OrcidClientContext;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidMessage;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyStatementDao;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidConfirmationState;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidAbstractHandler.class);
    protected final VitroRequest vreq;
    protected final OrcidClientContext occ;
    protected final AuthorizationManager auth;
    protected final OrcidConfirmationState state;
    protected final UserAccount currentUser;

    protected OrcidAbstractHandler(VitroRequest vreq) {
        this.vreq = vreq;
        this.occ = OrcidClientContext.getInstance();
        this.auth = this.occ.getAuthorizationManager((HttpServletRequest)vreq);
        this.state = OrcidConfirmationState.fetch((HttpServletRequest)vreq);
        this.currentUser = LoginStatusBean.getCurrentUser((HttpServletRequest)vreq);
    }

    protected Individual findIndividual() {
        String uri = this.state.getIndividualUri();
        try {
            IndividualDao iDao = this.vreq.getWebappDaoFactory().getIndividualDao();
            Individual individual = iDao.getIndividualByURI(uri);
            if (individual == null) {
                throw new IllegalStateException("Individual URI not valid: '" + uri + "'");
            }
            return individual;
        }
        catch (Exception e) {
            throw new IllegalStateException("Individual URI not valid: '" + uri + "'");
        }
    }

    protected void recordConfirmation() {
        String individualUri = this.state.getIndividualUri();
        String orcidUri = this.state.getOrcidUri();
        log.debug((Object)("Recording confirmation of ORCID '" + orcidUri + "' on '" + individualUri + "'"));
        ObjectPropertyStatementImpl ops1 = new ObjectPropertyStatementImpl(individualUri, "http://vivoweb.org/ontology/core#orcidId", orcidUri);
        ObjectPropertyStatementImpl ops2 = new ObjectPropertyStatementImpl(orcidUri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/2002/07/owl#Thing");
        ObjectPropertyStatementImpl ops3 = new ObjectPropertyStatementImpl(orcidUri, "http://vivoweb.org/ontology/core#confirmedOrcidId", individualUri);
        ObjectPropertyStatementDao opsd = this.vreq.getWebappDaoFactory().getObjectPropertyStatementDao();
        opsd.insertNewObjectPropertyStatement((ObjectPropertyStatement)ops1);
        opsd.insertNewObjectPropertyStatement((ObjectPropertyStatement)ops2);
        opsd.insertNewObjectPropertyStatement((ObjectPropertyStatement)ops3);
    }

    protected String cornellNetId() {
        if (this.currentUser == null) {
            return null;
        }
        String externalId = this.currentUser.getExternalAuthId();
        if (externalId == null) {
            return null;
        }
        if (externalId.trim().isEmpty()) {
            return null;
        }
        return externalId;
    }

    protected ResponseValues show500InternalServerError(String message) {
        log.error((Object)("Problem with ORCID request: " + message));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "500 Internal Server Error");
        map.put("errorMessage", message);
        return new TemplateResponseValues("error-titled.ftl", map, 500);
    }

    protected ResponseValues showConfirmationPage(OrcidConfirmationState.Progress p, OrcidMessage ... messages) {
        this.state.progress(p, messages);
        return this.showConfirmationPage();
    }

    protected ResponseValues showConfirmationPage() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        map.put("orcidInfo", this.state.toMap());
        return new TemplateResponseValues("orcidConfirm.ftl", map);
    }
}

