/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.actions.ApiAction;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationStatus;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidMessage;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.RedirectResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidConfirmationState;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidIntegrationController;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidAuthAuthenticateHandler
extends OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidAuthAuthenticateHandler.class);
    private AuthorizationStatus status;

    public OrcidAuthAuthenticateHandler(VitroRequest vreq) {
        super(vreq);
    }

    public ResponseValues exec() throws URISyntaxException, OrcidClientException {
        this.status = this.auth.getAuthorizationStatus(ApiAction.AUTHENTICATE);
        if (this.status.isNone()) {
            return this.seekAuthorizationForAuthenticate();
        }
        if (this.status.isSuccess()) {
            return this.redirectToReadProfile();
        }
        if (this.status.isDenied()) {
            return this.showConfirmationPage(OrcidConfirmationState.Progress.DENIED_AUTHENTICATE, new OrcidMessage[0]);
        }
        return this.showConfirmationPage(OrcidConfirmationState.Progress.FAILED_AUTHENTICATE, new OrcidMessage[0]);
    }

    private ResponseValues seekAuthorizationForAuthenticate() throws OrcidClientException, URISyntaxException {
        log.debug((Object)"Seeking authorization to authenticate.");
        String returnUrl = this.occ.resolvePathWithWebapp(OrcidIntegrationController.PATH_READ_PROFILE);
        String seekUrl = this.auth.seekAuthorization(ApiAction.AUTHENTICATE, returnUrl);
        return new RedirectResponseValues(seekUrl);
    }

    private ResponseValues redirectToReadProfile() throws URISyntaxException {
        log.debug((Object)"Already authorized to authenticate.");
        return new RedirectResponseValues(this.occ.resolvePathWithWebapp(OrcidIntegrationController.PATH_READ_PROFILE));
    }
}

