/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationManager;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationStatus;
import edu.cornell.mannlib.orcidclient.context.OrcidClientContext;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidCallbackHandler {
    private static final Log log = LogFactory.getLog(OrcidCallbackHandler.class);
    private final HttpServletRequest req;
    private final HttpServletResponse resp;

    public OrcidCallbackHandler(HttpServletRequest req, HttpServletResponse resp) {
        this.req = req;
        this.resp = resp;
    }

    public void exec() throws IOException {
        OrcidClientContext occ = OrcidClientContext.getInstance();
        AuthorizationManager authManager = occ.getAuthorizationManager(this.req);
        try {
            AuthorizationStatus auth = authManager.processAuthorizationResponse();
            if (auth.isSuccess()) {
                this.resp.sendRedirect(auth.getSuccessUrl());
            } else {
                this.resp.sendRedirect(auth.getFailureUrl());
            }
        }
        catch (OrcidClientException e) {
            log.error((Object)"Invalid authorization response", (Throwable)e);
            this.resp.sendError(500);
        }
    }
}

