/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.auth.permissions.SimplePermission;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagePublicationsForIndividualController
extends FreemarkerHttpServlet {
    private static final Log log = LogFactory.getLog((String)ManagePublicationsForIndividualController.class.getName());
    private static final String TEMPLATE_NAME = "managePublicationsForIndividual.ftl";
    private static String PUBLICATION_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nPREFIX afn: <http://jena.hpl.hp.com/ARQ/function#> \nSELECT DISTINCT ?subclass ?authorship (str(?label) as ?title) ?pub ?hideThis WHERE { \n    ?subject core:relatedBy ?authorship . \n    ?authorship a core:Authorship  . \n    OPTIONAL { \n         ?subject core:relatedBy ?authorship . \n        ?authorship a core:Authorship  . \n        ?authorship core:relates ?pub .         ?pub a <http://purl.org/ontology/bibo/Document> . \n        ?pub rdfs:label ?label . \n        OPTIONAL { \n            ?subject core:relatedBy ?authorship . \n            ?authorship a core:Authorship  . \n            ?authorship core:relates ?pub .             ?pub a <http://purl.org/ontology/bibo/Document> . \n            ?pub vitro:mostSpecificType ?subclass . \n        } \n    } \n    OPTIONAL { ?authorship core:hideFromDisplay ?hideThis } \n} ORDER BY ?subclass ?title";

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        return SimplePermission.DO_FRONT_END_EDITING.ACTION;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String subjectUri = vreq.getParameter("subjectUri");
        body.put("subjectUri", subjectUri);
        HashMap<String, List<Map<String, String>>> publications = this.getPublications(subjectUri, vreq);
        if (log.isDebugEnabled()) {
            log.debug((Object)("publications = " + publications));
        }
        body.put("publications", publications);
        List<String> allSubclasses = this.getAllSubclasses(publications);
        body.put("allSubclasses", allSubclasses);
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(subjectUri);
        if (subject != null && subject.getName() != null) {
            body.put("subjectName", subject.getName());
        } else {
            body.put("subjectName", null);
        }
        return new TemplateResponseValues(TEMPLATE_NAME, body);
    }

    HashMap<String, List<Map<String, String>>> getPublications(String subjectUri, VitroRequest vreq) {
        VClassDao vcDao = vreq.getUnfilteredAssertionsWebappDaoFactory().getVClassDao();
        String queryStr = QueryUtils.subUriForQueryVar((String)PUBLICATION_QUERY, (String)"subject", (String)subjectUri);
        String subclass = "";
        log.debug((Object)("queryStr = " + queryStr));
        HashMap<String, List<Map<String, String>>> subclassToPublications = new HashMap<String, List<Map<String, String>>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                String subclassUriStr;
                VClass vClass;
                QuerySolution soln = results.nextSolution();
                RDFNode subclassUri = soln.get("subclass");
                subclass = subclassUri != null ? ((vClass = vcDao.getVClassByURI(subclassUriStr = soln.get("subclass").toString())).getName() == null ? subclassUriStr : vClass.getName()) : "Unclassified Publication";
                if (!subclassToPublications.containsKey(subclass)) {
                    subclassToPublications.put(subclass, new ArrayList());
                }
                List<Map<String, String>> publicationsList = subclassToPublications.get(subclass);
                publicationsList.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return subclassToPublications;
    }

    private List<String> getAllSubclasses(HashMap<String, List<Map<String, String>>> publications) {
        ArrayList<String> allSubclasses = new ArrayList<String>(publications.keySet());
        Collections.sort(allSubclasses);
        return allSubclasses;
    }
}

