/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionVTwoPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.AddAssociatedConceptsPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ConceptSemanticTypesPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.ConceptSearchService.ConceptSearchServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddAssociatedConceptGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddAssociatedConceptGenerator.class);
    private String template = "addAssociatedConcept.ftl";
    private static String VIVOCore = "http://vivoweb.org/ontology/core#";
    private static String SKOSConceptType = "http://www.w3.org/2004/02/skos/core#Concept";
    private static String SKOSBroaderURI = "http://www.w3.org/2004/02/skos/core#broader";
    private static String SKOSNarrowerURI = "http://www.w3.org/2004/02/skos/core#narrower";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo editConfiguration = new EditConfigurationVTwo();
        this.initBasics(editConfiguration, vreq);
        this.initPropertyParameters(vreq, session, editConfiguration);
        this.initObjectPropForm(editConfiguration, vreq);
        editConfiguration.setTemplate(this.template);
        this.setVarNames(editConfiguration);
        editConfiguration.setN3Required(this.generateN3Required(vreq));
        editConfiguration.setN3Optional(this.generateN3Optional());
        editConfiguration.setNewResources(this.generateNewResources(vreq));
        this.setUrisAndLiteralsInScope(editConfiguration, vreq);
        this.setUrisAndLiteralsOnForm(editConfiguration, vreq);
        editConfiguration.setFilesOnForm(new ArrayList());
        this.setSparqlQueries(editConfiguration, vreq);
        this.setFields(editConfiguration, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        this.setTemplate(editConfiguration, vreq);
        this.addPreprocessors(editConfiguration);
        this.addFormSpecificData(editConfiguration, vreq);
        editConfiguration.setUrlPatternToReturnTo(EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq));
        editConfiguration.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.prepare(vreq, editConfiguration);
        return editConfiguration;
    }

    void initObjectPropForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setObject(null);
    }

    void prepare(VitroRequest vreq, EditConfigurationVTwo editConfig) {
        OntModel model = vreq.getJenaOntModel();
        if (editConfig.getSubjectUri() == null) {
            editConfig.setSubjectUri(EditConfigurationUtils.getSubjectUri((VitroRequest)vreq));
        }
        if (editConfig.getPredicateUri() == null) {
            editConfig.setPredicateUri(EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        }
        editConfig.prepareForNonUpdate((Model)model);
    }

    private void setVarNames(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setVarNameForPredicate("predicate");
        editConfiguration.setVarNameForObject("object");
    }

    protected void setTemplate(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setTemplate(this.template);
    }

    private String getPrefixesString() {
        return "@prefix core: <http://vivoweb.org/ontology/core#> .";
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        Object[] objectArray = new Object[1];
        objectArray[0] = this.getPrefixesString() + "\n" + "?subject ?predicate ?conceptNode .\n" + "?conceptNode <" + RDF.type.getURI() + "> <" + SKOSConceptType + "> .";
        List n3Required = AddAssociatedConceptGenerator.list((Object[])objectArray);
        List<String> inversePredicate = this.getInversePredicate(vreq);
        if (inversePredicate.size() > 0) {
            n3Required.add("?conceptNode <" + inversePredicate.get(0) + "> ?subject .");
        }
        return n3Required;
    }

    private List<String> generateN3Optional() {
        Object[] objectArray = new Object[4];
        objectArray[0] = "?conceptNode <" + RDFS.label.getURI() + "> ?conceptLabel .\n" + "?conceptNode <" + RDFS.isDefinedBy.getURI() + "> ?conceptSource .";
        objectArray[1] = "?conceptNode <" + RDF.type + "> ?conceptSemanticTypeURI ." + "?conceptSemanticTypeURI <" + RDFS.label.getURI() + "> ?conceptSemanticTypeLabel ." + "?conceptSemanticTypeURI <" + RDFS.subClassOf + "> <" + SKOSConceptType + "> .";
        objectArray[2] = "?conceptNode <" + SKOSNarrowerURI + "> ?conceptNarrowerURI ." + "?conceptNarrowerURI <" + SKOSBroaderURI + "> ?conceptNode .";
        objectArray[3] = "?conceptNode <" + SKOSBroaderURI + "> ?conceptBroaderURI ." + "?conceptBroaderURI <" + SKOSNarrowerURI + "> ?conceptNode .";
        return AddAssociatedConceptGenerator.list((Object[])objectArray);
    }

    private Map<String, String> generateNewResources(VitroRequest vreq) {
        HashMap<String, String> newResources = new HashMap<String, String>();
        newResources.put("conceptSemanticTypeURI", null);
        return newResources;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        urisInScope.put("inverseRolePredicate", this.getInversePredicate(vreq));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap());
    }

    private List<String> getInversePredicate(VitroRequest vreq) {
        ArrayList<String> inversePredicateArray = new ArrayList<String>();
        ObjectProperty op = EditConfigurationUtils.getObjectProperty((VitroRequest)vreq);
        if (op != null && op.getURIInverse() != null) {
            inversePredicateArray.add(op.getURIInverse());
        }
        return inversePredicateArray;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        ArrayList<String> urisOnForm = new ArrayList<String>();
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        urisOnForm.add("conceptNode");
        urisOnForm.add("conceptSource");
        urisOnForm.add("conceptSemanticTypeURI");
        urisOnForm.add("conceptBroaderURI");
        urisOnForm.add("conceptNarrowerURI");
        editConfiguration.setUrisOnform(urisOnForm);
        literalsOnForm.add("conceptLabel");
        literalsOnForm.add("conceptSemanticTypeLabel");
        editConfiguration.setLiteralsOnForm(literalsOnForm);
    }

    private void setSparqlQueries(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setSparqlForAdditionalLiteralsInScope(new HashMap());
        editConfiguration.setSparqlForAdditionalUrisInScope(new HashMap());
        editConfiguration.setSparqlForExistingLiterals(new HashMap());
        editConfiguration.setSparqlForExistingUris(new HashMap());
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        this.setConceptNodeField(editConfiguration, vreq);
        this.setConceptLabelField(editConfiguration, vreq);
        this.setVocabURIField(editConfiguration, vreq);
        this.setConceptSemanticTypeURIField(editConfiguration, vreq);
        this.setConceptSemanticTypeLabelField(editConfiguration, vreq);
        this.setConceptBroaderURIField(editConfiguration, vreq);
        this.setConceptNarrowerURIField(editConfiguration, vreq);
    }

    private void setConceptNarrowerURIField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptNarrowerURI"));
    }

    private void setConceptBroaderURIField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptBroaderURI"));
    }

    private void setConceptNodeField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptNode").setValidators(AddAssociatedConceptGenerator.list((Object[])new Object[]{"nonempty"})));
    }

    private void setVocabURIField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptSource"));
    }

    private void setConceptLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptLabel").setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void setConceptSemanticTypeURIField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptSemanticTypeURI"));
    }

    private void setConceptSemanticTypeLabelField(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.addField(new FieldVTwo().setName("conceptSemanticTypeLabel").setRangeDatatypeUri(XSD.xstring.toString()));
    }

    private void addPreprocessors(EditConfigurationVTwo editConfiguration) {
        editConfiguration.addEditSubmissionPreprocessor((EditSubmissionVTwoPreprocessor)new AddAssociatedConceptsPreprocessor(editConfiguration));
        editConfiguration.addModelChangePreprocessor((ModelChangePreprocessor)new ConceptSemanticTypesPreprocessor());
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, Object> formSpecificData = new HashMap<String, Object>();
        formSpecificData.put("existingConcepts", this.getExistingConcepts(vreq));
        formSpecificData.put("userDefinedConceptUrl", this.getUserDefinedConceptUrl(vreq));
        formSpecificData.put("searchServices", ConceptSearchServiceUtils.getVocabSources());
        List<String> inversePredicate = this.getInversePredicate(vreq);
        if (inversePredicate.size() > 0) {
            formSpecificData.put("inversePredicate", inversePredicate.get(0));
        } else {
            formSpecificData.put("inversePredicate", "");
        }
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private Object getUserDefinedConceptUrl(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String generatorName = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.AddUserDefinedConceptGenerator";
        String editUrl = EditConfigurationUtils.getEditUrl((VitroRequest)vreq);
        return editUrl + "?subjectUri=" + UrlBuilder.urlEncode((String)subjectUri) + "&predicateUri=" + UrlBuilder.urlEncode((String)predicateUri) + "&editForm=" + UrlBuilder.urlEncode((String)generatorName);
    }

    private List<AssociatedConceptInfo> getExistingConcepts(VitroRequest vreq) {
        Individual individual = EditConfigurationUtils.getSubjectIndividual((VitroRequest)vreq);
        List concepts = individual.getRelatedIndividuals(EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        List<AssociatedConceptInfo> associatedConcepts = this.getAssociatedConceptInfo(concepts, vreq);
        this.sortConcepts(associatedConcepts);
        return associatedConcepts;
    }

    private void sortConcepts(List<AssociatedConceptInfo> concepts) {
        Collections.sort(concepts, new AssociatedConceptInfoComparator());
        this.log.debug((Object)("Concepts should be sorted now" + concepts.toString()));
    }

    private List<AssociatedConceptInfo> getAssociatedConceptInfo(List<Individual> concepts, VitroRequest vreq) {
        ArrayList<AssociatedConceptInfo> info = new ArrayList<AssociatedConceptInfo>();
        for (Individual conceptIndividual : concepts) {
            boolean userGenerated = true;
            String conceptUri = conceptIndividual.getURI();
            String conceptLabel = conceptIndividual.getName();
            List vocabList = conceptIndividual.getObjectPropertyStatements(RDFS.isDefinedBy.getURI());
            String vocabSource = null;
            String vocabLabel = null;
            if (vocabList != null && vocabList.size() > 0) {
                userGenerated = false;
                vocabSource = ((ObjectPropertyStatement)vocabList.get(0)).getObjectURI();
                Individual sourceIndividual = EditConfigurationUtils.getIndividual((VitroRequest)vreq, (String)vocabSource);
                vocabLabel = sourceIndividual.getName();
            }
            if (userGenerated) {
                info.add(new AssociatedConceptInfo(conceptLabel, conceptUri, null, null, SKOSConceptType, null, null));
                continue;
            }
            String conceptSemanticTypeURI = null;
            String conceptSemanticTypeLabel = null;
            HashMap<String, String> typeAndLabel = this.getConceptSemanticTypeQueryResults(conceptIndividual.getURI(), ModelAccess.on((HttpServletRequest)vreq).getOntModel(new ModelAccess.LanguageOption[0]));
            if (typeAndLabel.containsKey("semanticTypeURI")) {
                conceptSemanticTypeURI = typeAndLabel.get("semanticTypeURI");
            }
            if (typeAndLabel.containsKey("semanticTypeLabel")) {
                conceptSemanticTypeLabel = typeAndLabel.get("semanticTypeLabel");
            }
            info.add(new AssociatedConceptInfo(conceptLabel, conceptUri, vocabSource, vocabLabel, null, conceptSemanticTypeURI, conceptSemanticTypeLabel));
        }
        return info;
    }

    private HashMap<String, String> getConceptSemanticTypeQueryResults(String conceptURI, OntModel ontModel) {
        HashMap<String, String> typeAndLabel = new HashMap<String, String>();
        String queryStr = "SELECT ?semanticTypeURI ?semanticTypeLabel WHERE { <" + conceptURI + "> <" + RDF.type.getURI() + "> ?semanticTypeURI . " + "?semanticTypeURI <" + RDFS.subClassOf.getURI() + "> <" + SKOSConceptType + ">.  " + "?semanticTypeURI <" + RDFS.label.getURI() + "> ?semanticTypeLabel ." + "}";
        try (QueryExecution qe = null;){
            Query query = QueryFactory.create((String)queryStr);
            qe = QueryExecutionFactory.create((Query)query, (Model)ontModel);
            ResultSet results = null;
            results = qe.execSelect();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                if (qs.get("semanticTypeURI") != null) {
                    Resource semanticTypeURI = qs.getResource("semanticTypeURI");
                    this.log.debug((Object)("Semantic Type URI returned " + semanticTypeURI.getURI()));
                    typeAndLabel.put("semanticTypeURI", semanticTypeURI.getURI());
                }
                if (qs.get("semanticTypeLabel") == null) continue;
                Literal semanticTypeLabel = qs.getLiteral("semanticTypeLabel");
                this.log.debug((Object)("Semantic Type label returned " + semanticTypeLabel.getString()));
                typeAndLabel.put("semanticTypeLabel", semanticTypeLabel.getString());
            }
        }
        return typeAndLabel;
    }

    public class AssociatedConceptInfoComparator
    implements Comparator<AssociatedConceptInfo> {
        @Override
        public int compare(AssociatedConceptInfo concept1, AssociatedConceptInfo concept2) {
            String concept1Label = concept1.getConceptLabel().toLowerCase();
            String concept2Label = concept2.getConceptLabel().toLowerCase();
            return concept1Label.compareTo(concept2Label);
        }
    }

    public class AssociatedConceptInfo {
        private String conceptLabel;
        private String conceptURI;
        private String vocabURI;
        private String vocabLabel;
        private String type;
        private String conceptSemanticTypeURI;
        private String conceptSemanticTypeLabel;

        public AssociatedConceptInfo(String inputLabel, String inputURI, String inputVocabURI, String inputVocabLabel, String inputType, String inputConceptSemanticTypeURI, String inputConceptSemanticTypeLabel) {
            this.conceptLabel = inputLabel;
            this.conceptURI = inputURI;
            this.vocabURI = inputVocabURI;
            this.vocabLabel = inputVocabLabel;
            this.type = inputType;
            this.conceptSemanticTypeURI = inputConceptSemanticTypeURI;
            this.conceptSemanticTypeLabel = inputConceptSemanticTypeLabel;
        }

        public String getConceptLabel() {
            return this.conceptLabel;
        }

        public String getConceptURI() {
            return this.conceptURI;
        }

        public String getVocabURI() {
            return this.vocabURI;
        }

        public String getVocabLabel() {
            return this.vocabLabel;
        }

        public String getType() {
            return this.type;
        }

        public String getConceptSemanticTypeURI() {
            return this.conceptSemanticTypeURI;
        }

        public String getConceptSemanticTypeLabel() {
            return this.conceptSemanticTypeLabel;
        }
    }
}

