/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.IndividualsViaVClassOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;

public class PersonHasEducationalTraining
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewEdTraining = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?person <http://purl.obolibrary.org/obo/RO_0000056>  ?edTraining .\n?edTraining  a core:EducationalProcess .\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?person .";
    static final String trainingTypeAssertion = "?edTraining a ?trainingType .";
    static final String n3ForAwardedDegree = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?awardedDegree . \n?awardedDegree <http://purl.obolibrary.org/obo/RO_0002353> ?edTraining . \n?awardedDegree <http://vivoweb.org/ontology/core#relates> ?person . \n?person <http://vivoweb.org/ontology/core#relatedBy> ?awardedDegree . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?awardedDegree <http://vivoweb.org/ontology/core#relates> ?degreeType .\n?degreeType <http://vivoweb.org/ontology/core#relatedBy> ?awardedDegree . \n?awardedDegree a core:AwardedDegree .";
    static final String n3ForNewOrganization = "?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?newOrg . \n?newOrg <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n?newOrg a ?orgType . \n?newOrg <http://www.w3.org/2000/01/rdf-schema#label> ?orgLabel . ";
    static final String n3ForExistingOrganization = "?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingOrg . \n?existingOrg <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n?existingOrg a ?orgType . ";
    static final String n3ForNewOrgAwardedDegree = "?awardedDegree <http://vivoweb.org/ontology/core#assignedBy> ?newOrg . \n?newOrg <http://vivoweb.org/ontology/core#assigns> ?awardedDegree . \n?newOrg a ?orgType . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?newOrg <http://www.w3.org/2000/01/rdf-schema#label> ?orgLabel . ";
    static final String n3ForExistingOrgAwardedDegree = "?awardedDegree <http://vivoweb.org/ontology/core#assignedBy> ?existingOrg . \n?existingOrg <http://vivoweb.org/ontology/core#assigns> ?awardedDegree . \n?awardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?awardedDegreeLabel . \n?existingOrg a ?orgType . ";
    static final String majorFieldAssertion = "?edTraining <http://vivoweb.org/ontology/core#majorField> ?majorField .";
    static final String n3ForStart = "?edTraining      <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value .\n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision .";
    static final String n3ForEnd = "?edTraining      <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode  <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value .\n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision .";
    static final String deptAssertion = "?edTraining <http://vivoweb.org/ontology/core#departmentOrSchool> ?dept .";
    static final String infoAssertion = "?edTraining <http://vivoweb.org/ontology/core#supplementalInformation> ?info .";
    static final String existingAwardedDegreeQuery = "SELECT ?existingAwardedDegree WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . }\n";
    static final String existingAwardedDegreeLabelQuery = "SELECT ?existingAwardedDegreeLabel WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . \n?existingAwardedDegree <http://www.w3.org/2000/01/rdf-schema#label> ?existingAwardedDegreeLabel }\n";
    static final String existingOrgQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingOrg WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingOrg . \n?existingOrg <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining . \n?existingOrg a ?existingOrgType . \n ?existingOrgType rdfs:subClassOf <http://xmlns.com/foaf/0.1/Organization> . }";
    static final String orgLabelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingOrgLabel WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingOrg . \n?existingOrg <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining .\n?existingOrg <http://www.w3.org/2000/01/rdf-schema#label> ?existingOrgLabel .\n?existingOrg a ?existingOrgType . \n ?existingOrgType rdfs:subClassOf <http://xmlns.com/foaf/0.1/Organization> . }";
    static final String orgTypeQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingOrgType WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0000057> ?existingOrg . \n?existingOrg <http://purl.obolibrary.org/obo/RO_0000056> ?edTraining .\n?existingOrg a ?existingOrgType .\n?existingOrgType rdfs:subClassOf <http://xmlns.com/foaf/0.1/Organization> .\n}";
    static final String trainingTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingTrainingType WHERE { \n  ?edTraining vitro:mostSpecificType ?existingTrainingType .  }";
    static final String degreeTypeQuery = "PREFIX core: <http://vivoweb.org/ontology/core#> \nSELECT ?existingDegreeType WHERE {\n?edTraining <http://purl.obolibrary.org/obo/RO_0002234> ?existingAwardedDegree . \n?existingAwardedDegree a core:AwardedDegree . \n?existingAwardedDegree core:relates ?existingDegreeType .  \n?existingDegreeType a core:AcademicDegree }";
    static final String majorFieldQuery = "SELECT ?existingMajorField WHERE {\n?edTraining <http://vivoweb.org/ontology/core#majorField> ?existingMajorField . }";
    static final String deptQuery = "SELECT ?existingDept WHERE {\n?edTraining <http://vivoweb.org/ontology/core#departmentOrSchool> ?existingDept . }";
    static final String infoQuery = "SELECT ?existingInfo WHERE {\n?edTraining <http://vivoweb.org/ontology/core#supplementalInformation> ?existingInfo . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode .\n?existingIntervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n?existingStartNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}";
    static final String existingStartDateQuery = "SELECT ?existingDateStart WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode .\n?startNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n?existingEndNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .}";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE {\n?edTraining <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode .\n?intervalNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeInterval> .\n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode .\n?endNode <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://vivoweb.org/ontology/core#DateTimeValue> .\n?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";
    static final String inverseTrainingAtOrgQuery = "PREFIX owl:  <http://www.w3.org/2002/07/owl#> SELECT ?inverseTrainingAtOrg     WHERE { ?inverseTrainingAtOrg owl:inverseOf <http://vivoweb.org/ontology/core#relates> . } ";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("personHasEducationalTraining.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("edTraining");
        conf.setN3Required(Arrays.asList(n3ForNewEdTraining, trainingTypeAssertion));
        conf.setN3Optional(Arrays.asList(majorFieldAssertion, n3ForAwardedDegree, n3ForNewOrganization, n3ForExistingOrganization, n3ForNewOrgAwardedDegree, n3ForExistingOrgAwardedDegree, deptAssertion, infoAssertion, n3ForStart, n3ForEnd));
        conf.addNewResource("edTraining", "");
        conf.addNewResource("awardedDegree", "");
        conf.addNewResource("newOrg", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("existingOrg", "orgType", "degreeType", "trainingType"));
        conf.setLiteralsOnForm(Arrays.asList("orgLabel", "orgLabelDisplay", "awardedDegreeLabel", "majorField", "dept", "info"));
        conf.addSparqlForExistingLiteral("orgLabel", orgLabelQuery);
        conf.addSparqlForExistingLiteral("majorField", majorFieldQuery);
        conf.addSparqlForExistingLiteral("dept", deptQuery);
        conf.addSparqlForExistingLiteral("info", infoQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("awardedDegree", existingAwardedDegreeQuery);
        conf.addSparqlForExistingUris("existingOrg", existingOrgQuery);
        conf.addSparqlForExistingUris("orgType", orgTypeQuery);
        conf.addSparqlForExistingUris("trainingType", trainingTypeQuery);
        conf.addSparqlForExistingUris("degreeType", degreeTypeQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addSparqlForAdditionalUrisInScope("inverseTrainingAtOrg", inverseTrainingAtOrgQuery);
        conf.addField(new FieldVTwo().setName("degreeType").setOptions((FieldOptions)new IndividualsViaVClassOptions(new String[]{"http://vivoweb.org/ontology/core#AcademicDegree"})));
        conf.addField(new FieldVTwo().setName("majorField").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingOrg"));
        conf.addField(new FieldVTwo().setName("awardedDegree"));
        conf.addField(new FieldVTwo().setName("orgLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("awardedDegreeLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("existingAwardedDegreeLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("orgLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("orgType").setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesOptions("http://xmlns.com/foaf/0.1/Organization")));
        conf.addField(new FieldVTwo().setName("trainingType").setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent("http://vivoweb.org/ontology/core#EducationalProcess")));
        conf.addField(new FieldVTwo().setName("dept").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("info").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasEducationalTraining.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        FieldVTwo startField = new FieldVTwo().setName("startField");
        conf.addField(startField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(startField, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        FieldVTwo endField = new FieldVTwo().setName("endField");
        conf.addField(endField.setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(endField, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("http://vivoweb.org/ontology/core#relates");
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }
}

