/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VitroVocabulary;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeIntervalValidationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.DateTimeWithPrecisionVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditElementVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;

public class PersonHasPositionHistoryGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String positionClass = "http://vivoweb.org/ontology/core#Position";
    static final String orgClass = "http://xmlns.com/foaf/0.1/Organization";
    static final String positionInOrgPred = "http://vivoweb.org/ontology/core#relates";
    static final String orgForPositionPred = "http://vivoweb.org/ontology/core#relatedBy";
    static final String positionToInterval = "http://vivoweb.org/ontology/core#dateTimeInterval";
    static final String intervalType = "http://vivoweb.org/ontology/core#DateTimeInterval";
    static final String intervalToStart = "http://vivoweb.org/ontology/core#start";
    static final String intervalToEnd = "http://vivoweb.org/ontology/core#end";
    static final String dateTimeValueType = "http://vivoweb.org/ontology/core#DateTimeValue";
    static final String dateTimeValue = "http://vivoweb.org/ontology/core#dateTime";
    static final String dateTimePrecision = "http://vivoweb.org/ontology/core#dateTimePrecision";
    static final String n3ForNewPosition = "@prefix core: <http://vivoweb.org/ontology/core#> . \n?person core:relatedBy  ?position . \n?position a  ?positionType . \n?position core:relates ?person ; ";
    static final String positionTitleAssertion = "?position <http://www.w3.org/2000/01/rdf-schema#label> ?positionTitle .";
    static final String positionTypeAssertion = "?position a ?positionType .";
    static final String n3ForNewOrg = "?position <http://vivoweb.org/ontology/core#relates> ?newOrg . \n?newOrg <http://vivoweb.org/ontology/core#relatedBy> ?position . \n?newOrg <http://www.w3.org/2000/01/rdf-schema#label> ?orgLabel . \n?newOrg a ?orgType .";
    static final String n3ForExistingOrg = "?position <http://vivoweb.org/ontology/core#relates> ?existingOrg . \n?existingOrg <http://vivoweb.org/ontology/core#relatedBy> ?position . \n?existingOrg a ?orgType .";
    static final String n3ForStart = "?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?startNode  <http://vivoweb.org/ontology/core#dateTime> ?startField-value . \n?startNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?startField-precision . \n";
    static final String n3ForEnd = "?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n?endNode  <http://vivoweb.org/ontology/core#dateTime> ?endField-value . \n?endNode  <http://vivoweb.org/ontology/core#dateTimePrecision> ?endField-precision . \n";
    static final String orgLabelQuery = "SELECT ?existingOrgLabel WHERE { \n  ?position <http://vivoweb.org/ontology/core#relates> ?existingOrg . \n  ?existingOrg a <http://xmlns.com/foaf/0.1/Organization> . \n  ?existingOrg <http://www.w3.org/2000/01/rdf-schema#label> ?existingOrgLabel . \n}";
    static final String positionTitleQuery = "SELECT ?existingPositionTitle WHERE { \n?position <http://www.w3.org/2000/01/rdf-schema#label> ?existingPositionTitle . }";
    static final String existingStartDateQuery = "SELECT ?existingDateStart WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTime> ?existingDateStart . }";
    static final String existingEndDateQuery = "SELECT ?existingEndDate WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n   ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTime> ?existingEndDate . }";
    static final String existingOrgQuery = "SELECT ?existingOrg WHERE { \n  ?position <http://vivoweb.org/ontology/core#relates> ?existingOrg . \n  ?existingOrg a <http://xmlns.com/foaf/0.1/Organization>  }";
    static final String orgTypeQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT ?existingOrgType WHERE { \n  ?position <http://vivoweb.org/ontology/core#relates> ?existingOrg . \n  ?existingOrg a ?existingOrgType . \n  ?existingOrgType rdfs:subClassOf <http://xmlns.com/foaf/0.1/Organization> } ";
    static final String positionTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?existingPositionType WHERE { \n  ?position vitro:mostSpecificType ?existingPositionType . }";
    static final String existingIntervalNodeQuery = "SELECT ?existingIntervalNode WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?existingIntervalNode . \n  ?existingIntervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . }";
    static final String existingStartNodeQuery = "SELECT ?existingStartNode WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?existingStartNode . \n  ?existingStartNode a <http://vivoweb.org/ontology/core#DateTimeValue> .}   ";
    static final String existingEndNodeQuery = "SELECT ?existingEndNode WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?existingEndNode . \n  ?existingEndNode a <http://vivoweb.org/ontology/core#DateTimeValue> } ";
    static final String existingStartPrecisionQuery = "SELECT ?existingStartPrecision WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#start> ?startNode . \n  ?startNode a  <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?startNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingStartPrecision . }";
    static final String existingEndPrecisionQuery = "SELECT ?existingEndPrecision WHERE { \n  ?position <http://vivoweb.org/ontology/core#dateTimeInterval> ?intervalNode . \n  ?intervalNode a <http://vivoweb.org/ontology/core#DateTimeInterval> . \n  ?intervalNode <http://vivoweb.org/ontology/core#end> ?endNode . \n  ?endNode a <http://vivoweb.org/ontology/core#DateTimeValue> . \n  ?endNode <http://vivoweb.org/ontology/core#dateTimePrecision> ?existingEndPrecision . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("personHasPositionHistory.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("position");
        conf.setN3Required(Arrays.asList(n3ForNewPosition, positionTitleAssertion, positionTypeAssertion));
        conf.setN3Optional(Arrays.asList(n3ForNewOrg, n3ForExistingOrg, n3ForStart, n3ForEnd));
        conf.addNewResource("position", "");
        conf.addNewResource("newOrg", "");
        conf.addNewResource("intervalNode", "");
        conf.addNewResource("startNode", "");
        conf.addNewResource("endNode", "");
        conf.setUrisOnform(Arrays.asList("existingOrg", "orgType", "positionType"));
        conf.setLiteralsOnForm(Arrays.asList("positionTitle", "orgLabel", "orgLabelDisplay"));
        conf.addSparqlForExistingLiteral("orgLabel", orgLabelQuery);
        conf.addSparqlForExistingLiteral("positionTitle", positionTitleQuery);
        conf.addSparqlForExistingLiteral("startField-value", existingStartDateQuery);
        conf.addSparqlForExistingLiteral("endField-value", existingEndDateQuery);
        conf.addSparqlForExistingUris("existingOrg", existingOrgQuery);
        conf.addSparqlForExistingUris("orgType", orgTypeQuery);
        conf.addSparqlForExistingUris("positionType", positionTypeQuery);
        conf.addSparqlForExistingUris("intervalNode", existingIntervalNodeQuery);
        conf.addSparqlForExistingUris("startNode", existingStartNodeQuery);
        conf.addSparqlForExistingUris("endNode", existingEndNodeQuery);
        conf.addSparqlForExistingUris("startField-precision", existingStartPrecisionQuery);
        conf.addSparqlForExistingUris("endField-precision", existingEndPrecisionQuery);
        conf.addField(new FieldVTwo().setName("positionTitle").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasPositionHistoryGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("positionType").setValidators(PersonHasPositionHistoryGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent(positionClass)));
        conf.addField(new FieldVTwo().setName("existingOrg"));
        conf.addField(new FieldVTwo().setName("orgLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(PersonHasPositionHistoryGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("orgLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("orgType").setOptions((FieldOptions)new ChildVClassesWithParent(orgClass)));
        conf.addField(new FieldVTwo().setName("startField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addField(new FieldVTwo().setName("endField").setEditElement((EditElementVTwo)new DateTimeWithPrecisionVTwo(null, VitroVocabulary.Precision.YEAR.uri(), VitroVocabulary.Precision.NONE.uri())));
        conf.addValidator((N3ValidatorVTwo)new DateTimeIntervalValidationVTwo("startField", "endField"));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingOrg", "orgLabel"));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add(positionInOrgPred);
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }
}

