/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.searchindex.documentBuilding;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TotalInd
implements Runnable {
    private Dataset dataset;
    private String totalCountQuery;
    private static Log log = LogFactory.getLog(TotalInd.class);

    public TotalInd(Dataset dataset, String totalCountQuery) {
        this.dataset = dataset;
        this.totalCountQuery = totalCountQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int totalInd = 0;
        QuerySolution soln = null;
        this.dataset.getLock().enterCriticalSection(true);
        QueryExecution qexec = null;
        try {
            Query query = QueryFactory.create((String)this.totalCountQuery, (Syntax)Syntax.syntaxARQ);
            qexec = QueryExecutionFactory.create((Query)query, (Dataset)this.dataset);
            ResultSet results = qexec.execSelect();
            List resultVars = results.getResultVars();
            if (resultVars != null && resultVars.size() != 0) {
                soln = results.next();
                totalInd = Integer.parseInt(soln.getLiteral((String)resultVars.get(0)).getLexicalForm());
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
            this.dataset.getLock().leaveCriticalSection();
        }
    }
}

