/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.dataGetter;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.DataGetterUtils;
import edu.cornell.mannlib.vitro.webapp.utils.dataGetter.IndividualsForClassesDataGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalClassesDataGetter
extends IndividualsForClassesDataGetter {
    private static final Log log = LogFactory.getLog(InternalClassesDataGetter.class);
    protected static final String individualsForClassesInternalQueryString = "PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX xsd:  <http://www.w3.org/2001/XMLSchema#> \nPREFIX display: <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#> \n\nSELECT?class ?isInternal WHERE {\n ?dataGetterUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass> ?class . \n OPTIONAL {  ?dataGetterUri <http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass> ?isInternal } .\n} \n";

    public InternalClassesDataGetter(VitroRequest vreq, Model displayModel, String dataGetterURI) {
        super(vreq, displayModel, dataGetterURI);
    }

    protected void setTemplateName() {
        IndividualsForClassesDataGetter.restrictClassesTemplateName = "internalClass";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getClassIntersectionsMap(Model displayModel) {
        HashMap<String, Object> classesAndRestrictions = new HashMap<String, Object>();
        QuerySolutionMap initialBindings = new QuerySolutionMap();
        initialBindings.add("dataGetterUri", (RDFNode)ResourceFactory.createResource((String)this.dataGetterURI));
        ArrayList<String> classes = new ArrayList<String>();
        displayModel.enterCriticalSection(false);
        try {
            HashMap<String, Object> hashMap;
            QueryExecution qexec;
            block9: {
                Query individualsForClassesInternalQuery = QueryFactory.create((String)individualsForClassesInternalQueryString);
                qexec = QueryExecutionFactory.create((Query)individualsForClassesInternalQuery, (Model)displayModel, (QuerySolution)initialBindings);
                try {
                    ResultSet resultSet = qexec.execSelect();
                    while (resultSet.hasNext()) {
                        QuerySolution soln = resultSet.next();
                        String dg = DataGetterUtils.nodeToString((RDFNode)soln.get("dg"));
                        classes.add(DataGetterUtils.nodeToString((RDFNode)soln.get("class")));
                        String isInternal = DataGetterUtils.nodeToString((RDFNode)soln.get("isInternal"));
                        if (isInternal.isEmpty()) continue;
                        log.debug((Object)("Internal value is " + isInternal));
                        classesAndRestrictions.put("isInternal", isInternal);
                    }
                    if (classes.size() != 0) break block9;
                    log.debug((Object)("No classes  defined in display model for " + this.dataGetterURI));
                    hashMap = null;
                }
                catch (Throwable throwable) {
                    qexec.close();
                    throw throwable;
                }
                qexec.close();
                return hashMap;
            }
            classesAndRestrictions.put("classes", classes);
            hashMap = classesAndRestrictions;
            qexec.close();
            return hashMap;
        }
        finally {
            displayModel.leaveCriticalSection();
        }
    }

    protected List<String> retrieveRestrictClasses(ServletContext context, Map<String, Object> classIntersectionsMap) {
        OntModel mainModel;
        StmtIterator internalIt;
        ArrayList<String> restrictClasses = new ArrayList<String>();
        String internalClass = (String)classIntersectionsMap.get("isInternal");
        if (internalClass != null && internalClass.equals("true") && (internalIt = (mainModel = ModelAccess.on((ServletContext)context).getOntModel("http://vitro.mannlib.cornell.edu/default/asserted-tbox")).listStatements(null, ResourceFactory.createProperty((String)"http://vitro.mannlib.cornell.edu/ns/vitro/0.7#isMenuPageIntersectionClass"), (RDFNode)null)).hasNext()) {
            Statement s = internalIt.nextStatement();
            String internalClassUri = s.getSubject().getURI();
            log.debug((Object)("Found internal class uri " + internalClassUri));
            restrictClasses.add(internalClassUri);
        }
        return restrictClasses;
    }

    public String getType() {
        return DataGetterUtils.generateDataGetterTypeURI((String)InternalClassesDataGetter.class.getName());
    }
}

