/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.visualization;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Syntax;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.visualization.VisualizationsDependencyInjector;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShortURLVisualizationController
extends FreemarkerHttpServlet {
    public static final String URL_ENCODING_SCHEME = "UTF-8";
    private static final Log log = LogFactory.getLog((String)ShortURLVisualizationController.class.getName());
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    public static ServletContext servletContext;

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        AuthorizationRequest requiredPrivileges;
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        if (visRequestHandler != null && (requiredPrivileges = visRequestHandler.getRequiredPrivileges()) != null) {
            return requiredPrivileges;
        }
        return super.requiredActions(vreq);
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        servletContext = this.getServletContext();
        if (visRequestHandler != null) {
            return this.renderVisualization(vreq, visRequestHandler);
        }
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", "Inappropriate query parameters were submitted.", vreq);
    }

    private ResponseValues renderVisualization(VitroRequest vitroRequest, VisualizationRequestHandler visRequestHandler) {
        OntModel model = vitroRequest.getJenaOntModel();
        if (model == null) {
            String errorMessage = "This service is not supporeted by the current webapp configuration. A jena model is required in the servlet context.";
            log.error((Object)errorMessage);
            return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
        }
        Dataset dataset = this.setupJENADataSource(vitroRequest);
        if (dataset != null && visRequestHandler != null) {
            try {
                List<String> matchedPatternGroups = this.extractShortURLParameters(vitroRequest);
                Map<String, String> parametersForVis = this.getParamatersForVis(matchedPatternGroups, vitroRequest);
                return visRequestHandler.generateVisualizationForShortURLRequests(parametersForVis, vitroRequest, log, dataset);
            }
            catch (MalformedQueryParametersException e) {
                return UtilityFunctions.handleMalformedParameters("Standard Visualization Query Error - Individual Publication Count", e.getMessage(), vitroRequest);
            }
        }
        String errorMessage = "Data Model Empty &/or Inappropriate query parameters were submitted. ";
        log.error((Object)errorMessage);
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
    }

    private Map<String, String> getParamatersForVis(List<String> matchedPatternGroups, VitroRequest vitroRequest) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String subjectURI = null;
        subjectURI = matchedPatternGroups.size() <= 1 ? vitroRequest.getParameter("uri") : vitroRequest.getWebappDaoFactory().getDefaultNamespace() + matchedPatternGroups.get(1);
        subjectURI = StringEscapeUtils.escapeHtml((String)subjectURI);
        parameters.put("uri", subjectURI);
        if ("author-network".equalsIgnoreCase(matchedPatternGroups.get(0))) {
            parameters.put("vis_mode", "coauthor");
        } else if ("investigator-network".equalsIgnoreCase(matchedPatternGroups.get(0))) {
            parameters.put("vis_mode", "copi");
        }
        return parameters;
    }

    private VisualizationRequestHandler getVisualizationRequestHandler(VitroRequest vitroRequest) {
        String visType = null;
        VisualizationRequestHandler visRequestHandler = null;
        List<String> matchedPatternGroups = this.extractShortURLParameters(vitroRequest);
        if (matchedPatternGroups.size() > 0) {
            visType = matchedPatternGroups.get(0);
            try {
                visRequestHandler = VisualizationsDependencyInjector.getVisualizationIDsToClassMap(this.getServletContext()).get(visType);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return visRequestHandler;
    }

    private List<String> extractShortURLParameters(VitroRequest vitroRequest) {
        ArrayList<String> matchedGroups = new ArrayList<String>();
        String subURIString = vitroRequest.getRequestURI().substring(vitroRequest.getContextPath().length() + 1);
        String[] urlParams = StringEscapeUtils.escapeHtml((String)subURIString).split("/");
        if (urlParams.length > 1 && urlParams[0].equalsIgnoreCase("vis")) {
            for (int ii = 1; ii < urlParams.length; ++ii) {
                matchedGroups.add(urlParams[ii]);
            }
        }
        return matchedGroups;
    }

    private Dataset setupJENADataSource(VitroRequest vreq) {
        log.debug((Object)"rdfResultFormat was: RDF/XML-ABBREV");
        return vreq.getDataset();
    }
}

