/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.visualization;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Syntax;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.visualization.VisualizationsDependencyInjector;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardVisualizationController
extends FreemarkerHttpServlet {
    public static final String URL_ENCODING_SCHEME = "UTF-8";
    private static final Log log = LogFactory.getLog((String)StandardVisualizationController.class.getName());
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    public static ServletContext servletContext;

    protected AuthorizationRequest requiredActions(VitroRequest vreq) {
        AuthorizationRequest requiredPrivileges;
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        if (visRequestHandler != null && (requiredPrivileges = visRequestHandler.getRequiredPrivileges()) != null) {
            return requiredPrivileges;
        }
        return super.requiredActions(vreq);
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        VisualizationRequestHandler visRequestHandler = this.getVisualizationRequestHandler(vreq);
        servletContext = this.getServletContext();
        if (visRequestHandler != null) {
            return this.renderVisualization(vreq, visRequestHandler);
        }
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", "Inappropriate query parameters were submitted.", vreq);
    }

    private ResponseValues renderVisualization(VitroRequest vitroRequest, VisualizationRequestHandler visRequestHandler) {
        OntModel model = vitroRequest.getJenaOntModel();
        if (model == null) {
            String errorMessage = "This service is not supporeted by the current webapp configuration. A jena model is required in the servlet context.";
            log.error((Object)errorMessage);
            return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
        }
        Dataset dataset = this.setupJENADataSource(vitroRequest);
        if (dataset != null && visRequestHandler != null) {
            try {
                return visRequestHandler.generateStandardVisualization(vitroRequest, log, dataset);
            }
            catch (MalformedQueryParametersException e) {
                return UtilityFunctions.handleMalformedParameters("Standard Visualization Query Error - Individual Publication Count", e.getMessage(), vitroRequest);
            }
        }
        String errorMessage = "Data Model Empty &/or Inappropriate query parameters were submitted. ";
        log.error((Object)errorMessage);
        return UtilityFunctions.handleMalformedParameters("Visualization Query Error", errorMessage, vitroRequest);
    }

    private VisualizationRequestHandler getVisualizationRequestHandler(VitroRequest vitroRequest) {
        String visType = vitroRequest.getParameter("vis");
        VisualizationRequestHandler visRequestHandler = null;
        try {
            visRequestHandler = VisualizationsDependencyInjector.getVisualizationIDsToClassMap(this.getServletContext()).get(visType);
        }
        catch (NullPointerException nullKeyException) {
            return null;
        }
        return visRequestHandler;
    }

    private Dataset setupJENADataSource(VitroRequest vreq) {
        log.debug((Object)"rdfResultFormat was: RDF/XML-ABBREV");
        return vreq.getDataset();
    }
}

