/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddEditWebpageFormGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(AddEditWebpageFormGenerator.class);
    private static String formTemplate = "addEditWebpageForm.ftl";
    static String N3_FOR_WEBPAGE = "?subject ?webpageProperty ?vcard . \n?vcard ?inverseProperty ?subject . \n?vcard a ?vcardType . \n?vcard <http://www.w3.org/2006/vcard/ns#hasURL> ?link .?link a <http://www.w3.org/2006/vcard/ns#URL> . \n?link ?linkUrlPredicate ?url .";
    static String N3_FOR_URLTYPE = "?link a ?urlType .";
    static String N3_FOR_ANCHOR = "?link ?linkLabelPredicate ?label .";
    static String N3_FOR_RANK = "?link ?rankPredicate ?rank .";
    static String URL_QUERY = "SELECT ?urlExisting WHERE { ?link ?linkUrlPredicate ?urlExisting }";
    static String URLTYPE_QUERY = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?linkClassExisting WHERE { ?link vitro:mostSpecificType ?linkClassExisting }";
    static String ANCHOR_QUERY = "SELECT ?labelExisting WHERE { ?link ?linkLabelPredicate ?labelExisting }";
    static String RANK_QUERY = "SELECT ?rankExisting WHERE { ?link ?rankPredicate ?rankExisting }";
    static String core = "http://vivoweb.org/ontology/core#";
    static String individualVcardQuery = "SELECT ?existingVcard WHERE { \n?subject <http://purl.obolibrary.org/obo/ARG_2000028>  ?existingVcard . \n}";
    private static String MAX_RANK_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#> \nSELECT DISTINCT ?rank WHERE { \n    ?subject <http://purl.obolibrary.org/obo/ARG_2000028> ?vcard . \n    ?vcard vcard:hasURL ?link . \n    ?link core:rank ?rank .\n} ORDER BY DESC(?rank) LIMIT 1";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo config = this.setupConfig(vreq, session);
        config.setUrlPatternToReturnTo(this.getUrlPatternToReturnTo(vreq));
        this.prepare(vreq, config);
        return config;
    }

    protected EditConfigurationVTwo setupConfig(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setTemplate(this.getTemplate());
        this.initBasics(config, vreq);
        this.initPropertyParameters(vreq, session, config);
        this.initObjectPropForm(config, vreq);
        String linkUri = this.getLinkUri(vreq);
        String domainUri = vreq.getParameter("domainUri");
        String vcardIndividualType = "http://www.w3.org/2006/vcard/ns#Kind";
        config.setVarNameForSubject("subject");
        config.setVarNameForObject("vcard");
        config.addNewResource("vcard", "");
        config.addNewResource("link", "");
        config.setN3Required(AddEditWebpageFormGenerator.list((Object[])new Object[]{this.getN3ForWebpage(), N3_FOR_URLTYPE}));
        config.setN3Optional(AddEditWebpageFormGenerator.list((Object[])new Object[]{N3_FOR_ANCHOR, N3_FOR_RANK}));
        config.addUrisInScope("webpageProperty", AddEditWebpageFormGenerator.list((Object[])new Object[]{"http://purl.obolibrary.org/obo/ARG_2000028"}));
        config.addUrisInScope("inverseProperty", AddEditWebpageFormGenerator.list((Object[])new Object[]{"http://purl.obolibrary.org/obo/ARG_2000029"}));
        config.addUrisInScope("linkUrlPredicate", AddEditWebpageFormGenerator.list((Object[])new Object[]{"http://www.w3.org/2006/vcard/ns#url"}));
        config.addUrisInScope("linkLabelPredicate", AddEditWebpageFormGenerator.list((Object[])new Object[]{"http://www.w3.org/2000/01/rdf-schema#label"}));
        config.addUrisInScope("rankPredicate", AddEditWebpageFormGenerator.list((Object[])new Object[]{core + "rank"}));
        config.addUrisInScope("vcardType", AddEditWebpageFormGenerator.list((Object[])new Object[]{vcardIndividualType}));
        if (config.isUpdate()) {
            config.addUrisInScope("link", AddEditWebpageFormGenerator.list((Object[])new Object[]{linkUri}));
        } else if (domainUri.equals("http://xmlns.com/foaf/0.1/Person")) {
            vcardIndividualType = "http://www.w3.org/2006/vcard/ns#Individual";
        } else if (domainUri.equals("http://xmlns.com/foaf/0.1/Organization")) {
            vcardIndividualType = "http://www.w3.org/2006/vcard/ns#Organization";
        }
        config.addSparqlForAdditionalUrisInScope("vcard", individualVcardQuery);
        config.setUrisOnForm(new String[]{"urlType"});
        config.setLiteralsOnForm(AddEditWebpageFormGenerator.list((Object[])new Object[]{"url", "label", "rank"}));
        config.addSparqlForExistingLiteral("url", URL_QUERY);
        config.addSparqlForExistingLiteral("label", ANCHOR_QUERY);
        config.addSparqlForExistingLiteral("rank", MAX_RANK_QUERY);
        config.addSparqlForExistingUris("urlType", URLTYPE_QUERY);
        config.addField(new FieldVTwo().setName("url").setValidators(AddEditWebpageFormGenerator.list((Object[])new Object[]{"nonempty", "datatype:" + XSD.anyURI.toString(), "httpUrl"})).setRangeDatatypeUri(XSD.anyURI.toString()));
        config.addField(new FieldVTwo().setName("urlType").setValidators(AddEditWebpageFormGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent("http://www.w3.org/2006/vcard/ns#URL")));
        config.addField(new FieldVTwo().setName("label"));
        config.addField(new FieldVTwo().setName("rank").setRangeDatatypeUri(XSD.xint.toString()));
        config.addFormSpecificData("newRank", (Object)(this.getMaxRank(EditConfigurationUtils.getObjectUri((VitroRequest)vreq), EditConfigurationUtils.getSubjectUri((VitroRequest)vreq), vreq) + 1));
        config.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        config.addFormSpecificData("subjectName", this.getName(config, vreq));
        return config;
    }

    private Object getName(EditConfigurationVTwo config, VitroRequest vreq) {
        Individual ind = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(config.getSubjectUri());
        if (ind == null) {
            return null;
        }
        return ind.getName();
    }

    private int getMaxRank(String objectUri, String subjectUri, VitroRequest vreq) {
        int maxRank = 0;
        if (objectUri == null) {
            String queryStr = QueryUtils.subUriForQueryVar((String)this.getMaxRankQueryStr(), (String)"subject", (String)subjectUri);
            log.debug((Object)("Query string is: " + queryStr));
            try {
                int rank;
                QuerySolution soln;
                RDFNode node;
                ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
                if (results != null && results.hasNext() && (node = (soln = results.next()).get("rank")) != null && node.isLiteral() && (rank = Integer.parseInt(node.asLiteral().getLexicalForm())) > maxRank) {
                    log.debug((Object)("setting maxRank to " + rank));
                    maxRank = rank;
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)"Invalid rank returned from query: not an integer value.");
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return maxRank;
    }

    protected String getTemplate() {
        return formTemplate;
    }

    protected String getMaxRankQueryStr() {
        return MAX_RANK_QUERY;
    }

    protected String getN3ForWebpage() {
        return N3_FOR_WEBPAGE;
    }

    private String getUrlPatternToReturnTo(VitroRequest vreq) {
        String subjectUri = EditConfigurationUtils.getSubjectUri((VitroRequest)vreq);
        String predicateUri = EditConfigurationUtils.getPredicateUri((VitroRequest)vreq);
        String domainUri = vreq.getParameter("domainUri");
        String rangeUri = vreq.getParameter("rangeUri");
        String generatorName = "edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManageWebpagesForIndividualGenerator";
        String editUrl = EditConfigurationUtils.getEditUrlWithoutContext((VitroRequest)vreq);
        String returnPath = editUrl + "?subjectUri=" + UrlBuilder.urlEncode((String)subjectUri) + "&predicateUri=" + UrlBuilder.urlEncode((String)predicateUri) + "&editForm=" + UrlBuilder.urlEncode((String)generatorName);
        if (domainUri != null && !domainUri.isEmpty()) {
            returnPath = returnPath + "&domainUri=" + UrlBuilder.urlEncode((String)domainUri);
        }
        if (rangeUri != null && !rangeUri.isEmpty()) {
            returnPath = returnPath + "&rangeUri=" + UrlBuilder.urlEncode((String)rangeUri);
        }
        return returnPath;
    }

    private String getLinkUri(VitroRequest vreq) {
        String linkUri = vreq.getParameter("linkUri");
        return linkUri;
    }
}

