/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.capabilitymap;

import com.google.gson.Gson;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.capabilitymap.CapabilityMapResponse;
import edu.cornell.mannlib.vitro.webapp.visualization.capabilitymap.CapabilityMapResult;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.model.ConceptLabelMap;
import edu.cornell.mannlib.vitro.webapp.visualization.model.ConceptPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.model.OrganizationPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.VisualizationCaches;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis.utils.StringUtils;
import org.apache.commons.logging.Log;

public class CapabilityMapRequestHandler
implements VisualizationRequestHandler {
    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        return null;
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        return this.prepareMarkup(vitroRequest);
    }

    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        ConceptLabelMap conceptLabelMap = VisualizationCaches.conceptToLabel.get(vitroRequest.getRDFService());
        ConceptPeopleMap conceptPeopleMap = VisualizationCaches.conceptToPeopleMap.get(vitroRequest.getRDFService());
        OrganizationPeopleMap organizationPeopleMap = VisualizationCaches.organisationToPeopleMap.get(vitroRequest.getRDFService());
        Map<String, String> organizationLabels = VisualizationCaches.organizationLabels.get(vitroRequest.getRDFService());
        String data = vitroRequest.getParameter("data");
        if (!StringUtils.isEmpty((String)data)) {
            if ("concepts".equalsIgnoreCase(data)) {
                HashSet<String> concepts = new HashSet<String>();
                for (String conceptKey : conceptPeopleMap.conceptToPeople.keySet()) {
                    String label = conceptLabelMap.conceptToLabel.get(conceptKey);
                    if (StringUtils.isEmpty((String)label)) continue;
                    concepts.add(conceptLabelMap.conceptToLabel.get(conceptKey));
                }
                Gson gson = new Gson();
                return gson.toJson(concepts);
            }
            return "";
        }
        String personParam = vitroRequest.getParameter("person");
        if (!StringUtils.isEmpty((String)personParam)) {
            Set<String> organizations;
            Set<String> concepts;
            CapabilityMapResponse response = new CapabilityMapResponse();
            CapabilityMapResult result = new CapabilityMapResult();
            this.fillPersonDetails(vitroRequest.getRDFService(), personParam, result);
            if (StringUtils.isEmpty((String)result.firstName) && StringUtils.isEmpty((String)result.lastName)) {
                result.lastName = "Missing Name";
            }
            if ((concepts = conceptPeopleMap.personToConcepts.get(personParam)) != null) {
                result.subjectArea = concepts.toArray(new String[concepts.size()]);
            }
            if ((organizations = organizationPeopleMap.organizationToPeople.get(personParam)) != null) {
                for (String string : organizations) {
                    result.department = organizationLabels.get(string);
                    if (StringUtils.isEmpty((String)result.department)) continue;
                    break;
                }
            }
            response.results.add(result);
            Gson gson = new Gson();
            String string = vitroRequest.getParameter("callback");
            if (!StringUtils.isEmpty((String)string)) {
                return string + "(" + gson.toJson((Object)response) + ");";
            }
            return gson.toJson((Object)response);
        }
        String query = vitroRequest.getParameter("query");
        if (!StringUtils.isEmpty((String)query)) {
            CapabilityMapResponse response = new CapabilityMapResponse();
            Set<String> matchedConcepts = conceptLabelMap.lowerLabelToConcepts.get(query.toLowerCase());
            HashSet<String> people = new HashSet<String>();
            if (matchedConcepts != null) {
                for (String string : matchedConcepts) {
                    Set<String> set = conceptPeopleMap.conceptToPeople.get(string);
                    if (set == null) continue;
                    people.addAll(set);
                }
            }
            HashSet clusterConcepts = new HashSet();
            for (String string : people) {
                if (!conceptPeopleMap.personToConcepts.containsKey(string)) continue;
                clusterConcepts.addAll(conceptPeopleMap.personToConcepts.get(string));
            }
            if (matchedConcepts != null) {
                clusterConcepts.removeAll(matchedConcepts);
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Object clusterConcept : clusterConcepts) {
                String label = conceptLabelMap.conceptToLabel.get(clusterConcept);
                if (StringUtils.isEmpty((String)label)) continue;
                hashSet.add(label);
            }
            String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
            for (String person : people) {
                CapabilityMapResult result = new CapabilityMapResult();
                result.profileId = person;
                result.query = query;
                result.clusters = stringArray;
                response.results.add(result);
            }
            Gson gson = new Gson();
            String callback = vitroRequest.getParameter("callback");
            if (!StringUtils.isEmpty((String)callback)) {
                return callback + "(" + gson.toJson((Object)response) + ");";
            }
            return gson.toJson((Object)response);
        }
        return "";
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        return null;
    }

    private ResponseValues prepareMarkup(VitroRequest vreq) {
        String standaloneTemplate = "capabilityMap.ftl";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("title", "Capability Map");
        body.put("vivoDefaultNamespace", vreq.getWebappDaoFactory().getDefaultNamespace());
        return new TemplateResponseValues(standaloneTemplate, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPersonDetails(RDFService rdfService, final String personUri, final CapabilityMapResult result) {
        try {
            String construct = QueryConstants.getSparqlPrefixQuery() + "CONSTRUCT {\n" + "  <" + personUri + "> a foaf:Person .\n" + "  <" + personUri + "> foaf:lastName ?lastName .\n" + "  <" + personUri + "> foaf:firstName ?firstName .\n" + "  <" + personUri + "> obo:ARG_2000028 ?contactInfo .\n" + "  ?contactInfo vcard:hasName ?contactName .\n" + "  ?contactName vcard:familyName ?familyName .\n" + "  ?contactName vcard:givenName ?givenName .\n" + "  ?contactInfo vcard:hasTitle ?contactTitle .\n" + "  ?contactTitle vcard:title ?contactTitleLabel  .\n" + "  <" + personUri + "> public:thumbnailImage ?directDownloadUrl .\n" + "} WHERE {\n" + "  { \n" + "    <" + personUri + "> foaf:lastName ?lastName .\n" + "  } UNION { \n" + "    <" + personUri + "> foaf:firstName ?firstName .\n" + "  } UNION { \n" + "    <" + personUri + "> obo:ARG_2000028 ?contactInfo .\n" + "    ?contactInfo vcard:hasName ?contactName .\n" + "    ?contactName vcard:familyName ?familyName .\n" + "  } UNION { \n" + "    <" + personUri + "> obo:ARG_2000028 ?contactInfo .\n" + "    ?contactInfo vcard:hasName ?contactName .\n" + "    ?contactName vcard:givenName ?givenName .\n" + "  } UNION { \n" + "    <" + personUri + "> obo:ARG_2000028 ?contactInfo .\n" + "    ?contactInfo vcard:hasTitle ?contactTitle .\n" + "    ?contactTitle vcard:title ?contactTitleLabel .\n" + "  } UNION { \n" + "    <" + personUri + "> public:mainImage ?mainImage .\n" + "    ?mainImage public:thumbnailImage ?thumbnailImage .\n" + "    ?thumbnailImage public:downloadLocation ?downloadLocation .\n" + "    ?downloadLocation public:directDownloadUrl ?directDownloadUrl .\n" + "  } \n" + "}\n";
            Model constructedModel = ModelFactory.createDefaultModel();
            rdfService.sparqlConstructQuery(construct, constructedModel);
            String nameQuery = QueryConstants.getSparqlPrefixQuery() + "SELECT ?familyName ?givenName ?lastName ?firstName ?title ?thumbnailUrl\n" + "WHERE\n" + "{\n" + "  <" + personUri + "> a foaf:Person .\n" + "  OPTIONAL {\n" + "    <" + personUri + ">  obo:ARG_2000028 ?contactInfo .\n" + "    ?contactInfo vcard:hasName ?contactName .\n" + "    OPTIONAL { ?contactName vcard:familyName ?familyName . }\n" + "    OPTIONAL { ?contactName vcard:givenName  ?givenName . }\n" + "  }\n" + "  OPTIONAL {\n" + "    <" + personUri + ">  obo:ARG_2000028 ?contactInfo .\n" + "    ?contactInfo vcard:hasTitle ?contactTitle .\n" + "    ?contactTitle vcard:title ?title .\n" + "  }\n" + "  OPTIONAL { <" + personUri + ">  foaf:lastName ?lastName . }\n" + "  OPTIONAL { <" + personUri + ">  foaf:firstName  ?firstName . }\n" + "  OPTIONAL { <" + personUri + ">  public:thumbnailImage ?thumbnailUrl . }\n" + "}\n";
            try (QueryExecution qe = QueryExecutionFactory.create((String)nameQuery, (Model)constructedModel);){
                new ResultSetConsumer(){

                    protected void processQuerySolution(QuerySolution qs) {
                        Literal firstNameNode;
                        Literal lastNameNode;
                        result.profileId = personUri;
                        result.firstName = null;
                        result.lastName = null;
                        result.thumbNail = null;
                        result.preferredTitle = null;
                        Literal familyNameNode = qs.getLiteral("familyName");
                        result.lastName = familyNameNode != null ? familyNameNode.getString() : ((lastNameNode = qs.getLiteral("lastName")) == null ? null : lastNameNode.getString());
                        Literal givenNameNode = qs.getLiteral("givenName");
                        result.firstName = givenNameNode != null ? givenNameNode.getString() : ((firstNameNode = qs.getLiteral("firstName")) == null ? null : firstNameNode.getString());
                        Literal thumbnailUrlNode = qs.getLiteral("thumbnailUrl");
                        result.thumbNail = thumbnailUrlNode == null ? null : thumbnailUrlNode.getString();
                        Literal titleNode = qs.getLiteral("title");
                        result.preferredTitle = titleNode == null ? null : titleNode.getString();
                    }
                }.processResultSet(qe.execSelect());
            }
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
    }
}

