/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.mapofscience;

import com.google.gson.Gson;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QuerySolution;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.MapOfScienceConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.VisConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.model.OrganizationPeopleMap;
import edu.cornell.mannlib.vitro.webapp.visualization.temporalgraph.OrganizationUtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.OrgUtils;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.VisualizationCaches;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.GenericQueryMap;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.json.MapOfScience;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import mapping.ScienceMapping;
import mapping.ScienceMappingResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class MapOfScienceVisualizationRequestHandler
implements VisualizationRequestHandler {
    private static long timeToGeneratePersonMap = -1L;

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String entityURI = vitroRequest.getParameter("uri");
        return this.generateStandardVisualizationForScienceMapVis(vitroRequest, log, dataset, entityURI);
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        if (vitroRequest.getRequestURI().endsWith("/about")) {
            return this.generateAboutScienceMapVisPage();
        }
        return this.generateStandardVisualizationForScienceMapVis(vitroRequest, log, dataset, parameters.get("uri"));
    }

    private ResponseValues generateAboutScienceMapVisPage() {
        return new TemplateResponseValues("aboutMapOfScience.ftl");
    }

    private ResponseValues generateStandardVisualizationForScienceMapVis(VitroRequest vitroRequest, Log log, Dataset dataset, String entityURI) throws MalformedQueryParametersException {
        if (StringUtils.isBlank((String)entityURI)) {
            entityURI = OrganizationUtilityFunctions.getStaffProvidedOrComputedHighestLevelOrganization(log, dataset, vitroRequest);
        }
        return this.prepareStandaloneMarkupResponse(vitroRequest, entityURI);
    }

    private Set<String> getPublicationsForPerson(RDFService rdfService, String personUri) {
        if (MapOfScienceVisualizationRequestHandler.preferCachesForPersonMap() && VisualizationCaches.personToPublication.isCached()) {
            Map<String, Set<String>> personToPublicationMap = VisualizationCaches.personToPublication.get((RDFService)rdfService).personToPublication;
            return personToPublicationMap.get(personUri);
        }
        final HashSet<String> queryResults = new HashSet<String>();
        String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?document\n" + "WHERE\n" + "{\n" + "  <" + personUri + "> core:relatedBy ?authorship .\n" + "  ?authorship a core:Authorship .\n" + "  ?authorship core:relates ?document .\n" + "  ?document a bibo:Document .\n" + "}\n";
        try {
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    queryResults.add(qs.getResource("document").getURI());
                }
            });
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        return queryResults;
    }

    private Map<String, String> getJournalsForPerson(RDFService rdfService, String personUri) {
        if (MapOfScienceVisualizationRequestHandler.preferCachesForPersonMap() && VisualizationCaches.publicationToJournal.isCached()) {
            return VisualizationCaches.publicationToJournal.get(rdfService);
        }
        final HashMap<String, String> queryResults = new HashMap<String, String>();
        String query = QueryConstants.getSparqlPrefixQuery() + "SELECT ?document ?journalLabel\n" + "WHERE\n" + "{\n" + "  <" + personUri + "> core:relatedBy ?authorship .\n" + "  ?authorship a core:Authorship .\n" + "  ?authorship core:relates ?document .\n" + "  ?document a bibo:Document .\n" + "  ?document core:hasPublicationVenue ?journal . \n" + "  ?journal rdfs:label ?journalLabel . \n" + "}\n";
        try {
            rdfService.sparqlSelectQuery(query, new ResultSetConsumer(){

                protected void processQuerySolution(QuerySolution qs) {
                    queryResults.put(qs.getResource("document").getURI(), qs.getLiteral("journalLabel").getString());
                }
            });
        }
        catch (RDFServiceException rDFServiceException) {
            // empty catch block
        }
        return queryResults;
    }

    private static boolean preferCachesForPersonMap() {
        return timeToGeneratePersonMap > 2000L;
    }

    private static synchronized void recordExecutionTimeForPersonMap(long time) {
        timeToGeneratePersonMap = Math.max(timeToGeneratePersonMap, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getSubjectPersonEntityAndGenerateDataResponse(VitroRequest vitroRequest, String subjectEntityURI, String entityLabel, VisConstants.DataVisMode dataOuputFormat) throws MalformedQueryParametersException {
        long startTime = System.currentTimeMillis();
        try {
            RDFService rdfService = vitroRequest.getRDFService();
            Set<String> publicationsForPerson = this.getPublicationsForPerson(rdfService, subjectEntityURI);
            if (publicationsForPerson == null || publicationsForPerson.size() == 0) {
                if (VisConstants.DataVisMode.JSON.equals((Object)dataOuputFormat)) {
                    Map<String, String> map = this.prepareStandaloneDataErrorResponse();
                    return map;
                }
                Map<String, String> map = this.prepareDataErrorResponse();
                return map;
            }
            Map<String, String> publicationToJournalMap = this.getJournalsForPerson(rdfService, subjectEntityURI);
            JournalPublicationCounts journalCounts = new JournalPublicationCounts();
            for (String publication : publicationsForPerson) {
                journalCounts.increment(publicationToJournalMap.get(publication));
            }
            ScienceMappingResult result = this.getScienceMappingResult(journalCounts.map);
            HashMap<String, String> fileData = new HashMap<String, String>();
            if (VisConstants.DataVisMode.JSON.equals((Object)dataOuputFormat)) {
                Gson json = new Gson();
                HashSet<MapOfScience> jsonContent = new HashSet<MapOfScience>();
                MapOfScience entityJson = new MapOfScience(subjectEntityURI);
                entityJson.setLabel("");
                entityJson.setType("PERSON");
                entityJson.setPubsWithNoJournals(journalCounts.noJournalCount);
                this.updateEntityMapOfScienceInformation(entityJson, result);
                jsonContent.add(entityJson);
                fileData.put("fileContentType", "application/octet-stream");
                fileData.put("fileContent", json.toJson(jsonContent));
            } else {
                if (StringUtils.isBlank((String)entityLabel)) {
                    entityLabel = "no-name";
                }
                String outputFileName = UtilityFunctions.slugify(entityLabel);
                String fileContent = null;
                String visModeKey = vitroRequest.getParameter("vis_mode");
                if ("subdiscipline".equalsIgnoreCase(visModeKey)) {
                    outputFileName = outputFileName + "_subdiscipline-to-publications.csv";
                    fileContent = this.getSubDisciplineToPublicationsCSVContent(result);
                } else if ("unlocated_journals".equalsIgnoreCase(visModeKey)) {
                    outputFileName = outputFileName + "_unmapped-journals.csv";
                    fileContent = this.getUnlocatedJournalsCSVContent(result, journalCounts.noJournalCount);
                } else {
                    outputFileName = outputFileName + "_discipline-to-publications.csv";
                    fileContent = this.getDisciplineToPublicationsCSVContent(result);
                }
                fileData.put("fileContentType", "application/octet-stream");
                fileData.put("fileName", outputFileName);
                fileData.put("fileContent", fileContent);
            }
            HashMap<String, String> hashMap = fileData;
            return hashMap;
        }
        finally {
            MapOfScienceVisualizationRequestHandler.recordExecutionTimeForPersonMap(System.currentTimeMillis() - startTime);
        }
    }

    private Map<String, String> getSubjectEntityAndGenerateDataResponse(VitroRequest vitroRequest, String subjectEntityURI, String entityLabel, VisConstants.DataVisMode dataOuputFormat) throws MalformedQueryParametersException {
        RDFService rdfService = vitroRequest.getRDFService();
        Map<String, String> orgLabelMap = VisualizationCaches.organizationLabels.get(rdfService);
        if (orgLabelMap.get(subjectEntityURI) == null) {
            if (VisConstants.DataVisMode.JSON.equals((Object)dataOuputFormat)) {
                return this.prepareStandaloneDataErrorResponse();
            }
            return this.prepareDataErrorResponse();
        }
        Map<String, Set<String>> subOrgMap = VisualizationCaches.organizationSubOrgs.get(rdfService);
        OrganizationPeopleMap organisationToPeopleMap = VisualizationCaches.organisationToPeopleMap.get(rdfService);
        Map<String, Set<String>> personToPublicationMap = VisualizationCaches.personToPublication.get((RDFService)rdfService).personToPublication;
        Map<String, String> publicationToJournalMap = VisualizationCaches.publicationToJournal.get(rdfService);
        HashSet<String> orgPublications = new HashSet<String>();
        HashSet<String> orgPublicationsPeople = new HashSet<String>();
        HashMap<String, Set<String>> subOrgPublicationsMap = new HashMap<String, Set<String>>();
        OrgUtils.getObjectMappingsForOrgAndSubOrgs(subjectEntityURI, orgPublications, orgPublicationsPeople, subOrgPublicationsMap, subOrgMap, organisationToPeopleMap.organizationToPeople, personToPublicationMap);
        if (orgPublications.isEmpty()) {
            if (VisConstants.DataVisMode.JSON.equals((Object)dataOuputFormat)) {
                return this.prepareStandaloneDataErrorResponse();
            }
            return this.prepareDataErrorResponse();
        }
        JournalPublicationCounts journalCounts = new JournalPublicationCounts();
        for (String publication : orgPublications) {
            journalCounts.increment(publicationToJournalMap.get(publication));
        }
        ScienceMappingResult result = this.getScienceMappingResult(journalCounts.map);
        HashMap<String, String> fileData = new HashMap<String, String>();
        if (VisConstants.DataVisMode.JSON.equals((Object)dataOuputFormat)) {
            Gson json = new Gson();
            HashSet<MapOfScience> jsonContent = new HashSet<MapOfScience>();
            MapOfScience entityJson = new MapOfScience(subjectEntityURI);
            entityJson.setLabel(entityLabel);
            entityJson.setType("ORGANIZATION");
            if (subOrgMap.containsKey(subjectEntityURI)) {
                Iterator<String> iterator = subOrgMap.get(subjectEntityURI).iterator();
                while (iterator.hasNext()) {
                    Set publications;
                    String subOrg;
                    entityJson.addSubEntity(subOrg, orgLabelMap.get(subOrg), "ORGANIZATION", (publications = (Set)subOrgPublicationsMap.get(subOrg = iterator.next())) == null ? 0 : publications.size());
                }
            }
            entityJson.setPubsWithNoJournals(journalCounts.noJournalCount);
            this.updateEntityMapOfScienceInformation(entityJson, result);
            jsonContent.add(entityJson);
            fileData.put("fileContentType", "application/octet-stream");
            fileData.put("fileContent", json.toJson(jsonContent));
        } else {
            if (StringUtils.isBlank((String)entityLabel)) {
                entityLabel = "no-organization";
            }
            String outputFileName = UtilityFunctions.slugify(entityLabel);
            String fileContent = null;
            String visModeKey = vitroRequest.getParameter("vis_mode");
            if ("subdiscipline".equalsIgnoreCase(visModeKey)) {
                outputFileName = outputFileName + "_subdiscipline-to-publications.csv";
                fileContent = this.getSubDisciplineToPublicationsCSVContent(result);
            } else if ("unlocated_journals".equalsIgnoreCase(visModeKey)) {
                outputFileName = outputFileName + "_unmapped-journals.csv";
                fileContent = this.getUnlocatedJournalsCSVContent(result, journalCounts.noJournalCount);
            } else {
                outputFileName = outputFileName + "_discipline-to-publications.csv";
                fileContent = this.getDisciplineToPublicationsCSVContent(result);
            }
            fileData.put("fileContentType", "application/octet-stream");
            fileData.put("fileName", outputFileName);
            fileData.put("fileContent", fileContent);
        }
        return fileData;
    }

    private Map<String, String> prepareDataErrorResponse() {
        String outputFileName = "no-organization_publications-per-year.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", "");
        return fileData;
    }

    private Map<String, String> prepareStandaloneDataErrorResponse() {
        GenericQueryMap errorDataResponse = new GenericQueryMap();
        errorDataResponse.addEntry("error", "No Publications for this Entity found in VIVO.");
        Gson jsonErrorResponse = new Gson();
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", jsonErrorResponse.toJson((Object)errorDataResponse));
        return fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String entityURI = vitroRequest.getParameter("uri");
        if (StringUtils.isBlank((String)entityURI)) {
            entityURI = OrganizationUtilityFunctions.getStaffProvidedOrComputedHighestLevelOrganization(log, dataset, vitroRequest);
        }
        VisConstants.DataVisMode currentDataVisMode = VisConstants.DataVisMode.CSV;
        if ("json".equalsIgnoreCase(vitroRequest.getParameter("output"))) {
            currentDataVisMode = VisConstants.DataVisMode.JSON;
        }
        Individual individual = vitroRequest.getWebappDaoFactory().getIndividualDao().getIndividualByURI(entityURI);
        try {
            if (individual != null && individual.isVClass("http://xmlns.com/foaf/0.1/Person")) {
                Map<String, String> map = this.getSubjectPersonEntityAndGenerateDataResponse(vitroRequest, entityURI, individual != null ? individual.getDataValue("http://www.w3.org/2000/01/rdf-schema#label") : "", currentDataVisMode);
                return map;
            }
            Map<String, String> map = this.getSubjectEntityAndGenerateDataResponse(vitroRequest, entityURI, individual != null ? individual.getDataValue("http://www.w3.org/2000/01/rdf-schema#label") : "", currentDataVisMode);
            return map;
        }
        finally {
            VisualizationCaches.buildMissing();
        }
    }

    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Map of Science Vis does not provide Ajax Response.");
    }

    private TemplateResponseValues prepareStandaloneMarkupResponse(VitroRequest vreq, String entityURI) throws MalformedQueryParametersException {
        String key;
        String standaloneTemplate = "mapOfScienceStandalone.ftl";
        String entityLabel = UtilityFunctions.getIndividualLabelFromDAO(vreq, entityURI);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("title", entityLabel + " - Map of Science Visualization");
        body.put("entityURI", entityURI);
        body.put("entityLocalName", UtilityFunctions.getIndividualLocalName(entityURI, vreq));
        body.put("entityLabel", entityLabel);
        if (UtilityFunctions.isEntityAPerson(vreq, entityURI)) {
            body.put("entityType", "PERSON");
            if (MapOfScienceVisualizationRequestHandler.preferCachesForPersonMap() && VisualizationCaches.personToPublication.isCached()) {
                body.put("builtFromCacheTime", VisualizationCaches.personToPublication.cachedWhen());
            }
        } else {
            body.put("entityType", "ORGANIZATION");
            if (VisualizationCaches.personToPublication.isCached()) {
                body.put("builtFromCacheTime", VisualizationCaches.personToPublication.cachedWhen());
            }
        }
        body.put("vivoDefaultNamespace", vreq.getWebappDaoFactory().getDefaultNamespace());
        ConfigurationProperties properties = ConfigurationProperties.getBean((ServletRequest)vreq);
        if (properties != null && !StringUtils.isEmpty((String)(key = properties.getProperty("google.maps.key")))) {
            body.put("googleMapsKey", key);
        }
        return new TemplateResponseValues(standaloneTemplate, body);
    }

    private void updateEntityMapOfScienceInformation(MapOfScience entityJson, ScienceMappingResult result) {
        int mappedPublicationCount = 0;
        int publicationsWithInvalidJournalCount = 0;
        HashMap<Integer, Float> subdisciplineToActivity = new HashMap();
        if (result != null) {
            subdisciplineToActivity = result.getMappedResult();
            publicationsWithInvalidJournalCount = Math.round(result.getUnMappedPublications().floatValue());
            mappedPublicationCount = Math.round(result.getMappedPublications().floatValue());
        }
        entityJson.setPubsMapped(mappedPublicationCount);
        entityJson.setPubsWithInvalidJournals(publicationsWithInvalidJournalCount);
        entityJson.setSubdisciplineActivity(subdisciplineToActivity);
    }

    private ScienceMappingResult getScienceMappingResult(Map<String, Integer> journalToPublicationCount) {
        ScienceMappingResult result = null;
        try {
            result = new ScienceMapping().generateScienceMappingResult(journalToPublicationCount);
        }
        catch (NumberFormatException e) {
            System.err.println("NumberFormatException coming from Map Of Science Vis");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IOException coming from Map Of Science Vis");
            e.printStackTrace();
        }
        return result;
    }

    private String getDisciplineToPublicationsCSVContent(ScienceMappingResult result) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Discipline, Publication Count, % Activity\n");
        HashMap<Integer, Float> disciplineToPublicationCount = new HashMap<Integer, Float>();
        Float totalMappedPublications = new Float(0.0f);
        if (result != null) {
            for (Map.Entry currentMappedSubdiscipline : result.getMappedResult().entrySet()) {
                float f = ((Float)currentMappedSubdiscipline.getValue()).floatValue();
                Integer lookedUpDisciplineID = MapOfScienceConstants.SUB_DISCIPLINE_ID_TO_DISCIPLINE_ID.get(currentMappedSubdiscipline.getKey());
                if (disciplineToPublicationCount.containsKey(lookedUpDisciplineID)) {
                    f += ((Float)disciplineToPublicationCount.get(lookedUpDisciplineID)).floatValue();
                }
                disciplineToPublicationCount.put(lookedUpDisciplineID, Float.valueOf(f));
            }
            totalMappedPublications = result.getMappedPublications();
        }
        DecimalFormat percentageActivityFormat = new DecimalFormat("#.#");
        for (Map.Entry entry : disciplineToPublicationCount.entrySet()) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)MapOfScienceConstants.DISCIPLINE_ID_TO_LABEL.get(entry.getKey())));
            csvFileContent.append(", ");
            csvFileContent.append(percentageActivityFormat.format(entry.getValue()));
            csvFileContent.append(", ");
            if (totalMappedPublications.floatValue() > 0.0f) {
                csvFileContent.append(percentageActivityFormat.format(100.0f * ((Float)entry.getValue()).floatValue() / totalMappedPublications.floatValue()));
            } else {
                csvFileContent.append("Not Available");
            }
            csvFileContent.append("\n");
        }
        for (Map.Entry<Object, Object> entry : MapOfScienceConstants.DISCIPLINE_ID_TO_LABEL.entrySet()) {
            Float currentDisciplineValue = (Float)disciplineToPublicationCount.get(entry.getKey());
            if (currentDisciplineValue != null) continue;
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)((String)entry.getValue())));
            csvFileContent.append(", ");
            csvFileContent.append(0);
            csvFileContent.append(", ");
            csvFileContent.append(0);
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private String getUnlocatedJournalsCSVContent(ScienceMappingResult result, int noJournalCount) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Publication Venue, Publication Count\n");
        DecimalFormat percentageActivityFormat = new DecimalFormat("#.#");
        if (noJournalCount > 0) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)"No Publication Venue Given"));
            csvFileContent.append(", ");
            csvFileContent.append(percentageActivityFormat.format(noJournalCount));
            csvFileContent.append("\n");
        }
        if (result != null) {
            Map mappedResult = result.getUnmappedResult();
            for (Map.Entry currentUnMappedJournal : mappedResult.entrySet()) {
                csvFileContent.append(StringEscapeUtils.escapeCsv((String)((String)currentUnMappedJournal.getKey())));
                csvFileContent.append(", ");
                csvFileContent.append(percentageActivityFormat.format(currentUnMappedJournal.getValue()));
                csvFileContent.append("\n");
            }
        }
        return csvFileContent.toString();
    }

    private String getSubDisciplineToPublicationsCSVContent(ScienceMappingResult result) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Sub-Discipline, Publication Count, % Activity\n");
        Float totalMappedPublications = new Float(0.0f);
        if (result != null) {
            DecimalFormat percentageActivityFormat = new DecimalFormat("#.#");
            totalMappedPublications = result.getMappedPublications();
            Map mappedResult = result.getMappedResult();
            for (Map.Entry entry : mappedResult.entrySet()) {
                csvFileContent.append(StringEscapeUtils.escapeCsv((String)MapOfScienceConstants.SUB_DISCIPLINE_ID_TO_LABEL.get(entry.getKey())));
                csvFileContent.append(", ");
                csvFileContent.append(percentageActivityFormat.format(entry.getValue()));
                csvFileContent.append(", ");
                if (totalMappedPublications.floatValue() > 0.0f) {
                    csvFileContent.append(percentageActivityFormat.format(100.0f * ((Float)entry.getValue()).floatValue() / totalMappedPublications.floatValue()));
                } else {
                    csvFileContent.append("Not Available");
                }
                csvFileContent.append("\n");
            }
            for (Map.Entry<Object, Object> entry : MapOfScienceConstants.SUB_DISCIPLINE_ID_TO_LABEL.entrySet()) {
                Float currentMappedSubdisciplineValue = (Float)mappedResult.get(entry.getKey());
                if (currentMappedSubdisciplineValue != null) continue;
                csvFileContent.append(StringEscapeUtils.escapeCsv((String)((String)entry.getValue())));
                csvFileContent.append(", ");
                csvFileContent.append(0);
                csvFileContent.append(", ");
                csvFileContent.append(0);
                csvFileContent.append("\n");
            }
        }
        return csvFileContent.toString();
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }

    private static class JournalPublicationCounts {
        Map<String, Integer> map = new HashMap<String, Integer>();
        int noJournalCount = 0;
        int total = 0;

        private JournalPublicationCounts() {
        }

        void increment(String journalName) {
            if (StringUtils.isEmpty((String)journalName)) {
                ++this.noJournalCount;
            } else {
                Integer count = this.map.get(journalName);
                if (count == null) {
                    this.map.put(journalName, 1);
                } else {
                    this.map.put(journalName, 1 + count);
                }
            }
            ++this.total;
        }

        boolean isEmpty() {
            return this.total == 0;
        }

        long getTotal() {
            return this.total;
        }
    }
}

