/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.actions.ApiAction;
import edu.cornell.mannlib.vedit.beans.LoginStatusBean;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.IdentifierBundle;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.RequestIdentifiers;
import edu.cornell.mannlib.vitro.webapp.auth.identifier.common.HasProfile;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.UserAccount;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.NotAuthorizedResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidDefaultHandler
extends OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidDefaultHandler.class);
    private Individual individual;
    private final Set<String> existingOrcids = new HashSet<String>();

    public OrcidDefaultHandler(VitroRequest vreq) {
        super(vreq);
    }

    public ResponseValues exec() {
        try {
            this.initializeState();
            this.initializeAuthorizationCache();
        }
        catch (Exception e) {
            log.error((Object)"No proper individual URI on the request", (Throwable)e);
            return this.show400BadRequest(e);
        }
        if (!this.isAuthorized()) {
            return this.showNotAuthorized();
        }
        return this.showConfirmationPage();
    }

    private void initializeState() {
        String uri = this.vreq.getParameter("individualUri");
        if (uri == null) {
            throw new IllegalStateException("No 'individualUri' parameter on request.");
        }
        String profilePage = UrlBuilder.getIndividualProfileUrl((String)uri, (VitroRequest)this.vreq);
        this.state.reset(uri, profilePage);
        this.individual = this.findIndividual();
        this.locateExistingOrcids();
        this.state.setExistingOrcids(this.existingOrcids);
    }

    private void locateExistingOrcids() {
        if (this.individual == null) {
            return;
        }
        List opss = this.individual.getObjectPropertyStatements("http://vivoweb.org/ontology/core#orcidId");
        if (opss == null) {
            return;
        }
        for (ObjectPropertyStatement ops : opss) {
            this.existingOrcids.add(ops.getObjectURI());
        }
    }

    private void initializeAuthorizationCache() {
        this.auth.clearStatus(ApiAction.READ_PROFILE);
        this.auth.clearStatus(ApiAction.ADD_EXTERNAL_ID);
    }

    private ResponseValues show400BadRequest(Exception e) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", "400 Bad Request");
        map.put("errorMessage", e.getMessage());
        return new TemplateResponseValues("error-titled.ftl", map, 400);
    }

    private boolean isAuthorized() {
        IdentifierBundle ids = RequestIdentifiers.getIdBundleForRequest((ServletRequest)this.vreq);
        Collection profileUris = HasProfile.getProfileUris((IdentifierBundle)ids);
        log.debug((Object)("Authorized? individualUri=" + this.state.getIndividualUri() + ", profileUris=" + profileUris));
        return profileUris.contains(this.state.getIndividualUri());
    }

    private ResponseValues showNotAuthorized() {
        UserAccount user = LoginStatusBean.getCurrentUser((HttpServletRequest)this.vreq);
        String userName = user == null ? "ANONYMOUS" : user.getEmailAddress();
        return new NotAuthorizedResponseValues(userName + "is not authorized for ORCID operations on '" + this.individual + "'");
    }
}

