/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.ajax;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.ajax.AbstractAjaxResponder;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;

public class GeoFocusResearcherCount
extends AbstractAjaxResponder {
    private static final Log log = LogFactory.getLog((String)GeoFocusResearcherCount.class.getName());
    private List<Map<String, String>> geoFocusCount;
    private static String GEO_FOCUS_COUNT_QUERY = "PREFIX core: <http://vivoweb.org/ontology/core#>  \nPREFIX foaf: <http://xmlns.com/foaf/0.1/>  \nSELECT DISTINCT (COUNT(DISTINCT ?person) AS ?count)  \nWHERE {  \n    ?person a foaf:Person .  \n    ?person core:geographicFocus ?focus   \n}";

    public GeoFocusResearcherCount(HttpServlet parent, VitroRequest vreq, HttpServletResponse resp) {
        super(parent, vreq, resp);
    }

    public String prepareResponse() throws IOException, JSONException {
        try {
            this.geoFocusCount = this.getGeoFocusCount(this.vreq);
            String response = "{ ";
            for (Map<String, String> map : this.geoFocusCount) {
                String theCount = map.get("count");
                response = response + "\"count\": \"" + theCount + "\"";
            }
            response = response + " }";
            log.debug((Object)response);
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Failed geographic focus count", (Throwable)e);
            return "[]";
        }
    }

    private List<Map<String, String>> getGeoFocusCount(VitroRequest vreq) {
        String queryStr = GEO_FOCUS_COUNT_QUERY;
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Map<String, String>> count = new ArrayList<Map<String, String>>();
        try {
            ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                count.add(QueryUtils.querySolutionToStringValueMap((QuerySolution)soln));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return count;
    }
}

