/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.freemarker;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.BaseSiteAdminController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.InstitutionalInternalClassController;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.visualization.tools.ToolsRequestHandler;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VIVOSiteAdminController
extends BaseSiteAdminController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(VIVOSiteAdminController.class);

    protected Map<String, Object> getSiteMaintenanceUrls(VitroRequest vreq) {
        Map urls = super.getSiteMaintenanceUrls(vreq);
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest[])new AuthorizationRequest[]{ToolsRequestHandler.REQUIRED_ACTIONS})) {
            urls.put("rebuildVisCache", UrlBuilder.getUrl((String)"/vis/tools"));
        }
        return urls;
    }

    protected Map<String, Object> getSiteConfigData(VitroRequest vreq) {
        Map data = super.getSiteConfigData(vreq);
        if (PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest[])new AuthorizationRequest[]{InstitutionalInternalClassController.REQUIRED_ACTIONS})) {
            data.put("internalClass", UrlBuilder.getUrl((String)"/processInstitutionalInternalClass"));
        }
        return data;
    }
}

