/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.harvester;

import edu.cornell.mannlib.vitro.webapp.application.ApplicationUtils;
import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.FreemarkerHttpServlet;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ExceptionResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.TemplateResponseValues;
import edu.cornell.mannlib.vitro.webapp.controller.harvester.CsvFileHarvestJob;
import edu.cornell.mannlib.vitro.webapp.controller.harvester.FileHarvestJob;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileHarvestController
extends FreemarkerHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FileHarvestController.class);
    private static final String TEMPLATE_DEFAULT = "fileharvest.ftl";
    private static final String NORMAL_TERMINATION_LAST_OUTPUT = "File Harvest completed successfully";
    private static final String PARAMETER_FIRST_UPLOAD = "firstUpload";
    private static final String PARAMETER_UPLOADED_FILE = "uploadedFile";
    private static final String PARAMETER_MODE = "mode";
    private static final String PARAMETER_JOB = "job";
    private static final String POST_TO = UrlBuilder.getUrl((String)"/harvester/harvest");
    private static final String MODE_HARVEST = "harvest";
    private static final String MODE_CHECK_STATUS = "checkStatus";
    private static final String MODE_DOWNLOAD_TEMPLATE = "template";
    private Map<String, SessionInfo> sessionIdToSessionInfo = new Hashtable<String, SessionInfo>();
    private static final List<String> knownJobs = new ArrayList<String>();
    private static final String PATH_TO_UPLOADS = "harvester/";
    private static final String PATH_TO_FILE_HARVEST_ROOT = "vivo/";
    public static final String PATH_TO_TEMPLATE_FILES = "vivo/templates/";
    public static final String PATH_TO_HARVESTER_SCRIPTS = "vivo/scripts/";
    public static final String PATH_TO_HARVESTED_DATA = "vivo/harvested-data/";

    private static void fillKnownJobTypesList() {
        CsvFileHarvestJob.JobType[] csvFileHarvestJobTypes;
        for (CsvFileHarvestJob.JobType csvFileHarvestJobType : csvFileHarvestJobTypes = CsvFileHarvestJob.JobType.values()) {
            knownJobs.add(csvFileHarvestJobType.httpParameterName.toLowerCase());
        }
    }

    public long maximumMultipartFileSize() {
        return 0x100000L;
    }

    public boolean stashFileSizeException() {
        return true;
    }

    protected ResponseValues processRequest(VitroRequest vreq) {
        try {
            this.cleanUpOldSessions();
            String job = vreq.getParameter(PARAMETER_JOB);
            String jobKnown = "false";
            if (job != null && knownJobs.contains(job.toLowerCase())) {
                jobKnown = "true";
            }
            FileHarvestJob jobObject = this.getJob(vreq, job);
            HashMap<String, String> body = new HashMap<String, String>();
            String harvesterPath = FileHarvestController.getHarvesterPath((HttpServletRequest)vreq);
            body.put("paramFirstUpload", PARAMETER_FIRST_UPLOAD);
            body.put("paramUploadedFile", PARAMETER_UPLOADED_FILE);
            body.put("paramMode", PARAMETER_MODE);
            body.put("paramJob", PARAMETER_JOB);
            body.put("modeHarvest", MODE_HARVEST);
            body.put("modeCheckStatus", MODE_CHECK_STATUS);
            body.put("modeDownloadTemplate", MODE_DOWNLOAD_TEMPLATE);
            body.put(PARAMETER_JOB, job);
            body.put("jobKnown", jobKnown);
            body.put("harvesterLocation", harvesterPath);
            body.put("postTo", POST_TO + "?" + PARAMETER_JOB + "=" + job);
            body.put("jobSpecificHeader", jobObject != null ? jobObject.getPageHeader() : "");
            body.put("jobSpecificLinkHeader", jobObject != null ? jobObject.getLinkHeader() : "");
            body.put("jobSpecificDownloadHelp", jobObject != null ? jobObject.getTemplateDownloadHelp() : "");
            body.put("jobSpecificFillInHelp", jobObject != null ? jobObject.getTemplateFillInHelp() : "");
            body.put("jobSpecificNoNewDataMessage", jobObject != null ? jobObject.getNoNewDataMessage() : "");
            return new TemplateResponseValues(TEMPLATE_DEFAULT, body);
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            return new ExceptionResponseValues(e);
        }
    }

    protected String getTitle(String siteName, VitroRequest vreq) {
        return "VIVO Harvester Test";
    }

    public static String getHarvesterPath(HttpServletRequest req) {
        String pathToHarvester = ConfigurationProperties.getBean((ServletRequest)req).getProperty("harvester.location");
        if (pathToHarvester == null) {
            log.error((Object)"The runtime.properties file does not contain a value for 'harvester.location'");
            return "";
        }
        return pathToHarvester;
    }

    public static String getFileHarvestRootPath(HttpServletRequest req) {
        String fileHarvestRootPath = FileHarvestController.getHarvesterPath(req) + PATH_TO_FILE_HARVEST_ROOT;
        return fileHarvestRootPath;
    }

    private static String getUploadPathBase(ServletContext context) throws Exception {
        String vitroHomeDirectoryName = ApplicationUtils.instance().getHomeDirectory().getPath().toString();
        return vitroHomeDirectoryName + "/" + "uploads" + "/" + PATH_TO_UPLOADS;
    }

    private FileHarvestJob getJob(VitroRequest vreq, String jobParameter) {
        String namespace = vreq.getWebappDaoFactory().getDefaultNamespace();
        CsvFileHarvestJob job = null;
        if (jobParameter == null) {
            log.error((Object)"No job specified.");
        } else if (CsvFileHarvestJob.JobType.containsTypeWithHttpParameterName(jobParameter)) {
            job = CsvFileHarvestJob.createJob(CsvFileHarvestJob.JobType.getByHttpParameterName(jobParameter), vreq, namespace);
        } else {
            log.error((Object)("Invalid job: " + jobParameter));
        }
        return job;
    }

    public static String getUploadPath(VitroRequest vreq) {
        try {
            String path = FileHarvestController.getUploadPathBase(vreq.getSession().getServletContext()) + FileHarvestController.getSessionId((HttpServletRequest)vreq) + "/";
            return path;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            try {
                boolean isMultipart = new VitroRequest(request).isMultipart();
                String mode = request.getParameter(PARAMETER_MODE);
                if (isMultipart) {
                    this.doFileUploadPost(request, response);
                    break block6;
                }
                if (mode.equals(MODE_HARVEST)) {
                    this.doHarvestPost(request, response);
                    break block6;
                }
                if (mode.equals(MODE_CHECK_STATUS)) {
                    this.doCheckHarvestStatusPost(request, response);
                    break block6;
                }
                if (mode.equals(MODE_DOWNLOAD_TEMPLATE)) {
                    this.doDownloadTemplatePost(request, response);
                    break block6;
                }
                throw new Exception("Unrecognized post mode: " + mode);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFileUploadPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JSONObject json;
        block20: {
            json = this.generateJson(false);
            try {
                VitroRequest vreq = new VitroRequest(request);
                if (vreq.hasFileSizeException()) {
                    FileUploadException e = vreq.getFileSizeException();
                    throw new ExceptionVisibleToUser((Throwable)e);
                }
                String jobParameter = vreq.getParameter(PARAMETER_JOB);
                String path = FileHarvestController.getUploadPath(vreq);
                File directory = new File(path);
                String firstUpload = vreq.getParameter(PARAMETER_FIRST_UPLOAD);
                if (firstUpload.toLowerCase().equals("true") && directory.exists()) {
                    File[] children;
                    for (File child : children = directory.listFiles()) {
                        child.delete();
                    }
                }
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                FileHarvestJob job = this.getJob(vreq, jobParameter);
                Map fileStreams = vreq.getFiles();
                if (fileStreams.get(PARAMETER_UPLOADED_FILE) != null && ((List)fileStreams.get(PARAMETER_UPLOADED_FILE)).size() > 0) {
                    boolean success;
                    FileItem csvStream = (FileItem)((List)fileStreams.get(PARAMETER_UPLOADED_FILE)).get(0);
                    String name = csvStream.getName();
                    name = this.handleNameCollision(name, directory);
                    File file = new File(path + name);
                    try {
                        csvStream.write(file);
                    }
                    finally {
                        csvStream.delete();
                    }
                    String errorMessage = job.validateUpload(file);
                    if (errorMessage != null) {
                        success = false;
                        file.delete();
                    } else {
                        success = true;
                        errorMessage = "success";
                    }
                    try {
                        json.put("success", success);
                        json.put("fileName", (Object)name);
                        json.put("errorMessage", (Object)errorMessage);
                        break block20;
                    }
                    catch (JSONException e) {
                        log.error((Object)e, (Throwable)e);
                        return;
                    }
                }
                try {
                    json.put("success", false);
                    json.put("fileName", (Object)"(none)");
                    json.put("errorMessage", (Object)"No file uploaded");
                }
                catch (JSONException e) {
                    log.error((Object)e, (Throwable)e);
                    return;
                }
            }
            catch (ExceptionVisibleToUser e) {
                log.error((Object)e, (Throwable)e);
                try {
                    json.put("success", false);
                    json.put("filename", (Object)"(none)");
                    json.put("errorMessage", (Object)e.getMessage());
                }
                catch (JSONException f) {
                    log.error((Object)f, (Throwable)f);
                    return;
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                json = this.generateJson(true);
            }
        }
        response.getWriter().write(json.toString());
    }

    private void doHarvestPost(HttpServletRequest request, HttpServletResponse response) {
        JSONObject json;
        try {
            VitroRequest vreq = new VitroRequest(request);
            FileHarvestJob job = this.getJob(vreq, vreq.getParameter(PARAMETER_JOB));
            String script = job.getScript();
            String additionsFilePath = job.getAdditionsFilePath();
            String scriptFileLocation = FileHarvestController.getScriptFileLocation((HttpServletRequest)vreq);
            this.runScript(FileHarvestController.getSessionId(request), script, additionsFilePath, scriptFileLocation, job);
            json = this.generateJson(false);
            json.put("progressSinceLastCheck", (Object)"");
            json.put("scriptText", (Object)script);
            json.put("finished", false);
        }
        catch (Exception e) {
            json = this.generateJson(true);
            log.error((Object)e, (Throwable)e);
        }
        try {
            response.getWriter().write(json.toString());
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckHarvestStatusPost(HttpServletRequest request, HttpServletResponse response) {
        JSONObject json;
        block15: {
            try {
                String newline = "\n";
                String sessionId = FileHarvestController.getSessionId(request);
                SessionInfo sessionInfo = this.sessionIdToSessionInfo.get(sessionId);
                if (sessionInfo != null) {
                    String[] unsentLogLines;
                    ArrayList<String> unsentLogLinesList;
                    ArrayList<String> arrayList = unsentLogLinesList = sessionInfo.unsentLogLines;
                    synchronized (arrayList) {
                        unsentLogLines = unsentLogLinesList.toArray(new String[unsentLogLinesList.size()]);
                        unsentLogLinesList.clear();
                    }
                    String progressSinceLastCheck = "";
                    for (int i = 0; i < unsentLogLines.length; ++i) {
                        progressSinceLastCheck = progressSinceLastCheck + unsentLogLines[i] + newline;
                    }
                    boolean finished = sessionInfo.isFinished();
                    boolean abnormalTermination = false;
                    VitroRequest vreq = new VitroRequest(request);
                    ArrayList<String> newlyAddedUrls = new ArrayList<String>();
                    ArrayList<Object> newlyAddedUris = new ArrayList();
                    if (finished) {
                        newlyAddedUris = sessionInfo.newlyAddedUris;
                        if (newlyAddedUris != null) {
                            for (String string : newlyAddedUris) {
                                newlyAddedUrls.add(UrlBuilder.getIndividualProfileUrl((String)string, (VitroRequest)vreq));
                            }
                        }
                        this.clearSessionInfo(sessionId);
                        if (sessionInfo.getAbnormalTermination()) {
                            abnormalTermination = true;
                        }
                    }
                    if (!abnormalTermination) {
                        json = this.generateJson(false);
                        json.put("progressSinceLastCheck", (Object)progressSinceLastCheck);
                        json.put("finished", finished);
                        json.put("newlyAddedUris", newlyAddedUris);
                        json.put("newlyAddedUrls", newlyAddedUrls);
                    } else {
                        json = this.generateJson(true);
                        log.error((Object)"File harvest terminated abnormally.");
                    }
                    break block15;
                }
                json = this.generateJson(true);
                log.error((Object)("Attempt to check status of a harvest that was never started!  (Session ID " + sessionId + ")"));
            }
            catch (Exception e) {
                json = this.generateJson(true);
                log.error((Object)e, (Throwable)e);
            }
        }
        try {
            response.getWriter().write(json.toString());
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private void doDownloadTemplatePost(HttpServletRequest request, HttpServletResponse response) {
        VitroRequest vreq = new VitroRequest(request);
        FileHarvestJob job = this.getJob(vreq, vreq.getParameter(PARAMETER_JOB));
        File fileToSend = new File(job.getTemplateFilePath());
        response.setContentType("application/octet-stream");
        response.setContentLength((int)fileToSend.length());
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileToSend.getName() + "\"");
        try {
            byte[] byteBuffer = new byte[(int)fileToSend.length()];
            DataInputStream inStream = new DataInputStream(new FileInputStream(fileToSend));
            ServletOutputStream outputStream = response.getOutputStream();
            int length = inStream.read(byteBuffer);
            while (length != -1) {
                outputStream.write(byteBuffer, 0, length);
                length = inStream.read(byteBuffer);
            }
            inStream.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private static String getScriptFileLocation(HttpServletRequest req) {
        return FileHarvestController.getHarvesterPath(req) + PATH_TO_HARVESTER_SCRIPTS + "temp/";
    }

    private File createScriptFile(String scriptFileLocation, String script) throws IOException {
        File scriptDirectory = new File(scriptFileLocation);
        if (!scriptDirectory.exists()) {
            scriptDirectory.mkdirs();
        }
        File tempFile = File.createTempFile("harv", ".sh", scriptDirectory);
        FileWriter writer = new FileWriter(tempFile);
        writer.write(script);
        writer.close();
        return tempFile;
    }

    private void runScript(String sessionId, String script, String additionsFilePath, String scriptFileLocation, FileHarvestJob job) {
        this.clearSessionInfo(sessionId);
        ScriptRunner runner = new ScriptRunner(sessionId, script, additionsFilePath, scriptFileLocation, job);
        SessionInfo info = new SessionInfo(sessionId, runner);
        this.sessionIdToSessionInfo.put(sessionId, info);
        runner.start();
    }

    private String handleNameCollision(String filename, File directory) {
        String base = filename;
        String extension = "";
        if (filename.contains(".")) {
            base = filename.substring(0, filename.lastIndexOf("."));
            extension = filename.substring(filename.indexOf("."));
        }
        String renamed = filename;
        int i = 1;
        while (new File(directory, renamed).exists()) {
            renamed = base + " (" + String.valueOf(i) + ")" + extension;
            ++i;
        }
        return renamed;
    }

    private static String getSessionId(HttpServletRequest request) {
        return request.getSession().getId();
    }

    private void extractNewlyAddedUris(File additionsFile, List<String> newlyAddedUris, FileHarvestJob job) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(additionsFile);
            NodeList descriptionNodes = document.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            int numNodes = descriptionNodes.getLength();
            for (int i = 0; i < numNodes; ++i) {
                NamedNodeMap attributes;
                Node aboutAttribute;
                String rdfType;
                Node node = descriptionNodes.item(i);
                ArrayList<String> types = this.getRdfTypes(node);
                boolean match = false;
                int n = 0;
                String[] validRdfTypesForJob = job.getRdfTypesForLinks();
                String[] stringArray = validRdfTypesForJob;
                int n2 = stringArray.length;
                if (n < n2 && types.contains(rdfType = stringArray[n])) {
                    match = true;
                }
                if (!match || (aboutAttribute = (attributes = node.getAttributes()).getNamedItemNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about")) == null) continue;
                String value = aboutAttribute.getNodeValue();
                newlyAddedUris.add(value);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    private ArrayList<String> getRdfTypes(Node descriptionNode) {
        ArrayList<String> rdfTypesList = new ArrayList<String>();
        NodeList children = descriptionNode.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            NamedNodeMap attributes;
            Node resourceAttribute;
            Node child = children.item(i);
            String namespace = child.getNamespaceURI();
            String name = child.getLocalName();
            String fullName = namespace + name;
            if (!fullName.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") || (resourceAttribute = (attributes = child.getAttributes()).getNamedItemNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource")) == null) continue;
            String value = resourceAttribute.getNodeValue();
            rdfTypesList.add(value);
        }
        return rdfTypesList;
    }

    private void clearSessionInfo(String sessionId) {
        SessionInfo sessionInfo = this.sessionIdToSessionInfo.get(sessionId);
        if (sessionInfo != null) {
            if (!sessionInfo.isFinished() && sessionInfo.harvestThread.isAlive()) {
                sessionInfo.harvestThread.abortRun();
            }
            this.sessionIdToSessionInfo.remove(sessionId);
        }
    }

    private void cleanUpOldSessions() {
        int minutesToAllowSession = 360;
        long millisecondsToAllowSession = minutesToAllowSession * 60 * 1000;
        Date now = new Date();
        Set<String> keySet = this.sessionIdToSessionInfo.keySet();
        for (String sessionId : keySet) {
            SessionInfo info = this.sessionIdToSessionInfo.get(sessionId);
            Date startTime = info.createTime;
            long differenceInMilliseconds = now.getTime() - startTime.getTime();
            if (differenceInMilliseconds <= millisecondsToAllowSession) continue;
            log.debug((Object)("Removing old session: " + sessionId));
            this.clearSessionInfo(sessionId);
        }
    }

    private JSONObject generateJson(boolean fatalError) {
        JSONObject json = null;
        try {
            json = new JSONObject();
            json.put("fatalError", fatalError);
        }
        catch (JSONException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return json;
    }

    static {
        FileHarvestController.fillKnownJobTypesList();
    }

    private class ScriptRunner
    extends Thread {
        private final String sessionId;
        private final String script;
        private final String additionsFilePath;
        private final String scriptFileLocation;
        private final FileHarvestJob job;
        private volatile boolean abort = false;

        public ScriptRunner(String sessionId, String script, String additionsFilePath, String scriptFileLocation, FileHarvestJob job) {
            this.sessionId = sessionId;
            this.script = script;
            this.additionsFilePath = additionsFilePath;
            this.scriptFileLocation = scriptFileLocation;
            this.job = job;
        }

        public void abortRun() {
            this.abort = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SessionInfo sessionInfo = (SessionInfo)FileHarvestController.this.sessionIdToSessionInfo.get(this.sessionId);
            boolean normalTerminationLineFound = false;
            if (sessionInfo != null) {
                try {
                    ArrayList<String> unsentLogLines = sessionInfo.unsentLogLines;
                    File scriptFile = FileHarvestController.this.createScriptFile(this.scriptFileLocation, this.script);
                    String command = "/bin/bash " + this.scriptFileLocation + scriptFile.getName();
                    log.info((Object)("Running command: " + command));
                    Process pr = Runtime.getRuntime().exec(command);
                    BufferedReader processOutputReader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String line = processOutputReader.readLine();
                    while (line != null) {
                        normalTerminationLineFound = line.endsWith(FileHarvestController.NORMAL_TERMINATION_LAST_OUTPUT);
                        ArrayList<String> arrayList = unsentLogLines;
                        synchronized (arrayList) {
                            unsentLogLines.add(line);
                        }
                        log.info((Object)("Harvester output: " + line));
                        if (this.abort) break;
                        line = processOutputReader.readLine();
                    }
                    if (!this.abort) {
                        BufferedReader processErrorReader = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                        String line2 = processErrorReader.readLine();
                        while (line2 != null) {
                            log.info((Object)("Harvester error: " + line2));
                            if (this.abort) break;
                            line2 = processErrorReader.readLine();
                        }
                    }
                    if (this.abort) {
                        log.debug((Object)("Aborting harvester script for session " + this.sessionId + "."));
                        pr.destroy();
                    } else {
                        int exitVal;
                        try {
                            exitVal = pr.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                        log.debug((Object)("Harvester script for session " + this.sessionId + " exited with error code " + exitVal));
                        File additionsFile = new File(this.additionsFilePath);
                        if (additionsFile.exists()) {
                            FileHarvestController.this.extractNewlyAddedUris(additionsFile, sessionInfo.newlyAddedUris, this.job);
                        } else {
                            log.error((Object)("Additions file not found: " + this.additionsFilePath));
                        }
                    }
                    log.info((Object)"Harvester script execution complete");
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    sessionInfo.finish();
                    if (!normalTerminationLineFound) {
                        sessionInfo.setAbnormalTermination();
                    }
                }
            }
        }
    }

    private class ExceptionVisibleToUser
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExceptionVisibleToUser(Throwable cause) {
            super(cause);
        }
    }

    private class SessionInfo {
        public final String sessionId;
        public final Date createTime;
        public final ScriptRunner harvestThread;
        public final ArrayList<String> unsentLogLines = new ArrayList();
        private boolean finished = false;
        private boolean abnormalTermination = false;
        public final ArrayList<String> newlyAddedUris = new ArrayList();

        public SessionInfo(String sessionId, ScriptRunner harvestThread) {
            this.createTime = new Date();
            this.sessionId = sessionId;
            this.harvestThread = harvestThread;
        }

        public void setAbnormalTermination() {
            this.abnormalTermination = true;
        }

        public boolean getAbnormalTermination() {
            return this.abnormalTermination;
        }

        public void finish() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

