/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.controller.visualization;

import edu.cornell.mannlib.vitro.webapp.controller.visualization.VisualizationInjector;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class VisualizationsDependencyInjector {
    private static Map<String, VisualizationRequestHandler> visualizationIDsToClass;

    private static synchronized Map<String, VisualizationRequestHandler> initVisualizations(ServletContext servletContext) {
        ClassPathXmlApplicationContext context;
        if (visualizationIDsToClass != null) {
            return visualizationIDsToClass;
        }
        String resourcePath = servletContext.getRealPath("/WEB-INF/visualization/visualizations-beans-injection-fm.xml");
        ClassPathXmlApplicationContext factory = context = new ClassPathXmlApplicationContext("file:" + resourcePath);
        VisualizationInjector visualizationInjector = (VisualizationInjector)factory.getBean("visualizationInjector");
        visualizationIDsToClass = visualizationInjector.getVisualizationIDToClass();
        return visualizationIDsToClass;
    }

    public static Map<String, VisualizationRequestHandler> getVisualizationIDsToClassMap(ServletContext servletContext) {
        if (visualizationIDsToClass != null) {
            return visualizationIDsToClass;
        }
        return VisualizationsDependencyInjector.initVisualizations(servletContext);
    }
}

