/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing;

import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.MultiValueEditSubmission;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutocompleteRequiredInputValidator
implements N3ValidatorVTwo {
    private static String MISSING_LABEL_ERROR = "Please select an existing value or enter a new value in the Name field.";
    private String uriReceiver;
    private String labelInput;

    public AutocompleteRequiredInputValidator(String uriReceiver, String labelInput) {
        this.uriReceiver = uriReceiver;
        this.labelInput = labelInput;
    }

    public Map<String, String> validate(EditConfigurationVTwo editConfig, MultiValueEditSubmission editSub) {
        Map urisFromForm = editSub.getUrisFromForm();
        Map literalsFromForm = editSub.getLiteralsFromForm();
        HashMap<String, String> errors = new HashMap<String, String>();
        List selectedUri = (List)urisFromForm.get(this.uriReceiver);
        if (this.allListElementsEmpty(selectedUri) || selectedUri.contains(">SUBMITTED VALUE WAS BLANK<")) {
            selectedUri = null;
        }
        if (selectedUri != null) {
            return null;
        }
        List specifiedLabel = (List)literalsFromForm.get(this.labelInput);
        if (specifiedLabel != null && specifiedLabel.size() > 0) {
            return null;
        }
        errors.put(this.labelInput, MISSING_LABEL_ERROR);
        return errors.size() != 0 ? errors : null;
    }

    private boolean allListElementsEmpty(List<String> checkList) {
        if (checkList == null) {
            return true;
        }
        if (checkList.isEmpty()) {
            return true;
        }
        boolean allEmpty = true;
        for (String s : checkList) {
            if (s.length() == 0) continue;
            allEmpty = false;
            break;
        }
        return allEmpty;
    }
}

