/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.AutocompleteRequiredInputValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import javax.servlet.http.HttpSession;

public class GrantAdministeredByGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewAdminRole = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n?grant vivo:relates  ?adminRole . \n?adminRole a  vivo:AdministratorRole . \n?adminRole vivo:relatedBy ?grant . ";
    static final String n3ForNewAdminOrganization = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?adminRole <http://purl.obolibrary.org/obo/RO_0000052> ?newOrganization . \n?newOrganization a <http://xmlns.com/foaf/0.1/Organization>  . \n?newOrganization <http://purl.obolibrary.org/obo/RO_0000053> ?adminRole . \n?newOrganization vivo:relatedBy ?grant . \n?grant vivo:relates ?newOrganization . \n?newOrganization <http://www.w3.org/2000/01/rdf-schema#label> ?orgLabel .";
    static final String n3ForExistingAdminOrganization = "@prefix vivo: <http://vivoweb.org/ontology/core#> . \n\n?adminRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingOrganization . \n?existingOrganization a <http://xmlns.com/foaf/0.1/Organization>  . \n?existingOrganization <http://purl.obolibrary.org/obo/RO_0000053> ?adminRole . ?existingOrganization vivo:relatedBy ?grant . \n?grant vivo:relates ?existingOrganization . \n";
    static final String existingOrganizationQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#>  \nSELECT ?existingOrganization WHERE { \n ?adminRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingOrganization . \n ?existingOrganization a <http://xmlns.com/foaf/0.1/Organization> . \n}";
    static final String orgLabelQuery = "PREFIX vivo: <http://vivoweb.org/ontology/core#> \nSELECT ?existingOrganizationLabel WHERE { \n ?adminRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingOrganization . \n ?existingOrganization a <http://xmlns.com/foaf/0.1/Organization> . \n ?existingOrganization <http://www.w3.org/2000/01/rdf-schema#label> ?existingOrganizationLabel . \n}";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("grantAdministeredBy.ftl");
        conf.setVarNameForSubject("grant");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("adminRole");
        conf.setN3Required(Arrays.asList(n3ForNewAdminRole));
        conf.setN3Optional(Arrays.asList(n3ForNewAdminOrganization, n3ForExistingAdminOrganization));
        conf.addNewResource("newOrganization", "");
        conf.addNewResource("adminRole", "");
        conf.setUrisOnform(Arrays.asList("existingOrganization"));
        conf.setLiteralsOnForm(Arrays.asList("orgLabel", "orgLabelDisplay"));
        conf.addSparqlForExistingLiteral("orgLabel", orgLabelQuery);
        conf.addSparqlForExistingUris("existingOrganization", existingOrganizationQuery);
        conf.addField(new FieldVTwo().setName("existingOrganization"));
        conf.addField(new FieldVTwo().setName("orgLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(GrantAdministeredByGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("orgLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(GrantAdministeredByGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new AutocompleteRequiredInputValidator("existingOrganization", "orgLabel"));
        this.prepare(vreq, conf);
        return conf;
    }
}

