/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.FirstAndLastNameValidator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.ChildVClassesWithParent;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldOptions;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import edu.cornell.mannlib.vitro.webapp.utils.FrontEndEditingUtils;
import edu.cornell.mannlib.vitro.webapp.utils.generators.EditModeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpSession;

public class GrantHasContributorGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    static final String n3ForNewProjectRole = "@prefix core: <http://vivoweb.org/ontology/core#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>  . \n?subject core:relates  ?theRole .\n?theRole core:relatedBy ?subject . \n";
    static final String roleTypeAssertion = "?theRole a ?roleType .";
    static final String n3ForNewPerson = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?theRole <http://purl.obolibrary.org/obo/RO_0000052> ?newPerson . \n?newPerson <http://purl.obolibrary.org/obo/RO_0000053> ?theRole . \n?subject core:relates ?newPerson . \n?newPerson core:relatedBy ?subject . \n?newPerson a <http://xmlns.com/foaf/0.1/Person> . \n?newPerson <http://www.w3.org/2000/01/rdf-schema#label> ?personLabel . ";
    static final String n3ForExistingPerson = "@prefix core: <http://vivoweb.org/ontology/core#> .\n?theRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?theRole . \n?subject core:relates ?newPerson . \n?newPerson core:relatedBy ?subject . \n ";
    static final String firstNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:givenName ?firstName .";
    static final String lastNameAssertion = "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .  \n?newPerson <http://purl.obolibrary.org/obo/ARG_2000028>  ?vcardPerson . \n?vcardPerson <http://purl.obolibrary.org/obo/ARG_2000029>  ?newPerson . \n?vcardPerson a <http://www.w3.org/2006/vcard/ns#Individual> . \n?vcardPerson vcard:hasName  ?vcardName . \n?vcardName a <http://www.w3.org/2006/vcard/ns#Name> . \n?vcardName vcard:familyName ?lastName .";
    static final String roleTypeQuery = "PREFIX vitro: <http://vitro.mannlib.cornell.edu/ns/vitro/0.7#> \nSELECT ?roleType WHERE { \n  ?theRole vitro:mostSpecificType ?roleType . }";
    static final String existingPersonQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPerson WHERE {\n?theRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?theRole . \n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";
    static final String personLabelQuery = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>   \nSELECT ?existingPersonLabel WHERE {\n?theRole <http://purl.obolibrary.org/obo/RO_0000052> ?existingPerson . \n?existingPerson <http://purl.obolibrary.org/obo/RO_0000053> ?theRole .\n?existingPerson <http://www.w3.org/2000/01/rdf-schema#label> ?existingPersonLabel .\n?existingPerson a <http://xmlns.com/foaf/0.1/Person> . \n  }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        conf.setTemplate("grantHasContributor.ftl");
        conf.setVarNameForSubject("subject");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("theRole");
        conf.setN3Required(Arrays.asList(n3ForNewProjectRole, roleTypeAssertion));
        conf.setN3Optional(Arrays.asList(n3ForNewPerson, n3ForExistingPerson, firstNameAssertion, lastNameAssertion));
        conf.addNewResource("theRole", "");
        conf.addNewResource("newPerson", "");
        conf.addNewResource("vcardPerson", "");
        conf.addNewResource("vcardName", "");
        conf.setUrisOnform(Arrays.asList("existingPerson", "roleType"));
        conf.setLiteralsOnForm(Arrays.asList("personLabel", "personLabelDisplay", "firstName", "lastName"));
        conf.addSparqlForExistingLiteral("personLabel", personLabelQuery);
        conf.addSparqlForExistingUris("existingPerson", existingPersonQuery);
        conf.addSparqlForExistingUris("roleType", roleTypeQuery);
        conf.addField(new FieldVTwo().setName("existingPerson"));
        conf.addField(new FieldVTwo().setName("personLabel").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(GrantHasContributorGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("personLabelDisplay").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(GrantHasContributorGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(GrantHasContributorGenerator.list((Object[])new Object[]{"datatype:" + XSD.xstring.toString()})));
        conf.addField(new FieldVTwo().setName("roleType").setValidators(GrantHasContributorGenerator.list((Object[])new Object[]{"nonempty"})).setOptions((FieldOptions)new ChildVClassesWithParent("http://vivoweb.org/ontology/core#ResearcherRole")));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        conf.addValidator((N3ValidatorVTwo)new FirstAndLastNameValidator("existingPerson"));
        this.addFormSpecificData(conf, vreq);
        this.prepare(vreq, conf);
        return conf;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("editMode", this.getEditMode(vreq).name().toLowerCase());
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    public FrontEndEditingUtils.EditMode getEditMode(VitroRequest vreq) {
        ArrayList<String> predicates = new ArrayList<String>();
        predicates.add("http://purl.obolibrary.org/obo/RO_0000053");
        return EditModeUtils.getEditMode((VitroRequest)vreq, predicates);
    }
}

