/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConceptSemanticTypesPreprocessor
implements ModelChangePreprocessor {
    private static String VIVOCore = "http://vivoweb.org/ontology/core#";
    private static String SKOSConceptType = "http://www.w3.org/2004/02/skos/core#Concept";
    private Log log = LogFactory.getLog(ConceptSemanticTypesPreprocessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(Model retractionsModel, Model additionsModel, HttpServletRequest request) {
        VitroRequest vreq = new VitroRequest(request);
        String prefixes = "PREFIX rdfs:<" + RDFS.getURI() + "> " + "PREFIX owl:<http://www.w3.org/2002/07/owl#> " + "PREFIX rdf:<" + RDF.getURI() + ">" + "PREFIX skos:<http://www.w3.org/2004/02/skos/core#>";
        String constructQuery = prefixes + " CONSTRUCT { " + "?semanticType rdf:type owl:Class.  " + "?semanticType rdfs:subClassOf skos:Concept .  " + "?semanticType rdfs:label ?label.  " + "} WHERE { " + "?concept rdf:type ?semanticType.  " + "?semanticType rdfs:label ?label . " + "?semanticType rdfs:subClassOf skos:Concept . " + "}";
        Model constructedModel = ModelFactory.createDefaultModel();
        this.log.debug((Object)("CONSTRUCT query string " + constructQuery));
        Query query = null;
        try {
            query = QueryFactory.create((String)constructQuery, (Syntax)Syntax.syntaxARQ);
        }
        catch (Throwable th) {
            this.log.error((Object)("Could not create CONSTRUCT SPARQL query for query string. " + th.getMessage()));
            this.log.error((Object)constructQuery);
            return;
        }
        additionsModel.getLock().enterCriticalSection(true);
        QueryExecution qe = null;
        try {
            qe = QueryExecutionFactory.create((Query)query, (Model)additionsModel);
            qe.execConstruct(constructedModel);
        }
        catch (Exception e) {
            this.log.error((Object)("Error getting constructed model for query string " + constructQuery));
        }
        finally {
            if (qe != null) {
                qe.close();
            }
            additionsModel.getLock().leaveCriticalSection();
        }
        OntModel toUpdateModel = ModelAccess.on((HttpServletRequest)vreq).getOntModelSelector(new ModelAccess.OntModelSelectorOption[0]).getTBoxModel();
        toUpdateModel.enterCriticalSection(false);
        try {
            toUpdateModel.add(constructedModel);
        }
        catch (Exception e) {
            this.log.error((Object)("Error adding statements to update model for " + constructQuery));
        }
        finally {
            toUpdateModel.leaveCriticalSection();
        }
        additionsModel.enterCriticalSection(false);
        try {
            additionsModel.remove(constructedModel.listStatements().toList());
        }
        catch (Exception e) {
            this.log.error((Object)("Error removing statements from additions model for " + constructQuery));
        }
        finally {
            additionsModel.leaveCriticalSection();
        }
    }
}

