/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.utils.ProcessIndividualsForClassesDataGetterN3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessInternalClassDataGetterN3
extends ProcessIndividualsForClassesDataGetterN3 {
    private static String classType = "java:edu.cornell.mannlib.vitro.webapp.utils.dataGetter.InternalClassesDataGetter";
    private static String internalClassVarNameBase = "isInternal";
    private Log log = LogFactory.getLog(ProcessInternalClassDataGetterN3.class);

    public List<String> retrieveN3Required(int counter) {
        return super.retrieveN3Required(counter);
    }

    private List<String> addInternalClassN3(int counter) {
        ArrayList<String> internalClassN3 = new ArrayList<String>();
        String dataGetterVar = this.getDataGetterVar(counter);
        internalClassN3.add(dataGetterVar + " <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass" + "> " + this.getN3VarName(internalClassVarNameBase, counter) + " .");
        return internalClassN3;
    }

    public List<String> retrieveN3Optional(int counter) {
        ArrayList<String> optionalN3 = new ArrayList<String>();
        optionalN3.addAll(this.addInternalClassN3(counter));
        return optionalN3;
    }

    public List<String> retrieveLiteralsOnForm(int counter) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add(this.getVarName(internalClassVarNameBase, counter));
        return literalsOnForm;
    }

    public List<FieldVTwo> retrieveFields(int counter) {
        List fields = super.retrieveFields(counter);
        fields.add(new FieldVTwo().setName(this.getVarName(internalClassVarNameBase, counter)));
        return fields;
    }

    public List<String> getLiteralVarNamesBase() {
        return Arrays.asList(internalClassVarNameBase);
    }

    public String getClassType() {
        return classType;
    }

    public void populateExistingValues(String dataGetterURI, int counter, OntModel queryModel) {
        this.populateExistingDataGetterURI(dataGetterURI, counter);
        this.populateExistingClassType(this.getClassType(), counter);
        String querystr = this.getExistingValuesInternalClass(dataGetterURI);
        QueryExecution qe = null;
        Literal internalClassLiteral = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            Object classGroupURI = null;
            ArrayList<String> individualsForClasses = new ArrayList<String>();
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                Resource classGroupResource = qs.getResource("classGroup");
                String classGroupVarName = this.getVarName(classGroupVarBase, counter);
                if (classGroupURI == null) {
                    this.existingUriValues.put(this.getVarName(classGroupVarBase, counter), new ArrayList<String>(Arrays.asList(classGroupResource.getURI())));
                }
                Resource individualForClassResource = qs.getResource("individualForClass");
                individualsForClasses.add(individualForClassResource.getURI());
                if (qs.get("internalClass") == null || internalClassLiteral != null) continue;
                internalClassLiteral = qs.getLiteral("internalClass");
                this.existingLiteralValues.put(this.getVarName(internalClassVarNameBase, counter), new ArrayList<Literal>(Arrays.asList(internalClassLiteral)));
            }
            this.existingUriValues.put(this.getVarName(individualClassVarNameBase, counter), new ArrayList(individualsForClasses));
            if (internalClassLiteral == null) {
                this.existingLiteralValues.put(this.getVarName(internalClassVarNameBase, counter), new ArrayList<Literal>(Arrays.asList(ResourceFactory.createPlainLiteral((String)"false"))));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }

    protected String getExistingValuesInternalClass(String dataGetterURI) {
        String query = this.getSparqlPrefix() + " SELECT ?classGroup  ?individualForClass ?internalClass WHERE {" + "<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#forClassGroup" + "> ?classGroup  . \n" + "OPTIONAL {<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#getIndividualsForClass" + "> ?individualForClass . }\n" + "OPTIONAL {<" + dataGetterURI + "> <" + "http://vitro.mannlib.cornell.edu/ontologies/display/1.1#restrictResultsByInternalClass" + "> ?internalClass .} \n" + "}";
        return query;
    }

    public JSONObject getExistingValuesJSON(String dataGetterURI, OntModel queryModel, ServletContext context) {
        JSONObject jObject = new JSONObject();
        jObject.element("dataGetterClass", (Object)classType);
        jObject.element(classTypeVarBase, (Object)classType);
        this.getExistingClassGroupAndInternalClass(dataGetterURI, jObject, queryModel);
        this.getExistingClassesInClassGroup(context, dataGetterURI, jObject);
        return jObject;
    }

    private void getExistingClassGroupAndInternalClass(String dataGetterURI, JSONObject jObject, OntModel queryModel) {
        String querystr = this.getExistingValuesInternalClass(dataGetterURI);
        QueryExecution qe = null;
        Literal internalClassLiteral = null;
        try {
            Query query = QueryFactory.create((String)querystr);
            qe = QueryExecutionFactory.create((Query)query, (Model)queryModel);
            ResultSet results = qe.execSelect();
            JSONArray individualsForClasses = new JSONArray();
            String classGroupURI = null;
            while (results.hasNext()) {
                QuerySolution qs = results.nextSolution();
                if (classGroupURI == null) {
                    Resource classGroupResource = qs.getResource("classGroup");
                    classGroupURI = classGroupResource.getURI();
                }
                if (qs.get("individualForClass") != null) {
                    Resource individualForClassResource = qs.getResource("individualForClass");
                    individualsForClasses.add((Object)individualForClassResource.getURI());
                }
                if (qs.get("internalClass") == null || internalClassLiteral != null) continue;
                internalClassLiteral = qs.getLiteral("internalClass");
            }
            jObject.element("classGroup", classGroupURI);
            jObject.element(individualClassVarNameBase, (Collection)individualsForClasses);
            if (internalClassLiteral != null) {
                jObject.element(internalClassVarNameBase, (Object)internalClassLiteral.getString());
            } else {
                jObject.element(internalClassVarNameBase, (Object)"false");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception occurred in retrieving existing values with query " + querystr), (Throwable)ex);
        }
    }
}

