/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coauthorship;

import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFServiceException;
import edu.cornell.mannlib.vitro.webapp.rdfservice.ResultSetConsumer;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CoAuthorshipData;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaboratorComparator;
import edu.cornell.mannlib.vitro.webapp.visualization.constants.QueryConstants;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.utilities.VisualizationCaches;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Activity;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaboration;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.QueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UniqueIDGenerator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;

public class CoAuthorshipQueryRunner
implements QueryRunner<CoAuthorshipData> {
    private static final int MAX_AUTHORS_PER_PAPER_ALLOWED = 100;
    protected static final Syntax SYNTAX = Syntax.syntaxARQ;
    private static boolean preferCaches = false;
    private String egoURI;
    private RDFService rdfService;
    private VitroRequest vitroRequest;
    private Log log;
    private static final Map<String, CollaborationDataCacheEntry> collaborationDataCache = new ConcurrentHashMap<String, CollaborationDataCacheEntry>();

    public CoAuthorshipQueryRunner(String egoURI, VitroRequest vreq, Log log) {
        this.egoURI = egoURI;
        this.rdfService = vreq.getRDFService();
        this.vitroRequest = vreq;
        this.log = log;
    }

    private String generateEgoCoAuthorshipSparqlQuery(String queryURI) {
        String sparqlQuery = QueryConstants.getSparqlPrefixQuery() + "PREFIX local: <http://localhost/>\n" + "SELECT \n" + "\t\t(str(<" + queryURI + ">) as ?" + "authPersonLit" + ") \n" + "\t\t(str(?authorLabel) as ?" + "authorLabelLit" + ") \n" + "\t\t(str(?coAuthorPerson) as ?" + "coAuthPersonLit" + ") \n" + "\t\t(str(?coAuthorPersonLabel) as ?" + "coAuthPersonLabelLit" + ") \n" + "\t\t(str(?document) as ?" + "documentLit" + ") \n" + "\t\t(str(?publicationDate) as ?" + "publicationDateLit" + ") \n" + "WHERE { \n" + "    <" + queryURI + "> local:authorLabel ?authorLabel ;" + " local:authorOf ?document . \n" + "    ?document local:coAuthor ?coAuthorPerson . \n" + "    ?coAuthorPerson rdfs:label ?coAuthorPersonLabel . \n" + "    OPTIONAL { ?document local:publicationDate ?publicationDate . } \n" + "} \n" + "ORDER BY ?document ?coAuthorPerson\n";
        this.log.debug((Object)("COAUTHORSHIP QUERY - " + sparqlQuery));
        return sparqlQuery;
    }

    private String generateEgoCoAuthorshipSparqlConstruct(String queryURI) {
        String sparqlConstruct = QueryConstants.getSparqlPrefixQuery() + "PREFIX local: <http://localhost/>\n" + "CONSTRUCT\n" + "{\n" + "    <" + queryURI + "> local:authorLabel ?authorLabel .\n" + "    <" + queryURI + "> local:authorOf ?document .\n" + "    ?document local:publicationDate ?publicationDate .\n" + "    ?document local:coAuthor ?coAuthorPerson .\n" + "    ?coAuthorPerson rdfs:label ?coAuthorPersonLabel .\n" + "}\n" + "WHERE\n" + "{\n" + "    {\n" + "        <" + queryURI + "> rdf:type foaf:Person ;" + "                rdfs:label ?authorLabel ;" + "                core:relatedBy ?authorshipNode . \n" + "        ?authorshipNode rdf:type core:Authorship ;" + "                core:relates ?document . \n" + "        ?document rdf:type <http://purl.obolibrary.org/obo/IAO_0000030> ; \n" + "                core:relatedBy ?coAuthorshipNode . \n" + "        ?coAuthorshipNode rdf:type core:Authorship ; \n" + "                core:relates ?coAuthorPerson . \n" + "        ?coAuthorPerson rdf:type foaf:Person ; \n" + "                rdfs:label ?coAuthorPersonLabel . \n" + "    }\n" + "    UNION\n" + "    {\n" + "        <" + queryURI + "> rdf:type foaf:Person ;" + "                rdfs:label ?authorLabel ;" + "                core:relatedBy ?authorshipNode . \n" + "        ?authorshipNode rdf:type core:Authorship ;" + "                core:relates ?document . \n" + "        ?document core:dateTimeValue ?dateTimeValue . \n" + "\t\t   ?dateTimeValue core:dateTime ?publicationDate . \n" + "    }\n" + "}\n";
        return sparqlConstruct;
    }

    @Override
    public CoAuthorshipData getQueryResult() throws MalformedQueryParametersException {
        CoAuthorshipData data = this.getCachedData(this.egoURI);
        if (data != null) {
            return data;
        }
        return this.getQueryResultAndCache();
    }

    private CoAuthorshipData getCachedData(String egoURI) {
        CollaborationDataCacheEntry entry = collaborationDataCache.get(egoURI);
        if (entry != null && !entry.hasExpired()) {
            entry.accessTime = new Date().getTime();
            this.expireCache();
            return entry.data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CoAuthorshipData getQueryResultAndCache() throws MalformedQueryParametersException {
        CoAuthorshipData data = this.getCachedData(this.egoURI);
        if (data != null) {
            return data;
        }
        if (StringUtils.isNotBlank((String)this.egoURI)) {
            IRIFactory iRIFactory = IRIFactory.jenaImplementation();
            IRI iri = iRIFactory.create(this.egoURI);
            if (iri.hasViolation(false)) {
                String errorMsg = ((Violation)iri.violations(false).next()).getShortMessage();
                this.log.error((Object)("Ego Co-Authorship Vis Query " + errorMsg));
                throw new MalformedQueryParametersException("URI provided for an individual is malformed.");
            }
        } else {
            throw new MalformedQueryParametersException("URI parameter is either null or empty.");
        }
        Date cacheTime = null;
        QueryResultConsumer consumer = new QueryResultConsumer();
        if (preferCaches && VisualizationCaches.personToPublication.isCached()) {
            cacheTime = VisualizationCaches.personToPublication.cachedWhen();
            Map<String, String> personLabelsMap = VisualizationCaches.personLabels.get(this.rdfService);
            Map<String, Set<String>> personToPublicationMap = VisualizationCaches.personToPublication.get((RDFService)this.rdfService).personToPublication;
            Map<String, Set<String>> publicationToPersonMap = VisualizationCaches.personToPublication.get((RDFService)this.rdfService).publicationToPerson;
            Map<String, String> publicationToYearMap = VisualizationCaches.publicationToYear.get(this.rdfService);
            String authorURI = this.egoURI;
            String authorName = personLabelsMap.get(authorURI);
            for (String documentURI : personToPublicationMap.get(authorURI)) {
                String documentDate = publicationToYearMap.get(documentURI);
                for (String coAuthorURI : publicationToPersonMap.get(documentURI)) {
                    String coAuthorName = personLabelsMap.get(coAuthorURI);
                    consumer.processEntry(authorURI, authorName, documentURI, documentDate, coAuthorURI, coAuthorName);
                }
            }
            consumer.endProcessing();
        } else {
            long queryStart = System.currentTimeMillis();
            try {
                Model constructedModel = ModelFactory.createDefaultModel();
                this.rdfService.sparqlConstructQuery(this.generateEgoCoAuthorshipSparqlConstruct(this.egoURI), constructedModel);
                try (QueryExecution qe = QueryExecutionFactory.create((String)this.generateEgoCoAuthorshipSparqlQuery(this.egoURI), (Model)constructedModel);){
                    consumer.processResultSet(qe.execSelect());
                }
            }
            catch (RDFServiceException e) {
                this.log.error((Object)"Unable to execute query", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                if (System.currentTimeMillis() - queryStart > 5000L) {
                    if (!preferCaches && !VisualizationCaches.personToPublication.isCached()) {
                        VisualizationCaches.rebuildAll();
                    }
                    preferCaches = true;
                }
            }
        }
        if (consumer.egoNode == null) {
            consumer.egoNode = this.makeEgoNode();
        }
        data = consumer.getCollaborationData();
        if (cacheTime != null) {
            data.setBuiltFromCacheTime(cacheTime);
        }
        CollaborationDataCacheEntry newEntry = new CollaborationDataCacheEntry();
        newEntry.uri = this.egoURI;
        newEntry.data = data;
        newEntry.creationTime = newEntry.accessTime = new Date().getTime();
        this.expireCache();
        collaborationDataCache.put(this.egoURI, newEntry);
        return data;
    }

    private Collaborator makeEgoNode() {
        Collaborator collab = new Collaborator(this.egoURI, new UniqueIDGenerator());
        collab.setCollaboratorName(UtilityFunctions.getIndividualLabelFromDAO(this.vitroRequest, this.egoURI));
        return collab;
    }

    private synchronized void expireCache() {
        for (String key : collaborationDataCache.keySet()) {
            CollaborationDataCacheEntry entry = collaborationDataCache.get(key);
            if (entry == null || !entry.hasExpired()) continue;
            collaborationDataCache.remove(key);
        }
    }

    private static class CollaborationDataCacheEntry {
        String uri;
        CoAuthorshipData data;
        long creationTime;
        long accessTime;

        private CollaborationDataCacheEntry() {
        }

        boolean hasExpired() {
            long now = new Date().getTime();
            if (this.creationTime < now - 300000L && this.accessTime < now - 3000L) {
                return true;
            }
            return this.accessTime < now - 30000L;
        }
    }

    private static class QueryResultConsumer
    extends ResultSetConsumer {
        Set<Collaborator> nodes = new HashSet<Collaborator>();
        Map<String, Activity> biboDocumentURLToVO = new HashMap<String, Activity>();
        Map<String, Set<Collaborator>> biboDocumentURLToCoAuthors = new HashMap<String, Set<Collaborator>>();
        Map<String, Collaborator> nodeURLToVO = new HashMap<String, Collaborator>();
        Map<String, Collaboration> edgeUniqueIdentifierToVO = new HashMap<String, Collaboration>();
        Collaborator egoNode = null;
        Set<Collaboration> edges = new HashSet<Collaboration>();
        private UniqueIDGenerator nodeIDGenerator = new UniqueIDGenerator();
        private UniqueIDGenerator edgeIDGenerator = new UniqueIDGenerator();

        private QueryResultConsumer() {
        }

        protected void processQuerySolution(QuerySolution qs) {
            RDFNode egoAuthorURLNode = qs.get("authPersonLit");
            RDFNode authorLabelNode = qs.get("authorLabelLit");
            RDFNode documentNode = qs.get("documentLit");
            RDFNode coAuthorURLNode = qs.get("coAuthPersonLit");
            RDFNode coAuthorLabelNode = qs.get("coAuthPersonLabelLit");
            RDFNode publicationDateNode = qs.get("publicationDateLit");
            String authorURI = egoAuthorURLNode == null ? null : egoAuthorURLNode.asLiteral().getString();
            String authorName = authorLabelNode == null ? null : authorLabelNode.asLiteral().getString();
            String documentURI = documentNode == null ? null : documentNode.asLiteral().getString();
            String documentDate = publicationDateNode == null ? null : publicationDateNode.asLiteral().getString();
            String coAuthorURI = coAuthorURLNode == null ? null : coAuthorURLNode.asLiteral().getString();
            String coAuthorName = coAuthorLabelNode == null ? null : coAuthorLabelNode.asLiteral().getString();
            this.processEntry(authorURI, authorName, documentURI, documentDate, coAuthorURI, coAuthorName);
        }

        public void processEntry(String authorURI, String authorName, String documentURI, String documentDate, String coAuthorURI, String coAuthorName) {
            Set<Object> coAuthorsForCurrentBiboDocument;
            Collaborator coAuthorNode;
            Activity biboDocument;
            if (this.nodeURLToVO.containsKey(authorURI)) {
                this.egoNode = this.nodeURLToVO.get(authorURI);
            } else {
                this.egoNode = new Collaborator(authorURI, this.nodeIDGenerator);
                this.nodes.add(this.egoNode);
                this.nodeURLToVO.put(authorURI, this.egoNode);
                if (authorName != null) {
                    this.egoNode.setCollaboratorName(authorName);
                }
            }
            if (this.biboDocumentURLToVO.containsKey(documentURI)) {
                biboDocument = this.biboDocumentURLToVO.get(documentURI);
            } else {
                biboDocument = this.createDocumentVO(documentURI, documentDate);
                this.biboDocumentURLToVO.put(documentURI, biboDocument);
            }
            this.egoNode.addActivity(biboDocument);
            if (authorURI.equalsIgnoreCase(coAuthorURI)) {
                return;
            }
            if (this.nodeURLToVO.containsKey(coAuthorURI)) {
                coAuthorNode = this.nodeURLToVO.get(coAuthorURI);
            } else {
                coAuthorNode = new Collaborator(coAuthorURI, this.nodeIDGenerator);
                this.nodes.add(coAuthorNode);
                this.nodeURLToVO.put(coAuthorURI, coAuthorNode);
                if (coAuthorName != null) {
                    coAuthorNode.setCollaboratorName(coAuthorName);
                }
            }
            coAuthorNode.addActivity(biboDocument);
            if (this.biboDocumentURLToCoAuthors.containsKey(biboDocument.getActivityURI())) {
                coAuthorsForCurrentBiboDocument = this.biboDocumentURLToCoAuthors.get(biboDocument.getActivityURI());
            } else {
                coAuthorsForCurrentBiboDocument = new HashSet();
                this.biboDocumentURLToCoAuthors.put(biboDocument.getActivityURI(), coAuthorsForCurrentBiboDocument);
            }
            coAuthorsForCurrentBiboDocument.add(coAuthorNode);
            Collaboration egoCoAuthorEdge = this.getExistingEdge(this.egoNode, coAuthorNode, this.edgeUniqueIdentifierToVO);
            if (egoCoAuthorEdge != null) {
                egoCoAuthorEdge.addActivity(biboDocument);
            } else {
                egoCoAuthorEdge = new Collaboration(this.egoNode, coAuthorNode, biboDocument, this.edgeIDGenerator);
                this.edges.add(egoCoAuthorEdge);
                this.edgeUniqueIdentifierToVO.put(this.getEdgeUniqueIdentifier(this.egoNode.getCollaboratorID(), coAuthorNode.getCollaboratorID()), egoCoAuthorEdge);
            }
        }

        protected void endProcessing() {
            this.removeLowQualityNodesAndEdges(this.nodes, this.biboDocumentURLToVO, this.biboDocumentURLToCoAuthors, this.edges);
            this.createCoAuthorEdges(this.biboDocumentURLToVO, this.biboDocumentURLToCoAuthors, this.edges, this.edgeUniqueIdentifierToVO);
        }

        public CoAuthorshipData getCollaborationData() {
            return new CoAuthorshipData(this.egoNode, this.nodes, this.edges, this.biboDocumentURLToVO);
        }

        private Activity createDocumentVO(String documentURL, String documentDate) {
            Activity biboDocument = new Activity(documentURL);
            if (documentDate != null) {
                biboDocument.setActivityDate(documentDate);
            }
            return biboDocument;
        }

        private String getEdgeUniqueIdentifier(int nodeID1, int nodeID2) {
            String separator = "*";
            if (nodeID1 < nodeID2) {
                return nodeID1 + separator + nodeID2;
            }
            return nodeID2 + separator + nodeID1;
        }

        private void createCoAuthorEdges(Map<String, Activity> biboDocumentURLToVO, Map<String, Set<Collaborator>> biboDocumentURLToCoAuthors, Set<Collaboration> edges, Map<String, Collaboration> edgeUniqueIdentifierToVO) {
            for (Map.Entry<String, Set<Collaborator>> currentBiboDocumentEntry : biboDocumentURLToCoAuthors.entrySet()) {
                if (currentBiboDocumentEntry.getValue().size() <= 1 || currentBiboDocumentEntry.getValue().size() > 100) continue;
                HashSet<Collaboration> newlyAddedEdges = new HashSet<Collaboration>();
                ArrayList coAuthorNodes = new ArrayList(currentBiboDocumentEntry.getValue());
                Collections.sort(coAuthorNodes, new CollaboratorComparator());
                int numOfCoAuthors = coAuthorNodes.size();
                for (int ii = 0; ii < numOfCoAuthors - 1; ++ii) {
                    for (int jj = ii + 1; jj < numOfCoAuthors; ++jj) {
                        Collaborator coAuthor1 = (Collaborator)coAuthorNodes.get(ii);
                        Collaborator coAuthor2 = (Collaborator)coAuthorNodes.get(jj);
                        Collaboration coAuthor1_2Edge = this.getExistingEdge(coAuthor1, coAuthor2, edgeUniqueIdentifierToVO);
                        Activity currentBiboDocument = biboDocumentURLToVO.get(currentBiboDocumentEntry.getKey());
                        if (coAuthor1_2Edge != null) {
                            coAuthor1_2Edge.addActivity(currentBiboDocument);
                            continue;
                        }
                        coAuthor1_2Edge = new Collaboration(coAuthor1, coAuthor2, currentBiboDocument, this.edgeIDGenerator);
                        newlyAddedEdges.add(coAuthor1_2Edge);
                        edgeUniqueIdentifierToVO.put(this.getEdgeUniqueIdentifier(coAuthor1.getCollaboratorID(), coAuthor2.getCollaboratorID()), coAuthor1_2Edge);
                    }
                }
                edges.addAll(newlyAddedEdges);
            }
        }

        private Collaboration getExistingEdge(Collaborator collaboratingNode1, Collaborator collaboratingNode2, Map<String, Collaboration> edgeUniqueIdentifierToVO) {
            String edgeUniqueIdentifier = this.getEdgeUniqueIdentifier(collaboratingNode1.getCollaboratorID(), collaboratingNode2.getCollaboratorID());
            return edgeUniqueIdentifierToVO.get(edgeUniqueIdentifier);
        }

        private void removeLowQualityNodesAndEdges(Set<Collaborator> nodes, Map<String, Activity> biboDocumentURLToVO, Map<String, Set<Collaborator>> biboDocumentURLToCoAuthors, Set<Collaboration> edges) {
            HashSet<Collaborator> nodesToBeRemoved = new HashSet<Collaborator>();
            for (Map.Entry<String, Set<Collaborator>> currentBiboDocumentEntry : biboDocumentURLToCoAuthors.entrySet()) {
                if (currentBiboDocumentEntry.getValue().size() <= 100) continue;
                Activity currentBiboDocument = biboDocumentURLToVO.get(currentBiboDocumentEntry.getKey());
                HashSet<Collaboration> edgesToBeRemoved = new HashSet<Collaboration>();
                for (Collaboration currentEdge : edges) {
                    Set<Activity> currentCollaboratorDocuments = currentEdge.getCollaborationActivities();
                    if (!currentCollaboratorDocuments.contains(currentBiboDocument)) continue;
                    currentCollaboratorDocuments.remove(currentBiboDocument);
                    if (!currentCollaboratorDocuments.isEmpty()) continue;
                    edgesToBeRemoved.add(currentEdge);
                }
                edges.removeAll(edgesToBeRemoved);
                for (Collaborator currentCoAuthor : currentBiboDocumentEntry.getValue()) {
                    currentCoAuthor.getCollaboratorActivities().remove(currentBiboDocument);
                    if (!currentCoAuthor.getCollaboratorActivities().isEmpty()) continue;
                    nodesToBeRemoved.add(currentCoAuthor);
                }
            }
            nodes.removeAll(nodesToBeRemoved);
        }
    }
}

