/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CounterUtils {
    public static final List<List<Integer>> getObjectCountByYear(Set<String> objects, Map<String, String> objectToYearMap) {
        ArrayList<List<Integer>> yearCounts = new ArrayList<List<Integer>>();
        if (objects != null) {
            int[] counts = new int[Calendar.getInstance().get(1) + 1000];
            for (String publication : objects) {
                int year = 0;
                try {
                    year = Integer.parseInt(objectToYearMap.get(publication), 10);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (year > counts.length - 1) {
                    year = 0;
                }
                int n = year;
                counts[n] = counts[n] + 1;
            }
            for (int i = 1; i < counts.length; ++i) {
                if (counts[i] <= 0) continue;
                ArrayList<Integer> currentYear = new ArrayList<Integer>();
                currentYear.add(i);
                currentYear.add(counts[i]);
                yearCounts.add(currentYear);
            }
            if (counts[0] > 0) {
                ArrayList<Integer> currentYear = new ArrayList<Integer>();
                currentYear.add(-1);
                currentYear.add(counts[0]);
                yearCounts.add(currentYear);
            }
        }
        return yearCounts;
    }
}

