/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.utilities;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class OrgUtils {
    public static Map<String, String> getParentURIsToLabel(String org, Map<String, Set<String>> subOrgMap, Map<String, String> orgLabelMap) {
        TreeMap<String, String> parentURIsToLabel = new TreeMap<String, String>();
        if (!StringUtils.isEmpty((String)org)) {
            for (Map.Entry<String, Set<String>> orgMapEntry : subOrgMap.entrySet()) {
                Set<String> subOrgs = orgMapEntry.getValue();
                if (subOrgs == null || !subOrgs.contains(org) || !orgLabelMap.containsKey(orgMapEntry.getKey())) continue;
                parentURIsToLabel.put(orgMapEntry.getKey(), orgLabelMap.get(orgMapEntry.getKey()));
            }
        }
        return parentURIsToLabel;
    }

    public static void getObjectMappingsForOrgAndSubOrgs(String orgUri, Set<String> orgObjects, Set<String> orgObjectsIncludesPeople, Map<String, Set<String>> subOrgObjectMap, Map<String, Set<String>> subOrgMap, Map<String, Set<String>> organisationToPeopleMap, Map<String, Set<String>> personToObjectMap) {
        Set<String> people;
        if (subOrgMap.containsKey(orgUri)) {
            for (String topSubOrg : subOrgMap.get(orgUri)) {
                HashSet subOrgPublications = new HashSet();
                HashSet<String> subOrgPublicationsPeople = new HashSet<String>();
                Set<String> fullSubOrgs = OrgUtils.orgAndAllSubOrgs(new HashSet<String>(), topSubOrg, subOrgMap);
                for (String subOrg : fullSubOrgs) {
                    Set<String> peopleInSubOrg = organisationToPeopleMap.get(subOrg);
                    if (peopleInSubOrg == null) continue;
                    for (String person : peopleInSubOrg) {
                        if (!personToObjectMap.containsKey(person) || !subOrgPublicationsPeople.add(person)) continue;
                        subOrgPublications.addAll(personToObjectMap.get(person));
                        if (!orgObjectsIncludesPeople.add(person)) continue;
                        orgObjects.addAll((Collection<String>)personToObjectMap.get(person));
                    }
                }
                subOrgObjectMap.put(topSubOrg, subOrgPublications);
            }
        }
        if ((people = organisationToPeopleMap.get(orgUri)) != null) {
            for (String person : people) {
                if (!orgObjectsIncludesPeople.add(person) || !personToObjectMap.containsKey(person)) continue;
                orgObjects.addAll((Collection<String>)personToObjectMap.get(person));
            }
        }
    }

    private static Set<String> orgAndAllSubOrgs(Set<String> allSubOrgs, String org, Map<String, Set<String>> subOrgMap) {
        if (allSubOrgs.add(org) && subOrgMap.containsKey(org)) {
            for (String subOrg : subOrgMap.get(org)) {
                OrgUtils.orgAndAllSubOrgs(allSubOrgs, subOrg, subOrgMap);
            }
        }
        return allSubOrgs;
    }
}

