/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.visutils;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class PDFDocument {
    static Stroke stroke = new BasicStroke(5.0f, 1, 1);
    static final Color bg = Color.green;
    static final Color fg = Color.black;

    public PDFDocument(String authorName, Map<String, Integer> yearToPublicationCount, Document document, PdfWriter pdfWriter) {
        try {
            document.addTitle("PDF Pipeline iText Prototype");
            document.addAuthor(authorName);
            document.addSubject("This example tests text, color, image, transparency & table functionality.");
            document.addKeywords("text, color, image, transparency, table");
            document.addCreator("Standalone PDF Renderer using iText");
            Paragraph header = new Paragraph();
            Font pageHeaderStyle = FontFactory.getFont((String)"Times-Roman", (float)15.0f, (int)7);
            Font featureHeaderStyle = FontFactory.getFont((String)"Times-Roman", (float)10.0f, (BaseColor)new BaseColor(Color.red));
            header.add((Element)new Chunk("PDF Pipeline Prototype v2 using iText\n", pageHeaderStyle));
            header.setSpacingAfter(15.0f);
            document.add((Element)header);
            Paragraph content = new Paragraph();
            content.add((Element)new Chunk("Publication Count - Author Name - " + authorName, featureHeaderStyle));
            content.setSpacingAfter(15.0f);
            document.add((Element)content);
            PdfPTable publicationCount = this.createTable(yearToPublicationCount);
            document.add((Element)publicationCount);
            content = new Paragraph();
            content.add((Element)new Chunk("Transparency of Shapes", featureHeaderStyle));
            content.setSpacingAfter(15.0f);
            document.add((Element)content);
            this.createTransparencyShapes(document, pdfWriter);
            this.createImage(document, pdfWriter, featureHeaderStyle);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createImage(Document document, PdfWriter writer, Font featureHeaderStyle) throws BadElementException, MalformedURLException, IOException, DocumentException {
        Image imageSprite = Image.getInstance((URL)new URL("http://lh3.ggpht.com/_4msVPAgKJv8/SCRYD-pPVKI/AAAAAAAAAYU/zUN963EPoZc/s1024/102_0609.JPG"));
        imageSprite.setAbsolutePosition(400.0f, 500.0f);
        imageSprite.scaleAbsolute(171.0f, 250.0f);
        float imageSpriteY = document.getPageSize().getHeight() * 0.6f;
        float imageSpriteX = document.getPageSize().getWidth() * 0.65f;
        imageSprite.setAlignment(8);
        document.add((Element)imageSprite);
        PdfContentByte cb = writer.getDirectContent();
        ColumnText ct = new ColumnText(cb);
        Chunk imageHeader = new Chunk("Images", featureHeaderStyle);
        ct.addText(imageHeader);
        ct.setAlignment(0);
        ct.setSimpleColumn(imageSpriteX, imageSpriteY - imageSprite.getScaledHeight(), imageSpriteX + imageSprite.getScaledWidth(), imageSpriteY + imageSprite.getScaledHeight() + 20.0f);
        ct.go();
        ct = new ColumnText(cb);
        Chunk imageFooter = new Chunk("Footer to be set for a figure. Similar to 'image cpation'.", FontFactory.getFont((String)"Times-Roman", (float)8.0f));
        ct.addText(imageFooter);
        ct.setAlignment(1);
        ct.setSimpleColumn(imageSpriteX, imageSpriteY - 150.0f, imageSpriteX + imageSprite.getScaledWidth(), imageSpriteY);
        ct.go();
    }

    private void createTransparencyShapes(Document document, PdfWriter writer) throws Exception {
        PdfContentByte cb = writer.getDirectContent();
        this.pictureBackdrop(document.leftMargin(), 350.0f, cb);
        cb.saveState();
        PdfGState gs1 = new PdfGState();
        gs1.setFillOpacity(0.5f);
        cb.setGState(gs1);
        this.pictureCircles(document.leftMargin(), 350.0f, cb);
        cb.restoreState();
        cb.resetRGBColorFill();
    }

    public void pictureBackdrop(float x, float y, PdfContentByte cb) throws Exception {
        cb.setColorStroke(new BaseColor(Color.black));
        cb.setColorFill(new BaseColor(Color.gray));
        cb.rectangle(x, y, 100.0f, 200.0f);
        cb.fill();
        cb.setLineWidth(2.0f);
        cb.rectangle(x, y, 200.0f, 200.0f);
        cb.stroke();
    }

    public void pictureCircles(float x, float y, PdfContentByte cb) throws Exception {
        cb.saveState();
        PdfGState gs1 = new PdfGState();
        gs1.setFillOpacity(1.0f);
        cb.setGState(gs1);
        cb.setColorFill(new BaseColor(Color.red));
        cb.circle(x + 70.0f, y + 70.0f, 50.0f);
        cb.fill();
        cb.restoreState();
        cb.setColorFill(new BaseColor(Color.yellow));
        cb.circle(x + 100.0f, y + 130.0f, 50.0f);
        cb.fill();
        cb.setColorFill(new BaseColor(Color.blue));
        cb.circle(x + 130.0f, y + 70.0f, 50.0f);
        cb.fill();
    }

    private PdfPTable createTable(Map<String, Integer> yearToPublicationCount) {
        Font normalContentStyle = FontFactory.getFont((String)"Times-Roman", (float)11.0f);
        Font summaryContentStyle = FontFactory.getFont((String)"Times-Roman", (float)11.0f, (int)3);
        BaseColor summaryBackgroundColor = new BaseColor(238, 238, 238);
        BaseColor headerBackgroundColor = new BaseColor(195, 217, 255);
        BaseColor bodyBackgroundColor = new BaseColor(Color.white);
        PdfPTable table = new PdfPTable(2);
        table.setWidthPercentage(36.0f);
        table.setHorizontalAlignment(0);
        table.getDefaultCell().setBorderWidth(0.0f);
        table.setHeaderRows(2);
        PdfPCell cell = new PdfPCell(new Phrase("Publications per year", normalContentStyle));
        this.setTableCaptionStyle(summaryBackgroundColor, cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("Year", normalContentStyle));
        this.setTableHeaderStyle(headerBackgroundColor, cell);
        table.addCell(cell);
        cell.setPhrase(new Phrase("Publications", normalContentStyle));
        table.addCell(cell);
        this.setTableBodyStyle(bodyBackgroundColor, cell);
        int totalPublications = 0;
        for (Map.Entry<String, Integer> currentEntry : yearToPublicationCount.entrySet()) {
            cell.setPhrase(new Phrase(currentEntry.getKey(), normalContentStyle));
            table.addCell(cell);
            cell.setPhrase(new Phrase(currentEntry.getValue().toString(), normalContentStyle));
            table.addCell(cell);
            totalPublications += currentEntry.getValue().intValue();
        }
        this.setTableFooterStyle(summaryBackgroundColor, cell);
        cell.setPhrase(new Phrase("Total", summaryContentStyle));
        table.addCell(cell);
        cell.setPhrase(new Phrase(String.valueOf(totalPublications), summaryContentStyle));
        table.addCell(cell);
        return table;
    }

    private void setTableFooterStyle(BaseColor footerBackgroundColor, PdfPCell cell) {
        cell.setBorderWidth(0.0f);
        cell.setBackgroundColor(footerBackgroundColor);
        cell.setHorizontalAlignment(1);
        cell.setPaddingTop(5.0f);
        cell.setPaddingRight(10.0f);
        cell.setPaddingBottom(5.0f);
        cell.setPaddingLeft(10.0f);
    }

    private void setTableBodyStyle(BaseColor bodyBackgroundColor, PdfPCell cell) {
        cell.setBorderWidth(0.0f);
        cell.setBackgroundColor(bodyBackgroundColor);
        cell.setHorizontalAlignment(1);
        cell.setPaddingTop(5.0f);
        cell.setPaddingRight(10.0f);
        cell.setPaddingBottom(5.0f);
        cell.setPaddingLeft(10.0f);
    }

    private void setTableHeaderStyle(BaseColor headerBackgroundColor, PdfPCell cell) {
        cell.setBorderWidth(0.0f);
        cell.setBackgroundColor(headerBackgroundColor);
        cell.setHorizontalAlignment(1);
        cell.setPaddingTop(5.0f);
        cell.setPaddingRight(10.0f);
        cell.setPaddingBottom(5.0f);
        cell.setPaddingLeft(10.0f);
    }

    private void setTableCaptionStyle(BaseColor summaryBackgroundColor, PdfPCell cell) {
        cell.setBorderWidth(0.0f);
        cell.setBackgroundColor(summaryBackgroundColor);
        cell.setHorizontalAlignment(1);
        cell.setPaddingTop(5.0f);
        cell.setPaddingRight(10.0f);
        cell.setPaddingBottom(5.0f);
        cell.setPaddingLeft(10.0f);
        cell.setColspan(2);
    }
}

