/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class GrantChecker
extends RelationshipChecker {
    private static final String URI_GRANT_TYPE = "http://vivoweb.org/ontology/core#Grant";
    private static final String URI_PI_ROLE_TYPE = "http://vivoweb.org/ontology/core#PrincipalInvestigatorRole";
    private static final String URI_CO_PI_ROLE_TYPE = "http://vivoweb.org/ontology/core#CoPrincipalInvestigatorRole";
    private final String[] resourceUris;

    public GrantChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (!this.isGrant(resourceUri)) continue;
            if (this.anyUrisInCommon(userUris, this.getUrisOfPrincipalInvestigators(resourceUri))) {
                return this.authorizedPI(resourceUri);
            }
            if (!this.anyUrisInCommon(userUris, this.getUrisOfCoPrincipalInvestigators(resourceUri))) continue;
            return this.authorizedCoPI(resourceUri);
        }
        return null;
    }

    private boolean isGrant(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_GRANT_TYPE);
    }

    private List<String> getUrisOfPrincipalInvestigators(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://vivoweb.org/ontology/core#relates", URI_PI_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private List<String> getUrisOfCoPrincipalInvestigators(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://vivoweb.org/ontology/core#relates", URI_CO_PI_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private PolicyDecision authorizedPI(String resourceUri) {
        return this.authorizedDecision("User is Principal Investigator of " + resourceUri);
    }

    private PolicyDecision authorizedCoPI(String resourceUri) {
        return this.authorizedDecision("User is Co-Principal Investigator of " + resourceUri);
    }
}

