/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class PresentationChecker
extends RelationshipChecker {
    private static final String URI_PRESENTATION_TYPE = "http://vivoweb.org/ontology/core#Presentation";
    private static final String URI_PRESENTER_ROLE_TYPE = "http://vivoweb.org/ontology/core#PresenterRole";
    private final String[] resourceUris;

    public PresentationChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (!this.isPresentation(resourceUri) || !this.anyUrisInCommon(userUris, this.getUrisOfPresenters(resourceUri))) continue;
            return this.authorizedPresenter(resourceUri);
        }
        return null;
    }

    private boolean isPresentation(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_PRESENTATION_TYPE);
    }

    private List<String> getUrisOfPresenters(String resourceUri) {
        return this.getObjectsThroughLinkingNode(resourceUri, "http://purl.obolibrary.org/obo/BFO_0000055", URI_PRESENTER_ROLE_TYPE, "http://purl.obolibrary.org/obo/RO_0000052");
    }

    private PolicyDecision authorizedPresenter(String resourceUri) {
        return this.authorizedDecision("User is a Presenter of " + resourceUri);
    }
}

