/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.orcid.controller;

import edu.cornell.mannlib.orcidclient.OrcidClientException;
import edu.cornell.mannlib.orcidclient.actions.AddExternalIdAction;
import edu.cornell.mannlib.orcidclient.actions.ApiAction;
import edu.cornell.mannlib.orcidclient.auth.AuthorizationStatus;
import edu.cornell.mannlib.orcidclient.beans.ExternalId;
import edu.cornell.mannlib.orcidclient.orcidmessage.OrcidMessage;
import edu.cornell.mannlib.orcidclient.orcidmessage.Visibility;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidAbstractHandler;
import edu.cornell.mannlib.vivo.orcid.controller.OrcidConfirmationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrcidAddExternalIdHandler
extends OrcidAbstractHandler {
    private static final Log log = LogFactory.getLog(OrcidAddExternalIdHandler.class);
    private AuthorizationStatus status;
    private OrcidMessage profile;

    protected OrcidAddExternalIdHandler(VitroRequest vreq) {
        super(vreq);
    }

    public ResponseValues exec() throws OrcidClientException {
        this.status = this.auth.getAuthorizationStatus(ApiAction.ADD_EXTERNAL_ID);
        if (this.status.isSuccess()) {
            this.addVivoId();
            return this.showConfirmationPage(OrcidConfirmationState.Progress.ADDED_ID, this.profile);
        }
        if (this.status.isDenied()) {
            return this.showConfirmationPage(OrcidConfirmationState.Progress.DENIED_ID, new OrcidMessage[0]);
        }
        return this.showConfirmationPage(OrcidConfirmationState.Progress.FAILED_ID, new OrcidMessage[0]);
    }

    private void addVivoId() throws OrcidClientException {
        Individual individual = this.findIndividual();
        ExternalId externalId = new ExternalId().setCommonName("VIVO Cornell").setReference(individual.getLocalName()).setUrl(individual.getURI()).setVisibility(Visibility.PUBLIC);
        log.debug((Object)"Adding external VIVO ID");
        this.profile = new AddExternalIdAction().execute(externalId, this.status.getAccessToken());
    }
}

