/*
 * Decompiled with CFR 0.152.
 */
package org.vivoweb.webapp.startup;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.individuallist.IndividualJsonWrapper;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWrapperSetup
implements ServletContextListener {
    private static final Log log = LogFactory.getLog(JSONWrapperSetup.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        IndividualJsonWrapper.setAddJSONFields((IndividualJsonWrapper.AddJSONFields)new IndividualJsonWrapper.AddJSONFields(){
            private String VCARD_DATA_QUERY = "PREFIX obo: <http://purl.obolibrary.org/obo/> \nPREFIX vcard: <http://www.w3.org/2006/vcard/ns#>  \nSELECT DISTINCT ?title  \nWHERE {  \n    ?subject obo:ARG_2000028 ?vIndividual .  \n    ?vIndividual vcard:hasTitle ?vTitle . \n    ?vTitle vcard:title ?title . \n} ";

            public void add(JSONObject jo, VitroRequest vreq, Individual ind) throws JSONException {
                jo.put("preferredTitle", (Object)this.findPreferredTitle(vreq, ind));
            }

            private String findPreferredTitle(VitroRequest vreq, Individual ind) {
                String queryStr = QueryUtils.subUriForQueryVar((String)this.VCARD_DATA_QUERY, (String)"subject", (String)ind.getURI());
                log.debug((Object)("queryStr = " + queryStr));
                String value = "";
                try {
                    ResultSet results = QueryUtils.getQueryResults((String)queryStr, (VitroRequest)vreq);
                    while (results.hasNext()) {
                        QuerySolution soln = results.nextSolution();
                        String t = QueryUtils.nodeToString((RDFNode)soln.get("title"));
                        if (!StringUtils.isNotBlank((String)t)) continue;
                        value = t;
                    }
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
                return value;
            }
        });
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

