/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.semservices.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.cornell.mannlib.semservices.bo.Concept;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SKOSUtils {
    protected static final Log log = LogFactory.getLog(SKOSUtils.class);

    public static String getConceptXML(String conceptUriString) {
        URL conceptURL = null;
        try {
            conceptURL = new URL(conceptUriString);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred in instantiating URL for " + conceptUriString), (Throwable)e);
            return null;
        }
        log.debug((Object)("loading concept uri " + conceptUriString));
        String results = null;
        try {
            String inputLine;
            StringWriter sw = new StringWriter();
            BufferedReader in = new BufferedReader(new InputStreamReader(conceptURL.openStream()));
            while ((inputLine = in.readLine()) != null) {
                sw.write(inputLine);
            }
            in.close();
            results = sw.toString();
            log.debug((Object)results);
        }
        catch (Exception ex) {
            log.error((Object)("Error occurred in getting concept from the URL " + conceptUriString), (Throwable)ex);
            return null;
        }
        return results;
    }

    public static Concept createConceptUsingXMLFromURL(Concept concept, String conceptURLString, String langTagValue, boolean addNotes) {
        String results = SKOSUtils.getConceptXML(conceptURLString);
        if (StringUtils.isEmpty((String)results)) {
            return null;
        }
        return SKOSUtils.createConceptUsingXMLModel(concept, results, langTagValue, addNotes);
    }

    public static List<String> removeConceptURIFromList(List<String> uris, String conceptURI) {
        while (uris.remove(conceptURI)) {
        }
        return uris;
    }

    public static Concept createConceptUsingXMLModel(Concept concept, String results, String langTagValue, boolean addNotes) {
        try {
            List<String> notes;
            String conceptURI = concept.getUri();
            StringReader reader = new StringReader(results);
            Model model = ModelFactory.createDefaultModel();
            model.read((Reader)reader, null, "RDF/XML");
            List<String> labelLiterals = SKOSUtils.getPrefLabelsFromModel(conceptURI, model, langTagValue);
            if (labelLiterals.size() > 0) {
                concept.setLabel(labelLiterals.get(0));
            } else {
                log.debug((Object)"The number of preferred labels is not greater than zero");
            }
            List<String> altLabelList = SKOSUtils.getAltLabelsFromModel(conceptURI, model, langTagValue);
            concept.setAltLabelList(altLabelList);
            List<String> broaderURIList = SKOSUtils.getBroaderURIsFromModel(conceptURI, model);
            concept.setBroaderURIList(broaderURIList);
            List<String> narrowerURIList = SKOSUtils.getNarrowerURIsFromModel(conceptURI, model);
            concept.setNarrowerURIList(narrowerURIList);
            List<String> exactMatchURIList = SKOSUtils.getExactMatchURIsFromModel(conceptURI, model);
            concept.setExactMatchURIList(exactMatchURIList);
            List<String> closeMatchURIList = SKOSUtils.getCloseMatchURIsFromModel(conceptURI, model);
            concept.setCloseMatchURIList(closeMatchURIList);
            if (addNotes && (notes = SKOSUtils.getNotesFromModel(conceptURI, model, langTagValue)).size() > 0) {
                concept.setDefinition(notes.get(0));
            }
        }
        catch (Exception e) {
            log.error((Object)("error occurred in parsing " + results), (Throwable)e);
        }
        return concept;
    }

    private static List<String> getPrefLabelsFromModel(String conceptURI, Model model, String langTagValue) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#prefLabel";
        return SKOSUtils.getLabelsFromModel(conceptURI, propertyURI, model, langTagValue);
    }

    private static List<String> getAltLabelsFromModel(String conceptURI, Model model, String langTagValue) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#altLabel";
        return SKOSUtils.getLabelsFromModel(conceptURI, propertyURI, model, langTagValue);
    }

    private static List<String> getLabelsFromModel(String conceptURI, String propertyURI, Model model, String langTagValue) {
        ArrayList<String> labels = new ArrayList<String>();
        StmtIterator statements = model.listStatements(ResourceFactory.createResource((String)conceptURI), ResourceFactory.createProperty((String)propertyURI), (RDFNode)null);
        while (statements.hasNext()) {
            Statement statement = statements.nextStatement();
            RDFNode node = statement.getObject();
            if (node == null || !node.isLiteral()) continue;
            String label = node.asLiteral().getString();
            if (StringUtils.isNotEmpty((String)langTagValue)) {
                String language = node.asLiteral().getLanguage();
                if (language == null || !language.equals(langTagValue)) continue;
                labels.add(label);
                continue;
            }
            labels.add(label);
        }
        return labels;
    }

    private static List<String> getNotesFromModel(String conceptURI, Model model, String langTagValue) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#note";
        return SKOSUtils.getLabelsFromModel(conceptURI, propertyURI, model, langTagValue);
    }

    private static List<String> getCloseMatchURIsFromModel(String conceptURI, Model model) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#closeMatch";
        return SKOSUtils.getRelatedURIsFromModel(conceptURI, propertyURI, model);
    }

    private static List<String> getExactMatchURIsFromModel(String conceptURI, Model model) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#exactMatch";
        return SKOSUtils.getRelatedURIsFromModel(conceptURI, propertyURI, model);
    }

    private static List<String> getNarrowerURIsFromModel(String conceptURI, Model model) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#narrower";
        return SKOSUtils.getRelatedURIsFromModel(conceptURI, propertyURI, model);
    }

    private static List<String> getBroaderURIsFromModel(String conceptURI, Model model) {
        String propertyURI = "http://www.w3.org/2004/02/skos/core#broader";
        return SKOSUtils.getRelatedURIsFromModel(conceptURI, propertyURI, model);
    }

    private static List<String> getRelatedURIsFromModel(String conceptURI, String propertyURI, Model model) {
        ArrayList<String> URIs = new ArrayList<String>();
        NodeIterator nodeIterator = model.listObjectsOfProperty(ResourceFactory.createResource((String)conceptURI), ResourceFactory.createProperty((String)propertyURI));
        while (nodeIterator.hasNext()) {
            RDFNode node = nodeIterator.nextNode();
            if (!node.isResource() || node.asResource().getURI() == null) continue;
            String URI2 = node.asResource().getURI();
            URIs.add(URI2);
        }
        return URIs;
    }
}

