/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.VivoBaseGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddFullNameToPersonGenerator
extends VivoBaseGenerator
implements EditConfigurationGenerator {
    private Log log = LogFactory.getLog(AddFullNameToPersonGenerator.class);
    static final String n3ForNewName = "?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?person . \n?individualVcard <http://www.w3.org/2006/vcard/ns#hasName> ?fullName . \n?fullName a <http://www.w3.org/2006/vcard/ns#Name> . ";
    static final String firstNameAssertion = "?fullName <http://www.w3.org/2006/vcard/ns#givenName> ?firstName .";
    static final String middleNameAssertion = "?fullName <http://vivoweb.org/ontology/core#middleName> ?middleName .";
    static final String lastNameAssertion = "?fullName <http://www.w3.org/2006/vcard/ns#familyName> ?lastName .";
    static final String suffixAssertion = "?fullName <http://www.w3.org/2006/vcard/ns#honorificSuffix> ?suffix .";
    static final String prefixAssertion = "?fullName <http://www.w3.org/2006/vcard/ns#honorificPrefix> ?prefix .";
    static final String individualVcardQuery = "SELECT ?existingIndividualVcard WHERE { \n?person <http://purl.obolibrary.org/obo/ARG_2000028>  ?existingIndividualVcard . \n}";
    static final String firstNameQuery = "SELECT ?existingFirstName WHERE {\n?fullName <http://www.w3.org/2006/vcard/ns#givenName> ?existingFirstName . }";
    static final String middleNameQuery = "SELECT ?existingMiddleName WHERE {\n?fullName <http://vivoweb.org/ontology/core#middleName> ?existingMiddleName . }";
    static final String lastNameQuery = "SELECT ?existingLastName WHERE {\n?fullName <http://www.w3.org/2006/vcard/ns#familyName> ?existingLastName . }";
    static final String suffixQuery = "SELECT ?existingSuffix WHERE {\n?fullName <http://www.w3.org/2006/vcard/ns#honorificSuffix> ?existingSuffix . }";
    static final String prefixQuery = "SELECT ?existingPrefix WHERE {\n?fullName <http://www.w3.org/2006/vcard/ns#honorificPrefix> ?existingPrefix . }";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) throws Exception {
        EditConfigurationVTwo conf = new EditConfigurationVTwo();
        this.initBasics(conf, vreq);
        this.initPropertyParameters(vreq, session, conf);
        this.initObjectPropForm(conf, vreq);
        String fullNameUri = this.getFullNameUri(vreq);
        conf.setTemplate("addFullNameToPerson.ftl");
        conf.setVarNameForSubject("person");
        conf.setVarNameForPredicate("predicate");
        conf.setVarNameForObject("individualVcard");
        conf.setN3Required(Arrays.asList(n3ForNewName));
        conf.setN3Optional(Arrays.asList(firstNameAssertion, middleNameAssertion, lastNameAssertion, suffixAssertion, prefixAssertion));
        conf.addNewResource("fullName", "");
        conf.addNewResource("individualVcard", "");
        conf.setLiteralsOnForm(Arrays.asList("firstName", "middleName", "lastName", "suffix", "prefix"));
        conf.addSparqlForExistingLiteral("firstName", firstNameQuery);
        conf.addSparqlForExistingLiteral("middleName", middleNameQuery);
        conf.addSparqlForExistingLiteral("lastName", lastNameQuery);
        conf.addSparqlForExistingLiteral("suffix", suffixQuery);
        conf.addSparqlForExistingLiteral("prefix", prefixQuery);
        conf.addSparqlForAdditionalUrisInScope("individualVcard", individualVcardQuery);
        if (conf.isUpdate()) {
            HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
            urisInScope.put("fullName", Arrays.asList(fullNameUri));
            conf.addUrisInScope(urisInScope);
        }
        conf.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(AddFullNameToPersonGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("middleName").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.toString()).setValidators(AddFullNameToPersonGenerator.list((Object[])new Object[]{"nonempty"})));
        conf.addField(new FieldVTwo().setName("suffix").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addField(new FieldVTwo().setName("prefix").setRangeDatatypeUri(XSD.xstring.toString()));
        conf.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        this.prepare(vreq, conf);
        return conf;
    }

    private String getFullNameUri(VitroRequest vreq) {
        String fullNameUri = vreq.getParameter("fullNameUri");
        return fullNameUri;
    }
}

