/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.RequestedAction;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AddObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.dao.jena.QueryUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditSubmissionVTwoPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.ManageLabelsForIndividualGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.FoafNameToRdfsLabelPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ManageLabelsForPersonPreprocessor;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.preprocessors.ModelChangePreprocessor;
import edu.cornell.mannlib.vitro.webapp.i18n.selection.SelectedLocale;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.DataPropertyStatementTemplateModel;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManageLabelsForPersonGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    public static Log log = LogFactory.getLog(ManageLabelsForIndividualGenerator.class);
    private static String template = "manageLabelsForIndividual.ftl";
    private HashMap<String, List<LabelInformation>> labelsSortedByLanguage = null;
    private List<Literal> existingLabelLiterals = null;
    private static String LABEL_QUERY = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nSELECT DISTINCT ?label WHERE { \n    ?subject rdfs:label ?label \n} ORDER BY ?label";
    private String N3_PREFIX = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setTemplate(this.getTemplate());
        this.initBasics(config, vreq);
        this.initPropertyParameters(vreq, session, config);
        this.initObjectPropForm(config, vreq);
        this.setUrlToReturnTo(config, vreq);
        config.setSubjectUri(EditConfigurationUtils.getSubjectUri((VitroRequest)vreq));
        this.setVarNames(config);
        config.setN3Required(this.generateN3Required(vreq));
        config.setN3Optional(this.generateN3Optional(vreq));
        this.addNewResources(config);
        this.setUrisAndLiteralsOnForm(config, vreq);
        this.setUrisAndLiteralsInScope(config);
        this.setFields(config, vreq, EditConfigurationUtils.getPredicateUri((VitroRequest)vreq));
        this.addFormSpecificData(config, vreq);
        config.addEditSubmissionPreprocessor((EditSubmissionVTwoPreprocessor)new ManageLabelsForPersonPreprocessor(config));
        config.addModelChangePreprocessor((ModelChangePreprocessor)new FoafNameToRdfsLabelPreprocessor());
        this.prepare(vreq, config);
        return config;
    }

    private void addNewResources(EditConfigurationVTwo config) {
        config.addNewResource("fullName", "");
        config.addNewResource("individualVcard", "");
    }

    private void setUrlToReturnTo(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        editConfiguration.setUrlPatternToReturnTo(EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq));
    }

    private void setVarNames(EditConfigurationVTwo editConfiguration) {
        editConfiguration.setVarNameForSubject("subject");
        editConfiguration.setVarNameForPredicate("predicate");
    }

    private List<String> generateN3Required(VitroRequest vreq) {
        ArrayList<String> n3Required = new ArrayList<String>();
        return n3Required;
    }

    private List<String> generateN3Optional(VitroRequest vreq) {
        ArrayList<String> n3Optional = new ArrayList<String>();
        String personFullNameN3 = this.N3_PREFIX + "?subject <http://purl.obolibrary.org/obo/ARG_2000028>  ?individualVcard . \n" + "?individualVcard a <http://www.w3.org/2006/vcard/ns#Individual> . \n" + "?individualVcard <http://purl.obolibrary.org/obo/ARG_2000029> ?subject . \n" + "?individualVcard <http://www.w3.org/2006/vcard/ns#hasName> ?fullName . \n" + "?fullName a <http://www.w3.org/2006/vcard/ns#Name> .";
        String personFirstNameN3 = "?fullName <http://www.w3.org/2006/vcard/ns#givenName> ?firstName . ";
        String personLastNameN3 = "?fullName <http://www.w3.org/2006/vcard/ns#familyName> ?lastName .";
        String personMiddleNameN3 = "?subject <http://vivoweb.org/ontology/core#middleName> ?middleName .";
        n3Optional.add(personFullNameN3 + "\n " + personFirstNameN3 + "\n " + personLastNameN3);
        n3Optional.add(personMiddleNameN3);
        return n3Optional;
    }

    private void setFields(EditConfigurationVTwo editConfiguration, VitroRequest vreq, String predicateUri) {
        HashMap fields = new HashMap();
        editConfiguration.setFields(fields);
        editConfiguration.addField(new FieldVTwo().setName("newLabelLanguage"));
        editConfiguration.addField(new FieldVTwo().setName("firstName").setValidators(this.getFirstNameValidators(vreq, editConfiguration)));
        editConfiguration.addField(new FieldVTwo().setName("middleName").setValidators(this.getMiddleNameValidators(vreq, editConfiguration)));
        editConfiguration.addField(new FieldVTwo().setName("lastName").setValidators(this.getLastNameValidators(vreq, editConfiguration)));
    }

    private List<String> getFirstNameValidators(VitroRequest vreq, EditConfigurationVTwo config) {
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        return validators;
    }

    private List<String> getMiddleNameValidators(VitroRequest vreq, EditConfigurationVTwo config) {
        ArrayList<String> validators = new ArrayList<String>();
        return validators;
    }

    private List<String> getLastNameValidators(VitroRequest vreq, EditConfigurationVTwo config) {
        ArrayList<String> validators = new ArrayList<String>();
        validators.add("nonempty");
        return validators;
    }

    private void setUrisAndLiteralsOnForm(EditConfigurationVTwo config, VitroRequest vreq) {
        ArrayList<String> literalsOnForm = new ArrayList<String>();
        literalsOnForm.add("newLabelLanguage");
        literalsOnForm.add("firstName");
        literalsOnForm.add("lastName");
        literalsOnForm.add("middleName");
        config.setLiteralsOnForm(literalsOnForm);
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap());
    }

    private void initExistingLabels(EditConfigurationVTwo config, VitroRequest vreq) {
        this.existingLabelLiterals = this.getExistingLabels(config.getSubjectUri(), vreq);
    }

    private List<String> getExistingSortedLanguageNamesList() {
        HashSet<String> existingLanguages = new HashSet<String>();
        for (Literal l : this.existingLabelLiterals) {
            String language = l.getLanguage();
            if (existingLanguages.contains(language)) continue;
            existingLanguages.add(language);
        }
        ArrayList<String> sortedNames = new ArrayList<String>(existingLanguages);
        Collections.sort(sortedNames);
        return sortedNames;
    }

    private void addFormSpecificData(EditConfigurationVTwo config, VitroRequest vreq) {
        List<HashMap<String, String>> locales = this.getLocales(vreq);
        HashMap<String, String> localeCodeToNameMap = this.getFullCodeToLanguageNameMap(locales);
        ArrayList<Literal> existingLabels = this.getExistingLabels(config.getSubjectUri(), vreq);
        int numberExistingLabels = existingLabels.size();
        HashMap<String, List<LabelInformation>> existingLabelsByLanguageName = this.getLabelsSortedByLanguageName(existingLabels, localeCodeToNameMap, config, vreq);
        HashSet<String> existingLanguageNames = new HashSet<String>(existingLabelsByLanguageName.keySet());
        List<HashMap<String, String>> availableLocalesForAdd = this.getAvailableLocales(locales, existingLanguageNames);
        config.addFormSpecificData("selectLocaleFullList", locales);
        config.addFormSpecificData("labelsSortedByLanguageName", existingLabelsByLanguageName);
        config.addFormSpecificData("selectLocale", availableLocalesForAdd);
        config.addFormSpecificData("displayRemoveLink", (Object)(numberExistingLabels > 1 ? 1 : 0));
        config.addFormSpecificData("deleteWebpageUrl", (Object)"/edit/primitiveDelete");
        Individual subject = vreq.getWebappDaoFactory().getIndividualDao().getIndividualByURI(config.getSubjectUri());
        if (subject != null && subject.getName() != null) {
            config.addFormSpecificData("subjectName", (Object)subject.getName());
        } else {
            config.addFormSpecificData("subjectName", null);
        }
        config.addFormSpecificData("isPersonType", (Object)"true");
        config.addFormSpecificData("editable", this.isEditable(vreq, config));
    }

    private List<HashMap<String, String>> getAvailableLocales(List<HashMap<String, String>> allLocales, HashSet<String> existingLabelsLanguageNames) {
        ArrayList<HashMap<String, String>> availableLocales = new ArrayList<HashMap<String, String>>();
        for (HashMap<String, String> localeInfo : allLocales) {
            String languageName = localeInfo.get("label");
            if (languageName == "untyped" || existingLabelsLanguageNames.contains(languageName)) continue;
            availableLocales.add(localeInfo);
        }
        Collections.sort(availableLocales, new Comparator<HashMap<String, String>>(){

            @Override
            public int compare(HashMap<String, String> h1, HashMap<String, String> h2) {
                String languageName1 = h1.get("label");
                String languageName2 = h2.get("label");
                return languageName1.compareTo(languageName2);
            }
        });
        return availableLocales;
    }

    private Object isEditable(VitroRequest vreq, EditConfigurationVTwo config) {
        Individual individual = EditConfigurationUtils.getIndividual((VitroRequest)vreq, (String)config.getSubjectUri());
        AddDataPropertyStatement adps = new AddDataPropertyStatement(vreq.getJenaOntModel(), individual.getURI(), RequestedAction.SOME_URI, RequestedAction.SOME_LITERAL);
        AddObjectPropertyStatement aops = new AddObjectPropertyStatement(vreq.getJenaOntModel(), individual.getURI(), RequestedAction.SOME_PREDICATE, RequestedAction.SOME_URI);
        return PolicyHelper.isAuthorizedForActions((HttpServletRequest)vreq, (AuthorizationRequest[])new AuthorizationRequest[]{adps.or((AuthorizationRequest)aops)});
    }

    public String getFOAFPersonClassURI() {
        return "http://xmlns.com/foaf/0.1/Person";
    }

    public boolean isPersonType(VitroRequest vreq, EditConfigurationVTwo config) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        Boolean isPersonType = Boolean.FALSE;
        String foafPersonType = this.getFOAFPersonClassURI();
        List<VClass> vclasses = this.getVClasses(config, vreq);
        if (vclasses != null) {
            for (VClass v : vclasses) {
                String typeUri = v.getURI();
                if (!foafPersonType.equals(typeUri)) continue;
                isPersonType = Boolean.TRUE;
                break;
            }
        }
        return isPersonType;
    }

    public List<VClass> getVClasses(EditConfigurationVTwo config, VitroRequest vreq) {
        Individual subject = EditConfigurationUtils.getIndividual((VitroRequest)vreq, (String)config.getSubjectUri());
        return subject.getVClasses();
    }

    private HashMap<String, List<LabelInformation>> getLabelsSortedByLanguageName(List<Literal> labels, Map<String, String> localeCodeToNameMap, EditConfigurationVTwo config, VitroRequest vreq) {
        String subjectUri = config.getSubjectUri();
        String propertyUri = config.getPredicateUri();
        Property prop = new Property();
        prop.setURI(propertyUri);
        HashMap<String, List<LabelInformation>> labelsHash = new HashMap<String, List<LabelInformation>>();
        for (Literal l : labels) {
            String languageTag = l.getLanguage();
            String languageName = "";
            if (languageTag == "") {
                languageName = "untyped";
            } else if (localeCodeToNameMap.containsKey(languageTag)) {
                languageName = localeCodeToNameMap.get(languageTag);
            } else {
                log.warn((Object)("This language tag " + languageTag + " does not have corresponding name in the system and was not processed"));
            }
            if (languageName == "") continue;
            if (!labelsHash.containsKey(languageName)) {
                labelsHash.put(languageName, new ArrayList());
            }
            ArrayList labelsList = (ArrayList)labelsHash.get(languageName);
            DataPropertyStatementTemplateModel dpstm = new DataPropertyStatementTemplateModel(subjectUri, prop, l, template, vreq);
            labelsList.add(new LabelInformation(l, dpstm.getEditUrl(), dpstm.getDeleteUrl(), languageTag, languageName));
        }
        LabelInformationComparator lic = new LabelInformationComparator();
        for (String languageName : labelsHash.keySet()) {
            List<LabelInformation> labelInfo = labelsHash.get(languageName);
            Collections.sort(labelInfo, lic);
        }
        return labelsHash;
    }

    private ArrayList<Literal> getExistingLabels(String subjectUri, VitroRequest vreq) {
        String queryStr = QueryUtils.subUriForQueryVar((String)LABEL_QUERY, (String)"subject", (String)subjectUri);
        log.debug((Object)("queryStr = " + queryStr));
        ArrayList<Literal> labels = new ArrayList<Literal>();
        try {
            ResultSet results = QueryUtils.getLanguageNeutralQueryResults((String)queryStr, (VitroRequest)vreq);
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Literal nodeLiteral = soln.get("label").asLiteral();
                labels.add(nodeLiteral);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return labels;
    }

    protected String getEditForm() {
        return null;
    }

    protected String getTemplate() {
        return template;
    }

    public List<HashMap<String, String>> getLocales(VitroRequest vreq) {
        List selectables = SelectedLocale.getSelectableLocales((HttpServletRequest)vreq);
        if (selectables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        Locale currentLocale = SelectedLocale.getCurrentLocale((HttpServletRequest)vreq);
        for (Locale locale : selectables) {
            try {
                list.add(this.buildLocaleMap(locale, currentLocale));
            }
            catch (FileNotFoundException e) {
                log.warn((Object)("Can't show the Locale selector for '" + locale + "': " + e));
            }
        }
        return list;
    }

    public HashMap<String, String> getFullCodeToLanguageNameMap(List<HashMap<String, String>> localesList) {
        HashMap<String, String> codeToLanguageMap = new HashMap<String, String>();
        for (Map map : localesList) {
            String code = (String)map.get("code");
            String label = (String)map.get("label");
            if (!codeToLanguageMap.containsKey(code)) {
                codeToLanguageMap.put(code, label);
                continue;
            }
            log.warn((Object)("Language code " + code + " for " + label + " was not associated in map becayse label already exists"));
        }
        return codeToLanguageMap;
    }

    public List<String> getFullLanguagesNamesSortedList(List<Map<String, Object>> localesList) {
        HashSet<String> languageNamesSet = new HashSet<String>();
        for (Map<String, Object> locale : localesList) {
            String label = (String)locale.get("label");
            if (languageNamesSet.contains(label)) continue;
            languageNamesSet.add(label);
        }
        ArrayList<String> languageNames = new ArrayList<String>(languageNamesSet);
        Collections.sort(languageNames);
        return languageNames;
    }

    private HashMap<String, String> buildLocaleMap(Locale locale, Locale currentLocale) throws FileNotFoundException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", locale.toString().replace("_", "-"));
        map.put("label", locale.getDisplayName(currentLocale));
        return map;
    }

    public class LabelInformation {
        private Literal labelLiteral = null;
        private String editLinkURL;
        private String deleteLinkURL;
        private String languageCode;
        private String languageName;

        public LabelInformation(Literal inputLiteral, String inputEditLinkURL, String inputDeleteLinkURL, String inputLanguageCode, String inputLanguageName) {
            this.labelLiteral = inputLiteral;
            this.editLinkURL = inputEditLinkURL;
            this.deleteLinkURL = inputDeleteLinkURL;
            this.languageCode = inputLanguageCode;
            this.languageName = inputLanguageName;
        }

        public Literal getLabelLiteral() {
            return this.labelLiteral;
        }

        public String getLabelStringValue() {
            return this.labelLiteral.getString();
        }

        public String getEditLinkURL() {
            return this.editLinkURL;
        }

        public String getDeleteLinkURL() {
            return this.deleteLinkURL;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public String getLanguageName() {
            return this.languageName;
        }
    }

    public static class LabelInformationComparator
    implements Comparator<LabelInformation> {
        @Override
        public int compare(LabelInformation l1, LabelInformation l2) {
            return l1.getLabelStringValue().compareTo(l2.getLabelStringValue());
        }
    }
}

