/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators;

import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationUtils;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.EditConfigurationVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.N3ValidatorVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.fields.FieldVTwo;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.BaseEditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.generators.EditConfigurationGenerator;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.configuration.validators.AntiXssValidation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpSession;

public class VIVONewIndividualFormGenerator
extends BaseEditConfigurationGenerator
implements EditConfigurationGenerator {
    private String N3_PREFIX = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n";

    public EditConfigurationVTwo getEditConfiguration(VitroRequest vreq, HttpSession session) {
        EditConfigurationVTwo config = new EditConfigurationVTwo();
        config.setTemplate("newIndividualForm.ftl");
        config.setN3Required(VIVONewIndividualFormGenerator.list((Object[])new Object[]{"?newInd <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + this.getTypeOfNew(vreq) + "> ."}));
        config.setN3Optional(VIVONewIndividualFormGenerator.list((Object[])new Object[]{this.N3_PREFIX + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .\n" + " ?newInd <http://purl.obolibrary.org/obo/ARG_2000028> ?newVcardInd . \n" + " ?newVcardInd <http://purl.obolibrary.org/obo/ARG_2000029> ?newInd . \n" + " ?newVcardInd a vcard:Individual . \n" + " ?newVcardInd vcard:hasName  ?newVcardName . \n" + " ?newVcardName a vcard:Name . \n" + " ?newVcardName vcard:givenName ?firstName . \n" + " ?newVcardName vcard:familyName ?lastName . \n", this.N3_PREFIX + " ?newInd <" + RDFS.label.getURI() + "> ?label .", this.N3_PREFIX + "@prefix vcard: <http://www.w3.org/2006/vcard/ns#> .\n" + " ?newInd <http://purl.obolibrary.org/obo/ARG_2000028> ?newVcardInd . \n" + " ?newVcardInd a vcard:Individual . \n" + " ?newVcardInd vcard:hasName  ?newVcardName . \n" + " ?newVcardName a vcard:Name . \n" + " ?newVcardName <http://vivoweb.org/ontology/core#middleName> ?middleName ."}));
        config.addNewResource("newInd", vreq.getWebappDaoFactory().getDefaultNamespace());
        config.addNewResource("newVcardInd", vreq.getWebappDaoFactory().getDefaultNamespace());
        config.addNewResource("newVcardName", vreq.getWebappDaoFactory().getDefaultNamespace());
        config.setUrisOnform(VIVONewIndividualFormGenerator.list((Object[])new Object[0]));
        config.setLiteralsOnForm(VIVONewIndividualFormGenerator.list((Object[])new Object[]{"label", "firstName", "lastName", "middleName"}));
        this.setUrisAndLiteralsInScope(config);
        config.addField(new FieldVTwo().setName("firstName").setRangeDatatypeUri(XSD.xstring.getURI()).setValidators(this.getFirstNameValidators(vreq)));
        config.addField(new FieldVTwo().setName("middleName").setRangeDatatypeUri(XSD.xstring.getURI()).setValidators(this.getMiddleNameValidators(vreq)));
        config.addField(new FieldVTwo().setName("lastName").setRangeDatatypeUri(XSD.xstring.getURI()).setValidators(this.getLastNameValidators(vreq)));
        config.addField(new FieldVTwo().setName("label").setRangeDatatypeUri(XSD.xstring.getURI()).setValidators(this.getLabelValidators(vreq)));
        this.addFormSpecificData(config, vreq);
        config.addValidator((N3ValidatorVTwo)new AntiXssValidation());
        String formUrl = EditConfigurationUtils.getFormUrlWithoutContext((VitroRequest)vreq);
        config.setFormUrl(formUrl);
        config.setEntityToReturnTo(" ?newInd ");
        this.prepare(vreq, config);
        return config;
    }

    private List<String> getMiddleNameValidators(VitroRequest vreq) {
        ArrayList<String> validators = new ArrayList<String>();
        return validators;
    }

    private List<String> getFirstNameValidators(VitroRequest vreq) {
        ArrayList<String> validators = new ArrayList<String>();
        if (this.isPersonType(vreq)) {
            validators.add("nonempty");
        }
        return validators;
    }

    private List<String> getLastNameValidators(VitroRequest vreq) {
        ArrayList<String> validators = new ArrayList<String>();
        if (this.isPersonType(vreq)) {
            validators.add("nonempty");
        }
        return validators;
    }

    private List<String> getLabelValidators(VitroRequest vreq) {
        ArrayList<String> validators = new ArrayList<String>();
        if (!this.isPersonType(vreq)) {
            validators.add("nonempty");
        }
        return validators;
    }

    private String getTypeOfNew(VitroRequest vreq) {
        String typeUri = vreq.getParameter("typeOfNew");
        if (typeUri == null || typeUri.trim().isEmpty()) {
            return this.getFOAFPersonClassURI();
        }
        return typeUri;
    }

    public void addFormSpecificData(EditConfigurationVTwo editConfiguration, VitroRequest vreq) {
        HashMap<String, String> formSpecificData = new HashMap<String, String>();
        formSpecificData.put("typeName", this.getTypeName(vreq));
        if (this.isPersonType(vreq)) {
            formSpecificData.put("isPersonType", "true");
        } else {
            formSpecificData.put("isPersonType", "false");
        }
        editConfiguration.setFormSpecificData(formSpecificData);
    }

    private String getTypeName(VitroRequest vreq) {
        String typeOfNew = this.getTypeOfNew(vreq);
        VClass type = vreq.getWebappDaoFactory().getVClassDao().getVClassByURI(typeOfNew);
        return type.getName();
    }

    public String getFOAFPersonClassURI() {
        return "http://xmlns.com/foaf/0.1/Person";
    }

    public boolean isPersonType(VitroRequest vreq) {
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        Boolean isPersonType = Boolean.FALSE;
        String foafPersonType = this.getFOAFPersonClassURI();
        String typeOfNew = this.getTypeOfNew(vreq);
        List superTypes = wdf.getVClassDao().getAllSuperClassURIs(typeOfNew);
        superTypes.add(typeOfNew);
        if (superTypes != null) {
            for (String typeUri : superTypes) {
                if (!foafPersonType.equals(typeUri)) continue;
                isPersonType = Boolean.TRUE;
                break;
            }
        }
        return isPersonType;
    }

    private void setUrisAndLiteralsInScope(EditConfigurationVTwo editConfiguration) {
        HashMap<String, List<String>> urisInScope = new HashMap<String, List<String>>();
        urisInScope.put(editConfiguration.getVarNameForSubject(), Arrays.asList(editConfiguration.getSubjectUri()));
        urisInScope.put(editConfiguration.getVarNameForPredicate(), Arrays.asList(editConfiguration.getPredicateUri()));
        editConfiguration.setUrisInScope(urisInScope);
        editConfiguration.setLiteralsInScope(new HashMap());
    }
}

