/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coauthorship;

import com.hp.hpl.jena.query.Dataset;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.visualization.coauthorship.CoAuthorshipGraphMLWriter;
import edu.cornell.mannlib.vitro.webapp.visualization.coauthorship.CoAuthorshipQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CoAuthorshipData;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaborationData;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class CoAuthorshipRequestHandler
implements VisualizationRequestHandler {
    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("CoAuthorship does not provide Ajax Response.");
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("CoAuthorship does not provide Short URL Response.");
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String egoURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        CoAuthorshipQueryRunner queryManager = new CoAuthorshipQueryRunner(egoURI, vitroRequest, log);
        CoAuthorshipData authorNodesAndEdges = queryManager.getQueryResult();
        if ("coauthors_count_per_year".equalsIgnoreCase(visMode)) {
            return this.prepareCoauthorsCountPerYearDataResponse(authorNodesAndEdges);
        }
        if ("coauthors".equalsIgnoreCase(visMode)) {
            return this.prepareCoauthorsListDataResponse(authorNodesAndEdges);
        }
        if ("coauthor_network_download".equalsIgnoreCase(visMode)) {
            return this.prepareNetworkDownloadDataResponse(authorNodesAndEdges);
        }
        return this.prepareNetworkStreamDataResponse(authorNodesAndEdges);
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("CoAuthorship Visualization does not provide Standalone response.");
    }

    private String getCoauthorsListCSVContent(CollaborationData coAuthorshipData) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Co-author, Count\n");
        for (Collaborator currNode : coAuthorshipData.getCollaborators()) {
            if (currNode == coAuthorshipData.getEgoCollaborator()) continue;
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currNode.getCollaboratorName()));
            csvFileContent.append(",");
            csvFileContent.append(currNode.getNumOfActivities());
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private String getCoauthorsPerYearCSVContent(Map<String, Set<Collaborator>> yearToCoauthors) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Year, Count, Co-author(s)\n");
        for (Map.Entry<String, Set<Collaborator>> currentEntry : yearToCoauthors.entrySet()) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currentEntry.getKey()));
            csvFileContent.append(",");
            csvFileContent.append(currentEntry.getValue().size());
            csvFileContent.append(",");
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)this.getCoauthorNamesAsString(currentEntry.getValue())));
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private String getCoauthorNamesAsString(Set<Collaborator> coAuthors) {
        StringBuilder coAuthorsMerged = new StringBuilder();
        String coAuthorSeparator = "; ";
        for (Collaborator currCoAuthor : coAuthors) {
            coAuthorsMerged.append(currCoAuthor.getCollaboratorName() + coAuthorSeparator);
        }
        return StringUtils.removeEnd((String)coAuthorsMerged.toString(), (String)coAuthorSeparator);
    }

    private Map<String, String> prepareCoauthorsCountPerYearDataResponse(CollaborationData authorNodesAndEdges) {
        String outputFileName;
        Map<String, Set<Collaborator>> yearToCoauthors = new TreeMap<String, Set<Collaborator>>();
        if (authorNodesAndEdges.getCollaborators() != null && authorNodesAndEdges.getCollaborators().size() > 0) {
            outputFileName = UtilityFunctions.slugify(authorNodesAndEdges.getEgoCollaborator().getCollaboratorName()) + "_co-authors-per-year" + ".csv";
            yearToCoauthors = UtilityFunctions.getActivityYearToCollaborators(authorNodesAndEdges);
        } else {
            outputFileName = "no_co-authors-per-year.csv";
        }
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getCoauthorsPerYearCSVContent(yearToCoauthors));
        return fileData;
    }

    private Map<String, String> prepareCoauthorsListDataResponse(CollaborationData coAuthorshipData) {
        String outputFileName = "";
        outputFileName = coAuthorshipData.getCollaborators() != null && coAuthorshipData.getCollaborators().size() > 0 ? UtilityFunctions.slugify(coAuthorshipData.getEgoCollaborator().getCollaboratorName()) + "_co-authors" + ".csv" : "no_co-authors.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getCoauthorsListCSVContent(coAuthorshipData));
        return fileData;
    }

    private Map<String, String> prepareNetworkStreamDataResponse(CollaborationData authorNodesAndEdges) {
        CoAuthorshipGraphMLWriter coAuthorshipGraphMLWriter = new CoAuthorshipGraphMLWriter(authorNodesAndEdges);
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileContentType", "text/xml");
        fileData.put("fileContent", coAuthorshipGraphMLWriter.getCoAuthorshipGraphMLContent().toString());
        return fileData;
    }

    private Map<String, String> prepareNetworkDownloadDataResponse(CollaborationData authorNodesAndEdges) {
        String outputFileName = "";
        outputFileName = authorNodesAndEdges.getCollaborators() != null && authorNodesAndEdges.getCollaborators().size() > 0 ? UtilityFunctions.slugify(authorNodesAndEdges.getEgoCollaborator().getCollaboratorName()) + "_co-author-network.graphml" + ".xml" : "no_co-author-network.graphml.xml";
        CoAuthorshipGraphMLWriter coAuthorshipGraphMLWriter = new CoAuthorshipGraphMLWriter(authorNodesAndEdges);
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "text/xml");
        fileData.put("fileContent", coAuthorshipGraphMLWriter.getCoAuthorshipGraphMLContent().toString());
        return fileData;
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return null;
    }
}

