/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.responsevalues.ResponseValues;
import edu.cornell.mannlib.vitro.webapp.visualization.collaborationutils.CollaborationData;
import edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator.CoPIGrantCountConstructQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator.CoPIGrantCountQueryRunner;
import edu.cornell.mannlib.vitro.webapp.visualization.coprincipalinvestigator.CoPIGraphMLWriter;
import edu.cornell.mannlib.vitro.webapp.visualization.exceptions.MalformedQueryParametersException;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.Collaborator;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.VisualizationRequestHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class CoPIGrantCountRequestHandler
implements VisualizationRequestHandler {
    @Override
    public Object generateAjaxVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Co-PI Grant Count does not provide Ajax response.");
    }

    @Override
    public ResponseValues generateVisualizationForShortURLRequests(Map<String, String> parameters, VitroRequest vitroRequest, Log log, Dataset dataSource) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("Co-PI Grant Count does not provide Short URL response.");
    }

    @Override
    public Map<String, String> generateDataVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        String egoURI = vitroRequest.getParameter("uri");
        String visMode = vitroRequest.getParameter("vis_mode");
        CoPIGrantCountConstructQueryRunner constructQueryRunner = new CoPIGrantCountConstructQueryRunner(egoURI, vitroRequest.getRDFService(), log);
        Model constructedModel = constructQueryRunner.getConstructedModel();
        CoPIGrantCountQueryRunner queryManager = new CoPIGrantCountQueryRunner(egoURI, vitroRequest, log);
        CollaborationData investigatorNodesAndEdges = (CollaborationData)queryManager.getQueryResult();
        if ("copis_count_per_year".equalsIgnoreCase(visMode)) {
            return this.prepareCoPIsCountPerYearDataResponse(investigatorNodesAndEdges);
        }
        if ("copis".equalsIgnoreCase(visMode)) {
            return this.prepareCoPIsListDataResponse(investigatorNodesAndEdges);
        }
        if ("copi_network_download".equalsIgnoreCase(visMode)) {
            return this.prepareNetworkDownloadDataResponse(investigatorNodesAndEdges);
        }
        return this.prepareNetworkStreamDataResponse(investigatorNodesAndEdges);
    }

    @Override
    public ResponseValues generateStandardVisualization(VitroRequest vitroRequest, Log log, Dataset dataset) throws MalformedQueryParametersException {
        throw new UnsupportedOperationException("CoPI does not provide Standalone Response.");
    }

    private String getCoPIsListCSVContent(CollaborationData coPIData) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Co-investigator, Count\n");
        for (Collaborator currNode : coPIData.getCollaborators()) {
            if (currNode == coPIData.getEgoCollaborator()) continue;
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currNode.getCollaboratorName()));
            csvFileContent.append(",");
            csvFileContent.append(currNode.getNumOfActivities());
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private String getCoPIsPerYearCSVContent(Map<String, Set<Collaborator>> yearToCoPI) {
        StringBuilder csvFileContent = new StringBuilder();
        csvFileContent.append("Year, Count, Co-investigator(s)\n");
        for (Map.Entry<String, Set<Collaborator>> currentEntry : yearToCoPI.entrySet()) {
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)currentEntry.getKey()));
            csvFileContent.append(",");
            csvFileContent.append(currentEntry.getValue().size());
            csvFileContent.append(",");
            csvFileContent.append(StringEscapeUtils.escapeCsv((String)this.getCoPINamesAsString(currentEntry.getValue())));
            csvFileContent.append("\n");
        }
        return csvFileContent.toString();
    }

    private String getCoPINamesAsString(Set<Collaborator> coInvestigators) {
        StringBuilder coPIsMerged = new StringBuilder();
        String coPISeparator = ";";
        for (Collaborator currentCoPI : coInvestigators) {
            coPIsMerged.append(currentCoPI.getCollaboratorName() + coPISeparator);
        }
        return StringUtils.removeEnd((String)coPIsMerged.toString(), (String)coPISeparator);
    }

    private Map<String, String> prepareCoPIsCountPerYearDataResponse(CollaborationData piNodesAndEdges) {
        String outputFileName;
        Map<String, Set<Collaborator>> yearToCoPIs = new TreeMap<String, Set<Collaborator>>();
        if (piNodesAndEdges.getCollaborators() != null && piNodesAndEdges.getCollaborators().size() > 0) {
            outputFileName = UtilityFunctions.slugify(piNodesAndEdges.getEgoCollaborator().getCollaboratorName()) + "_co-investigators-per-year" + ".csv";
            yearToCoPIs = UtilityFunctions.getActivityYearToCollaborators(piNodesAndEdges);
        } else {
            outputFileName = "no_co-investigators-per-year.csv";
        }
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getCoPIsPerYearCSVContent(yearToCoPIs));
        return fileData;
    }

    private Map<String, String> prepareCoPIsListDataResponse(CollaborationData coPIData) {
        String outputFileName = "";
        outputFileName = coPIData.getCollaborators() != null && coPIData.getCollaborators().size() > 0 ? UtilityFunctions.slugify(coPIData.getEgoCollaborator().getCollaboratorName()) + "_co-investigators" + ".csv" : "no_co-investigators.csv";
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "application/octet-stream");
        fileData.put("fileContent", this.getCoPIsListCSVContent(coPIData));
        return fileData;
    }

    private Map<String, String> prepareNetworkStreamDataResponse(CollaborationData coPIData) {
        CoPIGraphMLWriter coPIGraphMLWriter = new CoPIGraphMLWriter(coPIData);
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileContentType", "text/xml");
        fileData.put("fileContent", coPIGraphMLWriter.getCoPIGraphMLContent().toString());
        return fileData;
    }

    private Map<String, String> prepareNetworkDownloadDataResponse(CollaborationData coPIData) {
        String outputFileName = "";
        outputFileName = coPIData.getCollaborators() != null && coPIData.getCollaborators().size() > 0 ? UtilityFunctions.slugify(coPIData.getEgoCollaborator().getCollaboratorName()) + "_co-investigator-network.graphml" + ".xml" : "no_co-investigator-network.graphml.xml";
        CoPIGraphMLWriter coPIGraphMLWriter = new CoPIGraphMLWriter(coPIData);
        HashMap<String, String> fileData = new HashMap<String, String>();
        fileData.put("fileName", outputFileName);
        fileData.put("fileContentType", "text/xml");
        fileData.put("fileContent", coPIGraphMLWriter.getCoPIGraphMLContent().toString());
        return fileData;
    }

    @Override
    public AuthorizationRequest getRequiredPrivileges() {
        return AuthorizationRequest.AUTHORIZED;
    }
}

