/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.visualization.personpubcount;

import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.SparklineData;
import edu.cornell.mannlib.vitro.webapp.visualization.valueobjects.YearToEntityCountDataElement;
import edu.cornell.mannlib.vitro.webapp.visualization.visutils.UtilityFunctions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;

public class PersonPublicationCountVisCodeGenerator {
    private static final String DEFAULT_VIS_CONTAINER_DIV_ID = "pub_count_vis_container";
    private Map<String, Integer> yearToPublicationCount;
    private Log log;
    private String individualURI;
    private SparklineData sparklineParameterVO;

    public PersonPublicationCountVisCodeGenerator(String individualURIParam, String visMode, String visContainer, Map<String, Integer> yearToPublicationCount, Log log) {
        this.individualURI = individualURIParam;
        this.yearToPublicationCount = yearToPublicationCount;
        this.log = log;
        this.sparklineParameterVO = this.setupSparklineParameters(visMode, visContainer);
    }

    private SparklineData setupSparklineParameters(String visMode, String providedVisContainerID) {
        SparklineData sparklineData = new SparklineData();
        sparklineData.setYearToActivityCount(this.yearToPublicationCount);
        int numOfYearsToBeRendered = 0;
        int currentYear = Calendar.getInstance().get(1) - 1;
        int shortSparkMinYear = currentYear - 10 + 1;
        HashSet<String> publishedYears = new HashSet<String>(this.yearToPublicationCount.keySet());
        publishedYears.remove("Unknown");
        int minPublishedYear = shortSparkMinYear;
        String visContainerID = null;
        if (this.yearToPublicationCount.size() > 0) {
            try {
                minPublishedYear = Integer.parseInt(Collections.min(publishedYears));
            }
            catch (NoSuchElementException e1) {
                this.log.debug((Object)("vis: " + e1.getMessage() + " error occurred for " + this.yearToPublicationCount.toString()));
            }
            catch (NumberFormatException e2) {
                this.log.debug((Object)("vis: " + e2.getMessage() + " error occurred for " + this.yearToPublicationCount.toString()));
            }
        }
        int minPubYearConsidered = 0;
        minPubYearConsidered = minPublishedYear > shortSparkMinYear ? shortSparkMinYear : minPublishedYear;
        numOfYearsToBeRendered = currentYear - minPubYearConsidered + 1;
        sparklineData.setNumOfYearsToBeRendered(numOfYearsToBeRendered);
        int publicationCounter = 0;
        int renderedFullSparks = 0;
        ArrayList<YearToEntityCountDataElement> yearToPublicationCountDataTable = new ArrayList<YearToEntityCountDataElement>();
        for (int publicationYear = minPubYearConsidered; publicationYear <= currentYear; ++publicationYear) {
            String stringPublishedYear = String.valueOf(publicationYear);
            Integer currentPublications = this.yearToPublicationCount.get(stringPublishedYear);
            if (currentPublications == null) {
                currentPublications = 0;
            }
            yearToPublicationCountDataTable.add(new YearToEntityCountDataElement(publicationCounter, stringPublishedYear, currentPublications));
            renderedFullSparks += currentPublications.intValue();
            ++publicationCounter;
        }
        sparklineData.setYearToEntityCountDataTable(yearToPublicationCountDataTable);
        sparklineData.setRenderedSparks(renderedFullSparks);
        Integer unknownYearPublications = 0;
        if (this.yearToPublicationCount.get("Unknown") != null) {
            unknownYearPublications = this.yearToPublicationCount.get("Unknown");
        }
        sparklineData.setUnknownYearPublications(unknownYearPublications);
        visContainerID = providedVisContainerID != null ? providedVisContainerID : DEFAULT_VIS_CONTAINER_DIV_ID;
        sparklineData.setVisContainerDivID(visContainerID);
        sparklineData.setEarliestYearConsidered(minPubYearConsidered);
        sparklineData.setEarliestRenderedPublicationYear(minPublishedYear);
        sparklineData.setLatestRenderedPublicationYear(currentYear);
        if (this.yearToPublicationCount.size() > 0) {
            sparklineData.setFullTimelineNetworkLink(UtilityFunctions.getCollaboratorshipNetworkLink(this.individualURI, "person_level", "coauthor"));
            sparklineData.setDownloadDataLink(UtilityFunctions.getCSVDownloadURL(this.individualURI, "person_pub_count", ""));
        }
        if ("short".equalsIgnoreCase(visMode)) {
            sparklineData.setEarliestRenderedPublicationYear(shortSparkMinYear);
            sparklineData.setShortVisMode(true);
        } else {
            sparklineData.setShortVisMode(false);
        }
        return sparklineData;
    }

    public SparklineData getValueObjectContainer() {
        return this.sparklineParameterVO;
    }
}

