/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vivo.auth.policy;

import edu.cornell.mannlib.vitro.webapp.auth.policy.ifaces.PolicyDecision;
import edu.cornell.mannlib.vitro.webapp.auth.policy.specialrelationships.RelationshipChecker;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.AbstractPropertyStatementAction;
import java.util.List;

public class InfoContentEntityChecker
extends RelationshipChecker {
    private static final String URI_INFO_CONTENT_TYPE = "http://purl.obolibrary.org/obo/IAO_0000030";
    private static final String URI_FEATURES_PROPERTY = "http://vivoweb.org/ontology/core#features";
    private static final String URI_AUTHORSHIP_TYPE = "http://vivoweb.org/ontology/core#Authorship";
    private static final String URI_EDITORSHIP_TYPE = "http://vivoweb.org/ontology/core#Editorship";
    private final String[] resourceUris;

    public InfoContentEntityChecker(AbstractPropertyStatementAction action) {
        super(action.getOntModel());
        this.resourceUris = action.getResourceUris();
    }

    public PolicyDecision isAuthorized(List<String> userUris) {
        for (String resourceUri : this.resourceUris) {
            if (!this.isInfoContentEntity(resourceUri)) continue;
            if (this.anyUrisInCommon(userUris, this.getUrisOfAuthors(resourceUri))) {
                return this.authorizedAuthor(resourceUri);
            }
            if (this.anyUrisInCommon(userUris, this.getUrisOfEditors(resourceUri))) {
                return this.authorizedEditor(resourceUri);
            }
            if (!this.anyUrisInCommon(userUris, this.getUrisOfFeatured(resourceUri))) continue;
            return this.authorizedFeatured(resourceUri);
        }
        return null;
    }

    private boolean isInfoContentEntity(String resourceUri) {
        return this.isResourceOfType(resourceUri, URI_INFO_CONTENT_TYPE);
    }

    private List<String> getUrisOfEditors(String resourceUri) {
        List allRelatedUris = this.getObjectsThroughLinkingNode(resourceUri, "http://vivoweb.org/ontology/core#relatedBy", URI_EDITORSHIP_TYPE, "http://vivoweb.org/ontology/core#relates");
        allRelatedUris.remove(resourceUri);
        return allRelatedUris;
    }

    private List<String> getUrisOfFeatured(String resourceUri) {
        return this.getObjectsOfProperty(resourceUri, URI_FEATURES_PROPERTY);
    }

    private List<String> getUrisOfAuthors(String resourceUri) {
        List allRelatedUris = this.getObjectsThroughLinkingNode(resourceUri, "http://vivoweb.org/ontology/core#relatedBy", URI_AUTHORSHIP_TYPE, "http://vivoweb.org/ontology/core#relates");
        allRelatedUris.remove(resourceUri);
        return allRelatedUris;
    }

    private PolicyDecision authorizedEditor(String uri) {
        return this.authorizedDecision("User is an editor of " + uri);
    }

    private PolicyDecision authorizedAuthor(String uri) {
        return this.authorizedDecision("User is author of " + uri);
    }

    private PolicyDecision authorizedFeatured(String uri) {
        return this.authorizedDecision("User is featured in " + uri);
    }
}

